/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowEngine;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor2;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.mwe.internal.core.debug.processing.DebugMonitor;

public class WorkflowRunner {
    private static final String PARAM = "p";
    private static final String MONITOR = "m";
    private static final String ANT = "a";
    private static final String CMDL = "c";
    private static final String ENGINE = "e";

    public static void main(String[] args) throws Exception {
        new Object();
        CommandLine line = WorkflowRunner.getCommandLine(args);
        boolean success = new WorkflowRunner().doRun(line, args);
        if (!success && line.hasOption(ANT)) {
            System.exit(1);
        }
    }

    @Deprecated
    public boolean run(String workFlowFile, ProgressMonitor theMonitor, Map<String, String> theParams, Map<String, ?> externalSlotContents) {
        return new WorkflowEngine().run(workFlowFile, theMonitor, theParams, externalSlotContents);
    }

    public boolean doRun(String[] progArgs, boolean debugMode, int port) throws Exception {
        WorkflowEngine runner = new WorkflowEngine();
        DebugMonitor monitor = null;
        if (debugMode) {
            monitor = new DebugMonitor();
            monitor.init(port);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        return runner.run(progArgs[0], monitor, params, null);
    }

    public boolean doRun(CommandLine line, String[] args) throws Exception {
        URL wfUrl;
        WorkflowEngine runner = new WorkflowEngine();
        if (line.hasOption(ENGINE)) {
            try {
                runner = (WorkflowEngine)Class.forName(line.getOptionValue(ENGINE)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HashMap<String, String> params = new HashMap();
        String wfFile = null;
        String[] monitorOptValues = line.getOptionValues(MONITOR);
        if (line.hasOption(CMDL)) {
            ArrayList<String> unprocessedArgs = new ArrayList<String>();
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.equals("-c") || arg.equals("--cmdLineProcessor")) {
                    ++i;
                } else if (arg.equals("-m") || arg.equals("--monitorClass")) {
                    i += monitorOptValues.length;
                } else if (arg.endsWith(".oaw") || arg.endsWith(".mwe")) {
                    if (wfFile != null) {
                        throw new IllegalStateException("Workflow file already defined as '" + wfFile + "'!");
                    }
                    wfFile = arg;
                } else {
                    unprocessedArgs.add(arg);
                }
                ++i;
            }
            Class<?> cmdLineProcessor = ResourceLoaderFactory.createResourceLoader().loadClass(line.getOptionValue(CMDL));
            if (cmdLineProcessor == null) {
                throw new IllegalStateException("cannot find class '" + line.getOptionValue(CMDL) + "' for command line processing.");
            }
            Method method = cmdLineProcessor.getMethod("processCmdLine", String[].class, Map.class, WorkflowContext.class);
            method.invoke(cmdLineProcessor.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), unprocessedArgs.toArray(new String[0]), params, runner.getContext());
        } else {
            params = this.resolveParams(line.getOptionValues(PARAM));
            wfFile = line.getArgs()[0];
        }
        if (wfFile == null || !wfFile.endsWith(".oaw") && !wfFile.endsWith(".mwe")) {
            this.wrongCall(line);
            return false;
        }
        ProgressMonitor monitor = null;
        if (monitorOptValues != null) {
            Class<?> clazz = ResourceLoaderFactory.createResourceLoader().loadClass(monitorOptValues[0]);
            if (clazz == null) {
                throw new ClassNotFoundException("Didn't find class " + monitorOptValues[0]);
            }
            monitor = (ProgressMonitor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (monitor instanceof ProgressMonitor2) {
                ((ProgressMonitor2)monitor).init(monitorOptValues);
            } else if (monitor instanceof DebugMonitor) {
                ((DebugMonitor)monitor).init(monitorOptValues);
            }
        }
        int index = 0;
        do {
            if ((wfUrl = ResourceLoaderFactory.createResourceLoader().getResource(wfFile)) != null || (index = wfFile.indexOf(47)) < 0) continue;
            wfFile = wfFile.substring(index + 1);
        } while (wfUrl == null && index >= 0);
        if (wfUrl == null) {
            String msg = "can't find the workflow file '" + line.getArgs()[0] + "' in the current class path";
            throw new IllegalStateException(msg);
        }
        return runner.run(wfFile, monitor, params, null);
    }

    protected static CommandLine getCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption(Option.builder((String)MONITOR).hasArg().argName("className,moreArgs").desc("the name of a class that implements ProgressMonitor. More arguments can be appended that will be injected to the monitor, if it has a init(String[] args) method.").longOpt("monitorClass").valueSeparator(',').build());
        options.addOption(Option.builder((String)ANT).longOpt("ant").desc("must be set when using in Ant context").build());
        Option paramOption = Option.builder((String)PARAM).argName("key=value").desc("external property that is handled as workflow property").hasArg().build();
        paramOption.setLongOpt("param");
        options.addOption(paramOption);
        options.addOption(Option.builder((String)CMDL).hasArg().argName("className").desc("the name of a class that implements a public method 'public void processCmdLine(String[] cmdLineArgs, Map paramsToUseInWorkflow, WorkflowContext ctx)'.").longOpt("cmdLineProcessor").build());
        Option runnerOption = Option.builder((String)ENGINE).argName("className").desc("WorkflowRunnerEngine class").hasArg().build();
        runnerOption.setLongOpt("engine");
        options.addOption(runnerOption);
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(options, args);
        return line;
    }

    protected Map<String, String> resolveParams(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (args == null) {
            return params;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] string = element.split("=", 2);
            if (string.length != 2) {
                throw new IllegalArgumentException("wrong param syntax (-pkey=value). was : " + element);
            }
            params.put(string[0], string[1]);
            ++n2;
        }
        return params;
    }

    protected void wrongCall(CommandLine line) {
        Options options = new Options();
        Option[] optionArray = line.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option o = optionArray[n2];
            options.addOption(o);
            ++n2;
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + WorkflowRunner.class.getName() + " some_workflow_file.mwe [options]\nor\njava " + WorkflowRunner.class.getName() + " some_workflow_file.oaw [options]\n", options);
        System.exit(0);
    }
}

