/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmPersistenceUnitDefaults2_0;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;

public abstract class AbstractOrmPersistenceUnitDefaults
extends AbstractOrmXmlContextModel<OrmPersistenceUnitMetadata>
implements OrmPersistenceUnitDefaults2_0 {
    protected AccessType specifiedAccess = this.buildSpecifiedAccess();
    protected String specifiedCatalog = this.buildSpecifiedCatalog();
    protected String defaultCatalog;
    protected String specifiedSchema = this.buildSpecifiedSchema();
    protected String defaultSchema;
    protected boolean cascadePersist = this.buildCascadePersist();
    protected boolean delimitedIdentifiers = this.buildDelimitedIdentifiers();

    protected AbstractOrmPersistenceUnitDefaults(OrmPersistenceUnitMetadata parent) {
        super(parent);
        this.defaultCatalog = this.buildDefaultCatalog();
        this.defaultSchema = this.buildDefaultSchema();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.setSpecifiedCatalog_(this.buildSpecifiedCatalog());
        this.setSpecifiedSchema_(this.buildSpecifiedSchema());
        this.setCascadePersist_(this.buildCascadePersist());
        this.setDelimitedIdentifiers_(this.buildDelimitedIdentifiers());
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setDefaultSchema(this.buildDefaultSchema());
    }

    @Override
    public AccessType getAccess() {
        return this.getSpecifiedAccess();
    }

    @Override
    public AccessType getDefaultAccess() {
        return null;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        if (ObjectTools.notEquals((Object)this.specifiedAccess, (Object)access)) {
            XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaultsForUpdate();
            this.setSpecifiedAccess_(access);
            xmlDefaults.setAccess(AccessType.toOrmResourceModel(access));
            this.removeXmlDefaultsIfUnset();
        }
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", old, access);
    }

    protected AccessType buildSpecifiedAccess() {
        XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaults();
        return xmlDefaults == null ? null : AccessType.fromOrmResourceModel(xmlDefaults.getAccess(), this.getJpaPlatform(), this.getResourceType());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        if (ObjectTools.notEquals((Object)this.specifiedCatalog, (Object)catalog)) {
            XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaultsForUpdate();
            this.setSpecifiedCatalog_(catalog);
            xmlDefaults.setCatalog(catalog);
            this.removeXmlDefaultsIfUnset();
        }
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaults();
        return xmlDefaults == null ? null : xmlDefaults.getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog() {
        return this.getJpaProject().getDefaultCatalog();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        if (ObjectTools.notEquals((Object)this.specifiedSchema, (Object)schema)) {
            XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaultsForUpdate();
            this.setSpecifiedSchema_(schema);
            xmlDefaults.setSchema(schema);
            this.removeXmlDefaultsIfUnset();
        }
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaults();
        return xmlDefaults == null ? null : xmlDefaults.getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema() {
        return this.getJpaProject().getDefaultSchema();
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    @Override
    public void setCascadePersist(boolean cascadePersist) {
        if (this.cascadePersist != cascadePersist) {
            XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaultsForUpdate();
            this.setCascadePersist_(cascadePersist);
            xmlDefaults.setCascadePersist(cascadePersist);
            this.removeXmlDefaultsIfUnset();
        }
    }

    protected void setCascadePersist_(boolean cascadePersist) {
        boolean old = this.cascadePersist;
        this.cascadePersist = cascadePersist;
        this.firePropertyChanged("cascadePersist", old, cascadePersist);
    }

    protected boolean buildCascadePersist() {
        XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaults();
        return xmlDefaults == null ? false : xmlDefaults.isCascadePersist();
    }

    @Override
    public boolean isDelimitedIdentifiers() {
        return this.delimitedIdentifiers;
    }

    @Override
    public void setDelimitedIdentifiers(boolean delimitedIdentifiers) {
        if (this.delimitedIdentifiers != delimitedIdentifiers) {
            XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaultsForUpdate();
            this.setDelimitedIdentifiers_(delimitedIdentifiers);
            xmlDefaults.setDelimitedIdentifiers(delimitedIdentifiers);
            this.removeXmlDefaultsIfUnset();
        }
    }

    protected void setDelimitedIdentifiers_(boolean di) {
        boolean old = this.delimitedIdentifiers;
        this.delimitedIdentifiers = di;
        this.firePropertyChanged("delimitedIdentifiers", old, di);
    }

    protected boolean buildDelimitedIdentifiers() {
        XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaults();
        return xmlDefaults == null ? false : xmlDefaults.isDelimitedIdentifiers();
    }

    protected XmlPersistenceUnitDefaults getXmlDefaults() {
        XmlPersistenceUnitMetadata xmlMetadata = this.getXmlPersistenceUnitMetadata();
        return xmlMetadata == null ? null : xmlMetadata.getPersistenceUnitDefaults();
    }

    protected XmlPersistenceUnitMetadata getXmlPersistenceUnitMetadata() {
        return this.getPersistenceUnitMetadata().getXmlPersistenceUnitMetadata();
    }

    protected XmlPersistenceUnitDefaults getXmlDefaultsForUpdate() {
        XmlPersistenceUnitMetadata xmlMetadata = this.getXmlPersistenceUnitMetadataForUpdate();
        XmlPersistenceUnitDefaults xmlDefaults = xmlMetadata.getPersistenceUnitDefaults();
        return xmlDefaults != null ? xmlDefaults : this.buildXmlDefaults(xmlMetadata);
    }

    protected XmlPersistenceUnitMetadata getXmlPersistenceUnitMetadataForUpdate() {
        return this.getPersistenceUnitMetadata().getXmlPersistenceUnitMetadataForUpdate();
    }

    protected XmlPersistenceUnitDefaults buildXmlDefaults(XmlPersistenceUnitMetadata xmlMetadata) {
        XmlPersistenceUnitDefaults xmlDefaults = this.buildXmlPersistenceUnitDefaults();
        xmlMetadata.setPersistenceUnitDefaults(xmlDefaults);
        return xmlDefaults;
    }

    protected abstract XmlPersistenceUnitDefaults buildXmlPersistenceUnitDefaults();

    protected void removeXmlDefaultsIfUnset() {
        if (this.getXmlDefaults().isUnset()) {
            this.getXmlPersistenceUnitMetadata().setPersistenceUnitDefaults(null);
            this.removeXmlPersistenceUnitMetadataIfUnset();
        }
    }

    protected void removeXmlPersistenceUnitMetadataIfUnset() {
        this.getPersistenceUnitMetadata().removeXmlPersistenceUnitMetadataIfUnset();
    }

    public OrmPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return (OrmPersistenceUnitMetadata)this.parent;
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlTextRange();
        return textRange != null ? textRange : this.getPersistenceUnitMetadata().getValidationTextRange();
    }

    protected TextRange getXmlTextRange() {
        XmlPersistenceUnitDefaults xmlDefaults = this.getXmlDefaults();
        return xmlDefaults == null ? null : xmlDefaults.getValidationTextRange();
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.schemaTouches(pos)) {
            return this.getCandidateSchemata();
        }
        if (this.catalogTouches(pos)) {
            return this.getCandidateCatalogs();
        }
        return null;
    }

    protected boolean schemaTouches(int pos) {
        return this.getXmlDefaults() != null && this.getXmlDefaults().schemaTouches(pos);
    }

    protected Iterable<String> getCandidateSchemata() {
        SchemaContainer schemaContainer = this.getDbSchemaContainer();
        return schemaContainer != null ? schemaContainer.getSortedSchemaIdentifiers() : EmptyIterable.instance();
    }

    protected boolean catalogTouches(int pos) {
        return this.getXmlDefaults() != null && this.getXmlDefaults().catalogTouches(pos);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }
}

