/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.dialogs;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSHandlerUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class HandlerChainSelectionDialog
extends ElementTreeSelectionDialog {
    private static final String XML_FILE_EXTENSION = "xml";
    private IStatus ok_status = new Status(0, "org.eclipse.jst.ws.jaxws.ui", "");

    public HandlerChainSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setTitle(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_EDIT_DIALOG_TITLE);
        this.setMessage(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_EDIT_DIALOG_DESCRIPTION);
        this.setAllowMultiple(false);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Object selected;
                if (selection.length > 0 && (selected = selection[0]) instanceof IFile) {
                    IFile file = (IFile)selected;
                    try {
                        if (file.getFileExtension().equals(HandlerChainSelectionDialog.XML_FILE_EXTENSION) && JAXWSHandlerUtils.isHandlerChainFile((IFile)file)) {
                            return HandlerChainSelectionDialog.this.ok_status;
                        }
                    }
                    catch (IOException ioe) {
                        JAXWSUIPlugin.log(ioe);
                    }
                }
                return new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_EDIT_DIALOG_INVALID);
            }
        });
    }
}

