/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.common.ATLExecutionException;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.engine.ProblemConverter;
import org.eclipse.m2m.atl.engine.asm.ASMEmitter;
import org.eclipse.m2m.atl.engine.compiler.AtlStandaloneCompiler;
import org.eclipse.m2m.atl.engine.compiler.CompileTimeError;
import org.eclipse.m2m.atl.engine.emfvm.launch.EMFVMLauncher;
import org.eclipse.m2m.atl.engine.parser.AtlParser;

public abstract class AtlDefaultCompiler
implements AtlStandaloneCompiler {
    private static OutputStream asmOutputStream;
    private static ILauncher launcher;

    static {
        launcher = new EMFVMLauncher();
    }

    @Override
    public final CompileTimeError[] compile(InputStream in, String outputFileName) {
        return this.compile(new InputStreamReader(in), outputFileName);
    }

    @Override
    public final CompileTimeError[] compile(Reader in, String outputFileName) {
        EObject[] eObjects = this.internalCompile(in, outputFileName);
        CompileTimeError[] result = new CompileTimeError[eObjects.length];
        int i = 0;
        while (i < eObjects.length) {
            result[i] = ProblemConverter.convertProblem(eObjects[i]);
            ++i;
        }
        return result;
    }

    @Override
    public EObject[] compileWithProblemModel(InputStream in, String outputFileName) {
        return this.compileWithProblemModel((Reader)new InputStreamReader(in), outputFileName);
    }

    @Override
    public EObject[] compileWithProblemModel(Reader in, String outputFileName) {
        return this.internalCompile(in, outputFileName);
    }

    @Override
    public EObject[] compileWithProblemModel(InputStream in, OutputStream outputStream) {
        return this.compileWithProblemModel((Reader)new InputStreamReader(in), outputStream);
    }

    @Override
    public EObject[] compileWithProblemModel(Reader in, OutputStream outputStream) {
        asmOutputStream = outputStream;
        return this.internalCompile(in, "DIRECT_COMPILATION");
    }

    @Override
    public EObject[] compileWithProblemModel(IModel atlModel, String outputFileName) {
        try {
            return this.internalCompile(atlModel, outputFileName);
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public EObject[] compileWithProblemModel(IModel atlModel, OutputStream outputStream) {
        try {
            asmOutputStream = outputStream;
            return this.internalCompile(atlModel, "DIRECT_COMPILATION");
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    protected abstract URL getSemanticAnalyzerURL();

    protected abstract URL getCodegeneratorURL();

    private Object[] getProblems(IModel problems, EObject[] prev) {
        Object[] ret = new Object[2];
        EObject[] pbsa = null;
        Set pbs = problems.getElementsByType(problems.getReferenceModel().getMetaElementByName("Problem"));
        int nbErrors = 0;
        if (pbs != null) {
            pbsa = new EObject[pbs.size() + prev.length];
            System.arraycopy(prev, 0, pbsa, 0, prev.length);
            int k = prev.length;
            for (EObject ame : pbs) {
                pbsa[k++] = ame;
                EStructuralFeature severityFeature = ame.eClass().getEStructuralFeature("severity");
                if (!"error".equals(((Enumerator)ame.eGet(severityFeature)).getName())) continue;
                ++nbErrors;
            }
        }
        ret[0] = new Integer(nbErrors);
        ret[1] = pbsa;
        return ret;
    }

    public EObject[] internalCompile(Reader in, String outputFileName) {
        HashMap<String, Class<ASMEmitter>> typeextensions;
        HashMap<String, Object> params;
        EObject[] ret = null;
        IModel[] parsed = null;
        try {
            parsed = AtlParser.getDefault().inject(in, null);
        }
        catch (ATLCoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        IModel atlmodel = parsed[0];
        IModel problems = parsed[1];
        Object[] a = this.getProblems(problems, new EObject[0]);
        int nbErrors = (Integer)a[0];
        ret = (EObject[])a[1];
        if (nbErrors == 0) {
            try {
                problems = problems.getModelFactory().newModel(problems.getReferenceModel());
            }
            catch (ATLCoreException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            launcher.initialize(null);
            launcher.addInModel(atlmodel, "IN", "ATL");
            launcher.addOutModel(problems, "OUT", "Problem");
            params = new HashMap<String, Object>();
            if (!Platform.isRunning()) {
                typeextensions = new HashMap<String, Class<ASMEmitter>>();
                typeextensions.put("ASMEmitter", ASMEmitter.class);
                params.put("typeextensions", typeextensions);
            }
            try {
                launcher.launch("run", null, params, new Object[]{launcher.loadModule(this.getSemanticAnalyzerURL().openStream())});
            }
            catch (IOException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (ATLExecutionException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            a = this.getProblems(problems, ret);
            nbErrors = (Integer)a[0];
            ret = (EObject[])a[1];
        }
        if (nbErrors == 0) {
            try {
                problems = problems.getModelFactory().newModel(problems.getReferenceModel());
            }
            catch (ATLCoreException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            launcher.initialize(null);
            launcher.addInModel(atlmodel, "IN", "ATL");
            launcher.addOutModel(problems, "OUT", "Problem");
            params = new HashMap();
            params.put("debug", "false");
            params.put("WriteTo", outputFileName);
            if (!Platform.isRunning()) {
                typeextensions = new HashMap();
                typeextensions.put("ASMEmitter", ASMEmitter.class);
                params.put("typeextensions", typeextensions);
            }
            try {
                launcher.addLibrary("typeencoding", launcher.loadModule(AtlDefaultCompiler.class.getResource("resources/typeencoding.asm").openStream()));
                launcher.addLibrary("strings", launcher.loadModule(AtlDefaultCompiler.class.getResource("resources/strings.asm").openStream()));
                launcher.launch("run", null, params, new Object[]{launcher.loadModule(this.getCodegeneratorURL().openStream())});
            }
            catch (IOException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (ATLExecutionException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            a = this.getProblems(problems, ret);
            nbErrors = (Integer)a[0];
            ret = (EObject[])a[1];
        }
        return ret;
    }

    public EObject[] internalCompile(IModel atlmodel, String outputFileName) throws ATLCoreException, IOException, ATLExecutionException {
        IModel problems = AtlParser.getDefault().getModelFactory().newModel(AtlParser.getDefault().getProblemMetamodel());
        launcher.initialize(null);
        launcher.addInModel(atlmodel, "IN", "ATL");
        launcher.addOutModel(problems, "OUT", "Problem");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!Platform.isRunning()) {
            HashMap<String, Class<ASMEmitter>> typeextensions = new HashMap<String, Class<ASMEmitter>>();
            typeextensions.put("ASMEmitter", ASMEmitter.class);
            params.put("typeextensions", typeextensions);
        }
        launcher.launch("run", null, params, new Object[]{launcher.loadModule(this.getSemanticAnalyzerURL().openStream())});
        Object[] a = this.getProblems(problems, new EObject[0]);
        int nbErrors = (Integer)a[0];
        EObject[] ret = (EObject[])a[1];
        if (nbErrors == 0) {
            problems = problems.getModelFactory().newModel(problems.getReferenceModel());
            launcher.initialize(null);
            launcher.addInModel(atlmodel, "IN", "ATL");
            launcher.addOutModel(problems, "OUT", "Problem");
            params = new HashMap();
            params.put("debug", "false");
            params.put("WriteTo", outputFileName);
            if (!Platform.isRunning()) {
                HashMap<String, Class<ASMEmitter>> typeextensions = new HashMap<String, Class<ASMEmitter>>();
                typeextensions.put("ASMEmitter", ASMEmitter.class);
                params.put("typeextensions", typeextensions);
            }
            launcher.addLibrary("typeencoding", launcher.loadModule(AtlDefaultCompiler.class.getResource("resources/typeencoding.asm").openStream()));
            launcher.addLibrary("strings", launcher.loadModule(AtlDefaultCompiler.class.getResource("resources/strings.asm").openStream()));
            launcher.launch("run", null, params, new Object[]{launcher.loadModule(this.getCodegeneratorURL().openStream())});
            a = this.getProblems(problems, ret);
            nbErrors = (Integer)a[0];
            ret = (EObject[])a[1];
        }
        return ret;
    }

    public static OutputStream getCompilationOutputStream() {
        return asmOutputStream;
    }
}

