/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RepositoryCompletionProcessor
implements IContentAssistProcessor {
    private static final int MAX_OPEN_EDITORS = 10;
    private static final int MAX_ACTIVATED_TASKS = 10;
    private final TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);
    private final TaskRepository repository;
    private boolean neverIncludePrefix;

    public RepositoryCompletionProcessor(TaskRepository taskRepository) {
        this.repository = taskRepository;
        this.neverIncludePrefix = false;
    }

    public boolean getNeverIncludePrefix() {
        return this.neverIncludePrefix;
    }

    public void setNeverIncludePrefix(boolean includePrefix) {
        this.neverIncludePrefix = includePrefix;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        int i;
        int count;
        IWorkbenchPage page;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        ProposalComputer proposalComputer = new ProposalComputer(viewer, offset);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IEditorReference[] editorReferences = page.getEditorReferences();
            count = 0;
            i = editorReferences.length - 1;
            while (i >= 0 && count < 10) {
                try {
                    TaskEditorInput input;
                    ITask task;
                    if (editorReferences[i].getEditorInput() instanceof TaskEditorInput && (task = (input = (TaskEditorInput)editorReferences[i].getEditorInput()).getTask()) != null && !(task instanceof LocalTask)) {
                        proposalComputer.addTask(task);
                        ++count;
                    }
                }
                catch (PartInitException input) {
                    // empty catch block
                }
                --i;
            }
        }
        TaskActivationHistory taskHistory = TasksUiPlugin.getTaskActivityManager().getTaskActivationHistory();
        ArrayList<AbstractTask> tasks = taskHistory.getPreviousTasks(TasksUiInternal.getContainersFromWorkingSet(TaskWorkingSetUpdater.getActiveWorkingSets(window)));
        count = 0;
        i = tasks.size() - 1;
        while (i >= 0 && count < 10) {
            AbstractTask task = (AbstractTask)tasks.get(i);
            if (!(task instanceof LocalTask)) {
                proposalComputer.addTask((ITask)task);
            }
            --i;
        }
        if (this.repository != null) {
            proposalComputer.addSeparator();
            TaskList taskList = TasksUiPlugin.getTaskList();
            tasks = new ArrayList<AbstractTask>(taskList.getAllTasks());
            proposalComputer.filterTasks(tasks);
            Collections.sort(tasks, (o1, o2) -> this.labelProvider.getText(o1).compareTo(this.labelProvider.getText(o2)));
            proposalComputer.addTasks(tasks);
        }
        return proposalComputer.getResult();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private class ProposalComputer {
        public static final String LABEL_SEPARATOR = " -------------------------------------------- ";
        private final Set<ITask> addedTasks = new HashSet<ITask>();
        private boolean addSeparator;
        private final int offset;
        private final String prefix;
        private final List<ICompletionProposal> resultList = new ArrayList<ICompletionProposal>();

        public ProposalComputer(ITextViewer viewer, int offset) {
            this.offset = offset;
            this.prefix = this.extractPrefix(viewer, offset).toLowerCase();
        }

        private void addProposal(ITask task, String replacement, boolean includeTaskPrefix) {
            if (this.addSeparator) {
                if (!this.addedTasks.isEmpty()) {
                    this.resultList.add((ICompletionProposal)this.createSeparator());
                }
                this.addSeparator = false;
            }
            this.resultList.add(new TaskCompletionProposal(RepositoryCompletionProcessor.this.repository, task, RepositoryCompletionProcessor.this.labelProvider, replacement, includeTaskPrefix, this.offset - this.prefix.length(), this.prefix.length()));
            this.addedTasks.add(task);
        }

        public void addSeparator() {
            this.addSeparator = true;
        }

        public void addTasks(List<AbstractTask> tasks) {
            for (AbstractTask task : tasks) {
                this.addTask((ITask)task);
            }
        }

        public void addTask(ITask task) {
            if (this.addedTasks.contains(task) || RepositoryCompletionProcessor.this.getNeverIncludePrefix() && !task.getRepositoryUrl().equals(RepositoryCompletionProcessor.this.repository.getRepositoryUrl())) {
                return;
            }
            String taskKey = task.getTaskKey();
            if (this.prefix.length() == 0) {
                this.addProposal(task, taskKey, !RepositoryCompletionProcessor.this.getNeverIncludePrefix());
            } else if (taskKey != null && taskKey.startsWith(this.prefix)) {
                this.addProposal(task, taskKey, false);
            } else if (this.containsPrefix(task)) {
                this.addProposal(task, taskKey, !RepositoryCompletionProcessor.this.getNeverIncludePrefix());
            }
        }

        private boolean containsPrefix(ITask task) {
            String haystack = TasksUiInternal.getTaskPrefix(task.getConnectorKind()) + " " + RepositoryCompletionProcessor.this.labelProvider.getText(task);
            String[] haystackTokens = haystack.split("\\s");
            String[] needles = this.prefix.trim().split("\\*");
            if (haystackTokens.length == 0 || needles.length == 0) {
                return false;
            }
            String[] stringArray = needles;
            int n = needles.length;
            int n2 = 0;
            while (n2 < n) {
                String needle = stringArray[n2];
                boolean matched = false;
                String[] stringArray2 = haystackTokens;
                int n3 = haystackTokens.length;
                int n4 = 0;
                while (n4 < n3) {
                    String haystackToken = stringArray2[n4];
                    if (haystackToken.toLowerCase().startsWith(needle)) {
                        matched = true;
                        break;
                    }
                    ++n4;
                }
                if (!matched) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private CompletionProposal createSeparator() {
            return new CompletionProposal("", this.offset, 0, 0, CommonImages.getImage((ImageDescriptor)CommonImages.SEPARATOR_LIST), LABEL_SEPARATOR, null, null);
        }

        /*
         * Unable to fully structure code
         */
        private String extractPrefix(ITextViewer viewer, int offset) {
            i = offset;
            document = viewer.getDocument();
            if (i <= document.getLength()) ** GOTO lbl7
            return "";
            {
                while (!Character.isWhitespace(c = document.getChar(i - 1)) && c != '(' && c != ':') {
                    --i;
lbl7:
                    // 2 sources

                    if (i > 0) continue;
                }
                if (i == offset && RepositoryCompletionProcessor.this.repository != null && (taskPrefix = TasksUiInternal.getTaskPrefix(RepositoryCompletionProcessor.this.repository.getConnectorKind())).length() > 1) {
                    try {
                        if (taskPrefix.equals(document.get(offset - taskPrefix.length(), taskPrefix.length()))) {
                            return taskPrefix;
                        }
                    }
                    catch (BadLocationException var6_7) {
                        // empty catch block
                    }
                }
                return document.get(i, offset - i);
            }
        }

        public void filterTasks(List<AbstractTask> tasks) {
            Iterator<AbstractTask> it = tasks.iterator();
            while (it.hasNext()) {
                ITask task = (ITask)it.next();
                if (this.select(task)) continue;
                it.remove();
            }
        }

        private boolean select(ITask task) {
            return !(task instanceof LocalTask) && (RepositoryCompletionProcessor.this.repository == null || task.getRepositoryUrl().equals(RepositoryCompletionProcessor.this.repository.getRepositoryUrl()));
        }

        public ICompletionProposal[] getResult() {
            return this.resultList.toArray(new ICompletionProposal[this.resultList.size()]);
        }
    }

    public static class TaskCompletionProposal
    implements ICompletionProposal {
        private final LabelProvider labelProvider;
        private final TaskRepository repository;
        private final ITask task;
        private final int replacementOffset;
        private final int replacementLength;
        private String replacement;
        private final String defaultReplacement;
        private final boolean includePrefix;

        public TaskCompletionProposal(TaskRepository repository, ITask task, LabelProvider labelProvider, String defaultReplacement, boolean includePrefix, int replacementOffset, int replacementLength) {
            this.labelProvider = labelProvider;
            this.repository = repository;
            this.task = task;
            this.defaultReplacement = defaultReplacement;
            this.includePrefix = includePrefix;
            this.replacementOffset = replacementOffset;
            this.replacementLength = replacementLength;
        }

        public void apply(IDocument document) {
            try {
                document.replace(this.replacementOffset, this.replacementLength, this.getReplacement());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public String getReplacement() {
            if (this.replacement == null) {
                this.replacement = this.defaultReplacement == null || this.repository == null || !this.repository.getRepositoryUrl().equals(this.task.getRepositoryUrl()) ? CopyTaskDetailsAction.getTextForTask(this.task) : (this.includePrefix ? TasksUiInternal.getTaskPrefix(this.task.getConnectorKind()) + this.defaultReplacement : this.defaultReplacement);
            }
            return this.replacement;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return this.labelProvider.getText((Object)this.task);
        }

        public Image getImage() {
            return this.labelProvider.getImage((Object)this.task);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.replacementOffset + this.getReplacement().length(), 0);
        }

        public TaskRepository getRepository() {
            return this.repository;
        }

        public ITask getTask() {
            return this.task;
        }
    }
}

