/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.TransportConfigurator;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.internal.tcp.TCPSelector;
import org.eclipse.net4j.internal.tcp.TCPServerConnector;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.tcp.ITCPAcceptor;
import org.eclipse.net4j.tcp.ITCPPassiveSelectorListener;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.Acceptor;
import org.eclipse.spi.net4j.InternalConnector;
import org.w3c.dom.Element;

public class TCPAcceptor
extends Acceptor
implements ITCPAcceptor,
ITCPPassiveSelectorListener {
    public static final boolean DEFAULT_START_SYNCHRONOUSLY = true;
    public static final long DEFAULT_SYNCHRONOUS_START_TIMEOUT = 10000L;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TCPAcceptor.class);
    private TCPSelector selector;
    @ReflectUtil.ExcludeFromDump
    private SelectionKey selectionKey;
    private boolean startSynchronously = true;
    private long synchronousStartTimeout = 10000L;
    @ReflectUtil.ExcludeFromDump
    private CountDownLatch startLatch;
    private ServerSocketChannel serverSocketChannel;
    private String address = "0.0.0.0";
    private int port = DEFAULT_PORT;

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public TCPSelector getSelector() {
        return this.selector;
    }

    public void setSelector(TCPSelector selector) {
        this.selector = selector;
    }

    public boolean isStartSynchronously() {
        return this.startSynchronously;
    }

    public void setStartSynchronously(boolean startSynchronously) {
        this.startSynchronously = startSynchronously;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    public long getSynchronousStartTimeout() {
        return this.synchronousStartTimeout;
    }

    public void setSynchronousStartTimeout(long synchronousStartTimeout) {
        this.synchronousStartTimeout = synchronousStartTimeout;
    }

    @Override
    public void handleRegistration(ITCPSelector selector, ServerSocketChannel serverSocketChannel) {
        InetSocketAddress addr = null;
        try {
            try {
                if (this.address != null) {
                    addr = new InetSocketAddress(InetAddress.getByName(this.address), this.port);
                }
                ServerSocket socket = serverSocketChannel.socket();
                socket.setReuseAddress(true);
                socket.bind(addr);
                if (addr == null) {
                    int colon;
                    this.address = socket.getInetAddress().toString();
                    if (this.address.startsWith("/")) {
                        this.address = this.address.substring(1);
                    }
                    if ((colon = this.address.indexOf(58)) != -1) {
                        this.port = Integer.parseInt(this.address.substring(colon + 1));
                        this.address = this.address.substring(0, colon);
                    }
                }
                this.selectionKey = serverSocketChannel.register(selector.getSocketSelector(), 16, this);
            }
            catch (Exception ex) {
                OM.LOG.error("Problem while binding " + addr, (Throwable)ex);
                this.deactivateAsync();
                if (this.startLatch != null) {
                    this.startLatch.countDown();
                }
            }
        }
        finally {
            if (this.startLatch != null) {
                this.startLatch.countDown();
            }
        }
    }

    @Override
    public void handleAccept(ITCPSelector selector, ServerSocketChannel serverSocketChannel) {
        try {
            SocketChannel socketChannel = serverSocketChannel.accept();
            if (socketChannel != null) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Accepted socketChannel " + socketChannel);
                }
                socketChannel.configureBlocking(false);
                TCPConnector connector = this.createConnector();
                this.prepareConnector((InternalConnector)connector);
                connector.setSocketChannel(socketChannel);
                connector.setSelector(selector);
                connector.activate();
            }
        }
        catch (ClosedChannelException ex) {
            this.deactivateAsync();
        }
        catch (Exception ex) {
            if (this.isActive()) {
                OM.LOG.error((Throwable)ex);
            }
            this.deactivateAsync();
        }
    }

    public String toString() {
        return MessageFormat.format("TCPAcceptor[{0}:{1}]", this.address, this.port);
    }

    protected TCPConnector createConnector() {
        return new TCPServerConnector(this);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.selector == null) {
            throw new IllegalStateException("selector == null");
        }
        if (this.startSynchronously) {
            this.startLatch = new CountDownLatch(1);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        this.selector.orderRegistration(this.serverSocketChannel, this);
        if (this.startLatch != null && !this.startLatch.await(this.synchronousStartTimeout, TimeUnit.MILLISECONDS)) {
            this.startLatch = null;
            IOUtil.closeSilent((Closeable)this.serverSocketChannel);
            throw new IOException("Registration with selector timed out after " + this.synchronousStartTimeout + " millis");
        }
    }

    protected void doDeactivate() throws Exception {
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
        this.cancelSelectionKey();
        Exception ex = IOUtil.closeSilent((Closeable)this.serverSocketChannel);
        if (ex != null && TRACER.isEnabled()) {
            TRACER.trace((Throwable)ex);
        }
        this.serverSocketChannel = null;
        super.doDeactivate();
    }

    protected void deactivateAsync() {
        this.cancelSelectionKey();
        this.getConfig().getReceiveExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TCPAcceptor.this.deactivate();
            }
        });
    }

    private void cancelSelectionKey() {
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
            this.selectionKey = null;
        }
    }

    public static class DescriptionParserFactory
    extends TransportConfigurator.AcceptorDescriptionParser.Factory
    implements TransportConfigurator.AcceptorDescriptionParser {
        public DescriptionParserFactory() {
            super("tcp");
        }

        public TransportConfigurator.AcceptorDescriptionParser create(String description) throws ProductCreationException {
            return this;
        }

        public String getAcceptorDescription(Element acceptorConfig) {
            String listenAddr = acceptorConfig.getAttribute("listenAddr");
            String port = acceptorConfig.getAttribute("port");
            return String.valueOf(listenAddr == null ? "" : listenAddr) + (StringUtil.isEmpty((String)port) ? "" : ":" + port);
        }
    }
}

