/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.InstanceScopeAnalysis;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;

public class AllInstancesNavigationStep
extends AbstractNavigationStep {
    private final OppositeEndFinder oppositeEndFinder;

    public AllInstancesNavigationStep(EClass sourceType, EClass targetType, OCLExpression debugInfo, OppositeEndFinder oppositeEndFinder) {
        super(sourceType, targetType, debugInfo);
        this.oppositeEndFinder = oppositeEndFinder;
    }

    @Override
    protected Set<AnnotatedEObject> navigate(AnnotatedEObject fromObject, TracebackCache cache, Notification changeEvent) {
        HashSet<AnnotatedEObject> result = new HashSet<AnnotatedEObject>();
        Object allInstancesLookupContext = changeEvent != null && changeEvent.getNotifier() != null ? (Notifier)changeEvent.getNotifier() : fromObject.getAnnotatedObject();
        for (EObject roi : InstanceScopeAnalysis.getAllPossibleContextInstances((Notifier)allInstancesLookupContext, this.getTargetType(), this.oppositeEndFinder)) {
            result.add(this.annotateEObject(fromObject, roi));
        }
        return result;
    }

    @Override
    public String contentToString(Map<NavigationStep, Integer> visited, int indent) {
        return "allInstances(" + this.getTargetType().getName() + ")";
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }
}

