/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.SemanticIdentity;

public class AssociationNavigationStep
extends AbstractNavigationStep {
    private final EReference toEnd;
    private final SemanticIdentity semanticIdentity;

    public AssociationNavigationStep(EClass sourceType, EClass targetType, EReference toEnd, OCLExpression debugInfo) {
        super(sourceType, targetType, debugInfo);
        this.toEnd = toEnd;
        this.semanticIdentity = new AssociationNavigationStepIdentity();
    }

    private SemanticIdentity getSemanticIdentityOfSuper() {
        return super.getSemanticIdentity();
    }

    @Override
    protected Set<AnnotatedEObject> navigate(AnnotatedEObject fromObject, TracebackCache cache, Notification changeEvent) {
        HashSet<AnnotatedEObject> result = new HashSet<AnnotatedEObject>();
        Object ref = fromObject.eGet((EStructuralFeature)this.toEnd);
        if (this.toEnd.isMany()) {
            if (ref instanceof EList) {
                for (Object elem : (EList)ref) {
                    if (!(elem instanceof EObject)) continue;
                    result.add(this.annotateEObject(fromObject, (EObject)elem));
                }
            }
        } else if (ref != null) {
            result.add(this.annotateEObject(fromObject, (EObject)ref));
        }
        return result;
    }

    @Override
    public String contentToString(Map<NavigationStep, Integer> visited, int indent) {
        return this.toEnd.getName();
    }

    @Override
    public SemanticIdentity getSemanticIdentity() {
        return this.semanticIdentity;
    }

    private class AssociationNavigationStepIdentity
    extends SemanticIdentity {
        private AssociationNavigationStepIdentity() {
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.hashCode() != o.hashCode()) {
                return false;
            }
            return AssociationNavigationStep.this.getSemanticIdentityOfSuper().equals(o) && AssociationNavigationStep.this.toEnd == ((AssociationNavigationStepIdentity)o).getNavigationStep().toEnd;
        }

        @Override
        public int calculateHashCode() {
            return AssociationNavigationStep.this.getSemanticIdentityOfSuper().hashCode() ^ AssociationNavigationStep.this.toEnd.hashCode();
        }

        private AssociationNavigationStep getNavigationStep() {
            return AssociationNavigationStep.this;
        }

        @Override
        public NavigationStep getStep() {
            return this.getNavigationStep();
        }
    }
}

