/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.string;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractSimpleUnaryOperation;
import org.eclipse.ocl.pivot.values.SequenceValue;

public class StringCharactersOperation
extends AbstractSimpleUnaryOperation {
    public static final @NonNull StringCharactersOperation INSTANCE = new StringCharactersOperation();
    public static final @NonNull CollectionTypeId SEQ_STRING = TypeId.SEQUENCE.getSpecializedId((ElementId)TypeId.STRING);

    @Override
    public @NonNull SequenceValue evaluate(@Nullable Object sourceVal) {
        String sourceString = StringCharactersOperation.asString(sourceVal);
        ArrayList<String> results = new ArrayList<String>(sourceString.length());
        int i = 0;
        while (i < sourceString.length()) {
            @NonNull String s = sourceString.substring(i, i + 1);
            results.add(s);
            ++i;
        }
        return StringCharactersOperation.createSequenceValue(SEQ_STRING, results);
    }
}

