/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.progress.IProgressService;

public abstract class PageCompareEditorInput
extends CompareEditorInput
implements IContentChangeListener {
    private CompareViewerPane pagePane;
    private ICompareInput hookedInput;

    protected PageCompareEditorInput(CompareConfiguration configuration) {
        super(configuration);
    }

    protected CompareViewerPane createStructureInputPane(Composite parent) {
        this.pagePane = new CompareViewerPane(parent, 0x800800){

            public void selectionChanged(SelectionChangedEvent ev) {
                ISelection selection = ev.getSelection();
                StructuredSelection newSelection = this.convertSelection(selection, false);
                SelectionChangedEvent newEv = new SelectionChangedEvent((ISelectionProvider)PageCompareEditorInput.this.pagePane, (ISelection)newSelection);
                super.selectionChanged(newEv);
            }

            private StructuredSelection convertSelection(ISelection selection, boolean prepare) {
                StructuredSelection newSelection;
                ICompareInput ci = PageCompareEditorInput.this.asCompareInput(selection);
                if (ci != null) {
                    if (prepare) {
                        PageCompareEditorInput.this.prepareCompareInput(ci);
                    }
                    newSelection = new StructuredSelection((Object)ci);
                } else {
                    newSelection = StructuredSelection.EMPTY;
                }
                return newSelection;
            }

            public ISelection getSelection() {
                return this.convertSelection(PageCompareEditorInput.this.getSelectionProvider().getSelection(), false);
            }

            public Object getInput() {
                return PageCompareEditorInput.this.getCompareResult();
            }

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                StructuredSelection newSelection = this.convertSelection(selection, true);
                super.open(new OpenEvent((Viewer)event.getSource(), (ISelection)newSelection));
            }

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                StructuredSelection newSelection = this.convertSelection(selection, true);
                super.doubleClick(new DoubleClickEvent((Viewer)event.getSource(), (ISelection)newSelection));
            }

            public void setInput(Object input) {
                super.setInput(input);
                Composite c = this.getParent();
                if (c instanceof Splitter) {
                    ((Splitter)c).setVisible((Control)this, true);
                }
                this.layout(true);
            }
        };
        ToolBarManager toolBarManager = CompareViewerPane.getToolBarManager((Composite)this.pagePane);
        IPage page = this.createPage(this.pagePane, (IToolBarManager)toolBarManager);
        this.pagePane.setContent(page.getControl());
        if (parent instanceof Splitter) {
            ((Splitter)parent).setVisible((Control)this.pagePane, false);
        }
        this.hookupListeners();
        return this.pagePane;
    }

    protected abstract IPage createPage(CompareViewerPane var1, IToolBarManager var2);

    protected abstract ISelectionProvider getSelectionProvider();

    protected void setPageDescription(String title) {
        this.pagePane.setText(title);
    }

    protected void handleDispose() {
        super.handleDispose();
        this.cleanupListeners();
        this.unhookContentChangeListener();
    }

    private void hookupListeners() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pagePane);
        }
        if (selectionProvider instanceof StructuredViewer) {
            StructuredViewer sv = (StructuredViewer)selectionProvider;
            sv.addOpenListener((IOpenListener)this.pagePane);
            sv.addDoubleClickListener((IDoubleClickListener)this.pagePane);
        }
    }

    private void cleanupListeners() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pagePane);
        }
        if (selectionProvider instanceof StructuredViewer) {
            StructuredViewer sv = (StructuredViewer)selectionProvider;
            sv.removeOpenListener((IOpenListener)this.pagePane);
            sv.removeDoubleClickListener((IDoubleClickListener)this.pagePane);
        }
    }

    private void hookContentChangeListener(ICompareInput node) {
        ITypedElement right;
        if (this.hookedInput == node) {
            return;
        }
        this.unhookContentChangeListener();
        this.hookedInput = node;
        ITypedElement left = node.getLeft();
        if (left instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)left).addContentChangeListener((IContentChangeListener)this);
        }
        if ((right = node.getRight()) instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)right).addContentChangeListener((IContentChangeListener)this);
        }
    }

    private void unhookContentChangeListener() {
        if (this.hookedInput != null) {
            ITypedElement right;
            ITypedElement left = this.hookedInput.getLeft();
            if (left instanceof IContentChangeNotifier) {
                ((IContentChangeNotifier)left).addContentChangeListener((IContentChangeListener)this);
            }
            if ((right = this.hookedInput.getRight()) instanceof IContentChangeNotifier) {
                ((IContentChangeNotifier)right).addContentChangeListener((IContentChangeListener)this);
            }
        }
    }

    protected ICompareInput asCompareInput(ISelection selection) {
        Object o;
        IStructuredSelection ss;
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (o = ss.getFirstElement()) instanceof ICompareInput) {
            return (ICompareInput)o;
        }
        return null;
    }

    protected final void prepareCompareInput(ICompareInput input) {
        if (input == null) {
            return;
        }
        ITypedElement left = input.getLeft();
        if (left instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement lrte = (LocalResourceTypedElement)left;
            lrte.enableSharedDocument(false);
        }
        IProgressService manager = PlatformUI.getWorkbench().getProgressService();
        try {
            manager.busyCursorWhile(monitor -> {
                this.prepareInput(input, this.getCompareConfiguration(), monitor);
                this.hookContentChangeListener(input);
            });
        }
        catch (InvocationTargetException e) {
            Utils.handle(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void contentChanged(IContentChangeNotifier source) {
        this.setDirty(true);
    }

    public boolean canRunAsJob() {
        return true;
    }

    protected abstract void prepareInput(ICompareInput var1, CompareConfiguration var2, IProgressMonitor var3) throws InvocationTargetException;
}

