/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.property.table.IPropertyTooltipSite;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.editparts.PropertyEditPart;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public class PropertyTableTooltipHelper
implements IPropertyTooltipSite {
    private static final Point OFFSET = new Point(12, 0);
    private final PropertyTable m_table;
    private Shell m_tooltip;
    private int m_x;
    private int m_y;

    public PropertyTableTooltipHelper(PropertyTable table) {
        this.m_table = table;
        this.m_table.getControl().addListener(7, new Listener(){

            public void handleEvent(Event event) {
                Control control = Display.getCurrent().getCursorControl();
                while (control != null) {
                    if (control == PropertyTableTooltipHelper.this.m_tooltip) {
                        return;
                    }
                    control = control.getParent();
                }
                PropertyTableTooltipHelper.this.hideTooltip();
            }
        });
        this.m_table.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PropertyTableTooltipHelper.this.hideTooltip();
            }
        });
    }

    @Override
    public PropertyTable getTable() {
        return this.m_table;
    }

    @Override
    public void hideTooltip() {
        if (this.m_tooltip != null && !this.m_tooltip.isDisposed()) {
            this.m_tooltip.dispose();
        }
        this.m_tooltip = null;
    }

    public void displayToolTipNear(PropertyEditPart.PropertyFigure hoverSource, int eventX, int eventY) {
        this.m_x = eventX;
        this.m_y = eventY;
        this.hideTooltip();
        PropertyTooltipProvider provider = hoverSource.getPropertyTooltipProvider();
        if (provider == null) {
            return;
        }
        this.m_tooltip = new Shell(this.m_table.getControl().getShell(), 540676);
        this.configureColors((Control)this.m_tooltip);
        GridLayoutFactory.create((Composite)this.m_tooltip).noMargins();
        Control control = provider.createTooltipControl(hoverSource.getProperty(), (Composite)this.m_tooltip, this);
        if (control == null) {
            this.hideTooltip();
            return;
        }
        Point tooltipLocation = provider.getTooltipPosition() == 0 ? this.m_table.getControl().toDisplay(new Point(this.m_x + PropertyTableTooltipHelper.OFFSET.x, this.m_y + PropertyTableTooltipHelper.OFFSET.y)) : this.m_table.getControl().toDisplay(new Point(this.m_x + PropertyTableTooltipHelper.OFFSET.x, this.m_y + PropertyTableTooltipHelper.OFFSET.y + this.getTable().getRowHeight()));
        this.m_tooltip.setLocation(tooltipLocation.x, tooltipLocation.y);
        if (!EnvironmentUtils.IS_WINDOWS) {
            this.m_tooltip.setSize(1000, 1000);
        }
        this.m_tooltip.setSize(this.m_tooltip.computeSize(-1, -1));
        provider.show(this.m_tooltip);
    }

    private void configureColors(Control control) {
        Display display = Display.getCurrent();
        control.setForeground(display.getSystemColor(28));
        control.setBackground(display.getSystemColor(29));
    }
}

