/*******************************************************************************
 * Copyright (c) 2001, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Jens Lukowski/Innoopract - initial renaming/restructuring
 *     
 *******************************************************************************/
/* The following code was generated by JFlex 1.3.5 on 3/14/05 9:37 PM */
/*nlsXXX*/
package org.eclipse.wst.dtd.core.internal.tokenizer;

import org.eclipse.wst.dtd.core.internal.parser.DTDRegionTypes;

/** 
 * Generate with "dtdskeleton".
 *
 * It removes some unused fields and avoids some compiler warnings 
 */


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.3.5
 * on 3/14/05 9:37 PM from the specification file
 * <tt>file:/D:/eclipse.wtp/workspace/org.eclipse.wst.dtd.core/src/org/eclipse/wst/dtd/core/internal/tokenizer/dtd.flex</tt>
 */
public class DTDTokenizer {

  /** This character denotes the end of file */
  final public static int YYEOF = -1;

  /** initial size of the lookahead buffer */
  final private static int YY_BUFFERSIZE = 16384;

  /** lexical states */
  final public static int ATTRIBUTE_ENUMERATION = 13;
  final public static int NOTATION_NAME = 6;
  final public static int ELEMENT_CHILD = 1;
  final public static int ENTITY_CONTENT = 4;
  final public static int COMMENT_CONTENT = 8;
  final public static int ATTLIST_NAME = 9;
  final public static int EXTERNALID_CONTENT = 7;
  final public static int ELEMENT_CONTENT = 1;
  final public static int ELEMENT_MIXED = 1;
  final public static int ELEMENT_MIXED_OR_CHILD = 1;
  final public static int ATTRIBUTE_CONTENT = 11;
  final public static int ENTITY_NAME = 3;
  final public static int ATTRIBUTE_DEFAULT = 12;
  final public static int ELEMENT_NAME = 2;
  final public static int YYINITIAL = 0;
  final public static int NDATA_CONTENT = 5;
  final public static int ATTLIST_CONTENT = 10;
  final public static int NODE = 1;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\10\0\1\0\1\5\1\3\1\0\1\0\1\2\22\0\1\5\1\6"+
    "\1\1\1\37\1\0\1\23\1\0\1\46\1\42\1\43\1\4\1\7"+
    "\1\45\1\12\1\0\1\0\12\0\1\0\1\10\1\11\1\0\1\13"+
    "\1\4\1\0\1\25\1\31\1\32\1\33\1\14\1\35\2\0\1\21"+
    "\1\0\1\36\1\15\1\16\1\17\1\24\1\27\1\40\1\34\1\26"+
    "\1\20\1\30\2\0\1\41\1\22\1\0\1\0\1\0\2\0\1\0"+
    "\1\0\32\0\1\0\1\44\uff83\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    39,    78,   117,   156,   195,   234,   273,   312,   351, 
      390,   429,   468,   507,   546,   585,   624,    39,    39,    39, 
      663,   702,   741,   780,   819,    39,    39,   858,   897,    39, 
       39,   936,   936,   975,  1014,  1053,  1092,  1131,  1170,  1209, 
     1248,  1287,  1326,  1365,  1404,  1443,    39,  1482,  1521,  1560, 
     1599,  1638,    39,  1677,  1716,  1755,  1794,  1833,  1872,    39, 
       39,  1911,  1950,  1989,  2028,  2067,  2106,    39,    39,    39, 
     2145,  2184,  2223,  2262,  2301,  2340,  2379,   897,  2418,   975, 
     2457,  2496,  2535,  2574,   975,  2613,  2652,  2691,  2730,  1560, 
     2769,  2808,  2847,  2886,  2925,  2964,  3003,  3042,  3081,  3120, 
     1950,  3159,  3198,  3237,  3276,  3315,  1950,    39,  3354,  3393, 
     3432,    39,  3471,  3510,  3549,    39,  3588,  3627,    39,  3666, 
     3705,  3744,    39,    39,  3783,  3822,  3861,  3900,  3939,  3978, 
     4017,  4056,    39,  4095,  4134,  4173,    39,  4212,  4251,  4290, 
     4329,  4368,  4407,  4446,  4485,  4524,  4563,  4602,  4641,  4680, 
     4719,  4758,  4797,  4836,  4875,  4914,  4953,  4992,  5031,  5070, 
     5109,  5148,  5187,  5226,  5265,  5304,  5343,   975,  5382,  5421, 
     5460,  5499,  5538,  5577,  1560,  5616,  5655,  5694,  5733,  5772, 
     5811,  5850,   546,  5889,  5928,  5967,  6006,   975,   975,   975, 
     6045,  1560,  6084,  6123,  1560,  6162,  6201,  6240,  1950,   546, 
     6279,   546,   819,  6318,  6357,  6396,  6435,  6474,  6513,   546, 
     6552,  1560,  1560,  1560,  1950,  6591,    39,  1950
  };

  /** 
   * The packed transition table of the DFA (part 0)
   */
  final private static String yy_packed0 = 
    "\2\17\2\20\1\17\1\20\1\21\1\17\1\22\1\23"+
    "\1\17\1\24\1\25\2\17\1\26\3\17\1\27\1\17"+
    "\1\30\21\17\47\0\2\31\2\20\1\32\1\20\1\0"+
    "\1\32\1\31\1\33\1\31\1\33\23\31\1\34\2\31"+
    "\1\35\1\36\2\37\1\31\2\40\2\20\1\0\1\20"+
    "\3\40\1\33\1\40\1\33\7\40\1\41\16\40\4\0"+
    "\1\40\1\42\1\43\2\20\1\42\1\20\3\42\1\33"+
    "\1\42\1\33\12\42\1\44\1\45\16\42\1\46\2\47"+
    "\2\20\1\47\1\20\3\47\1\33\1\47\1\33\33\47"+
    "\2\50\2\20\1\0\1\20\2\0\1\50\1\33\1\50"+
    "\1\33\26\50\4\0\1\50\1\42\1\43\2\20\1\42"+
    "\1\20\3\42\1\33\1\42\1\33\3\42\1\51\6\42"+
    "\1\52\1\53\16\42\1\46\2\54\2\55\1\54\1\55"+
    "\4\54\1\56\1\57\33\54\2\60\2\20\1\42\1\20"+
    "\2\42\1\60\1\33\1\60\1\33\26\60\4\42\1\60"+
    "\2\61\2\20\1\42\1\20\2\42\1\61\1\33\1\61"+
    "\1\33\26\61\4\42\1\61\1\62\1\63\1\64\1\65"+
    "\1\62\1\66\3\62\1\33\1\62\1\33\1\67\2\62"+
    "\1\70\1\62\1\71\10\62\1\72\4\62\1\73\2\62"+
    "\1\74\2\75\1\62\1\76\1\77\1\100\2\20\1\77"+
    "\1\20\3\77\1\33\1\77\1\33\23\77\1\101\6\77"+
    "\1\102\2\103\2\20\1\103\1\20\3\103\1\33\1\103"+
    "\1\33\26\103\1\104\1\105\1\106\2\103\2\17\2\0"+
    "\1\17\2\0\1\17\2\0\1\17\1\0\7\17\1\0"+
    "\23\17\2\0\2\20\1\0\1\20\53\0\1\107\34\0"+
    "\2\17\2\0\1\17\2\0\1\17\2\0\1\17\1\0"+
    "\1\17\1\110\1\17\1\111\3\17\1\0\25\17\2\0"+
    "\1\17\2\0\1\17\2\0\1\17\1\0\7\17\1\0"+
    "\1\112\22\17\2\113\2\0\1\113\2\0\1\113\2\0"+
    "\1\113\1\0\7\113\1\0\23\113\2\17\2\0\1\17"+
    "\2\0\1\17\2\0\1\17\1\0\4\17\1\114\2\17"+
    "\1\0\23\17\2\31\6\0\1\31\1\0\1\31\1\0"+
    "\26\31\4\0\3\31\6\0\1\31\1\0\1\31\1\0"+
    "\13\31\1\115\12\31\4\0\1\31\2\0\2\116\1\0"+
    "\1\116\31\0\1\117\7\0\2\40\4\0\3\40\1\0"+
    "\1\40\1\0\26\40\4\0\1\40\2\42\2\0\1\42"+
    "\1\0\3\42\1\0\1\42\1\0\33\42\1\43\1\120"+
    "\2\121\1\43\1\121\3\43\1\121\1\43\1\121\33\43"+
    "\2\42\2\0\1\42\1\0\3\42\1\0\1\42\1\0"+
    "\6\42\1\122\26\42\2\0\1\42\1\0\3\42\1\0"+
    "\1\42\1\0\14\42\1\123\16\42\2\46\2\124\1\46"+
    "\1\124\3\46\1\124\1\46\1\124\32\46\1\125\2\47"+
    "\2\0\1\47\1\0\3\47\1\0\1\47\1\0\33\47"+
    "\2\50\6\0\1\50\1\0\1\50\1\0\26\50\4\0"+
    "\1\50\2\42\2\0\1\42\1\0\3\42\1\0\1\42"+
    "\1\0\17\42\1\126\15\42\2\0\1\42\1\0\3\42"+
    "\1\0\1\42\1\0\6\42\1\127\26\42\2\0\1\42"+
    "\1\0\3\42\1\0\1\42\1\0\14\42\1\130\16\42"+
    "\12\54\2\0\35\54\2\55\1\54\1\55\4\54\2\0"+
    "\33\54\12\0\1\131\34\0\2\60\2\0\1\42\1\0"+
    "\2\42\1\60\1\0\1\60\1\0\26\60\4\42\1\60"+
    "\2\61\2\0\1\42\1\0\2\42\1\61\1\0\1\61"+
    "\1\0\26\61\4\42\1\61\2\62\2\0\1\62\1\0"+
    "\3\62\1\0\1\62\1\0\26\62\3\0\2\62\1\63"+
    "\1\132\2\133\1\63\1\133\3\63\1\133\1\63\1\133"+
    "\26\63\3\133\2\63\3\0\1\65\50\0\1\66\41\0"+
    "\2\62\2\0\1\62\1\0\3\62\1\0\1\62\1\0"+
    "\3\62\1\134\22\62\3\0\4\62\2\0\1\62\1\0"+
    "\3\62\1\0\1\62\1\0\2\62\1\135\5\62\1\136"+
    "\15\62\3\0\4\62\2\0\1\62\1\0\3\62\1\0"+
    "\1\62\1\0\17\62\1\137\6\62\3\0\4\62\2\0"+
    "\1\62\1\0\3\62\1\0\1\62\1\0\17\62\1\140"+
    "\6\62\3\0\4\62\2\0\1\62\1\0\3\62\1\0"+
    "\1\62\1\0\5\62\1\141\12\62\1\142\1\143\4\62"+
    "\3\0\2\62\2\76\2\144\1\76\1\144\3\76\1\144"+
    "\1\76\1\144\26\76\3\144\1\76\1\132\2\77\2\0"+
    "\1\77\1\0\3\77\1\0\1\77\1\0\33\77\1\100"+
    "\1\145\2\146\1\100\1\146\3\100\1\146\1\100\1\146"+
    "\33\100\2\77\2\0\1\77\1\0\3\77\1\0\1\77"+
    "\1\0\5\77\1\147\12\77\1\150\1\151\11\77\2\102"+
    "\2\152\1\102\1\152\3\102\1\152\1\102\1\152\32\102"+
    "\1\153\2\103\2\0\1\103\1\0\3\103\1\0\1\103"+
    "\1\0\26\103\3\0\2\103\12\0\1\154\34\0\2\17"+
    "\2\0\1\17\2\0\1\17\2\0\1\17\1\0\1\155"+
    "\6\17\1\0\25\17\2\0\1\17\2\0\1\17\2\0"+
    "\1\17\1\0\4\17\1\156\2\17\1\0\25\17\2\0"+
    "\1\17\2\0\1\17\2\0\1\17\1\0\4\17\1\157"+
    "\2\17\1\0\23\17\2\113\2\0\1\113\2\0\1\113"+
    "\1\160\1\0\1\113\1\0\7\113\1\0\23\113\2\17"+
    "\2\0\1\17\2\0\1\17\2\0\1\17\1\0\4\17"+
    "\1\161\2\17\1\0\23\17\2\31\6\0\1\31\1\0"+
    "\1\31\1\0\16\31\1\162\7\31\4\0\1\31\27\0"+
    "\1\163\17\0\1\121\1\164\45\121\2\42\2\0\1\42"+
    "\1\0\3\42\1\0\1\42\1\0\12\42\1\165\22\42"+
    "\2\0\1\42\1\0\3\42\1\0\1\42\1\0\15\42"+
    "\1\166\15\42\46\124\1\167\2\42\2\0\1\42\1\0"+
    "\3\42\1\0\1\42\1\0\11\42\1\170\23\42\2\0"+
    "\1\42\1\0\3\42\1\0\1\42\1\0\12\42\1\171"+
    "\22\42\2\0\1\42\1\0\3\42\1\0\1\42\1\0"+
    "\15\42\1\172\15\42\13\0\1\173\33\0\1\133\1\174"+
    "\45\133\2\62\2\0\1\62\1\0\3\62\1\0\1\62"+
    "\1\0\4\62\1\175\21\62\3\0\4\62\2\0\1\62"+
    "\1\0\3\62\1\0\1\62\1\0\4\62\1\176\21\62"+
    "\3\0\4\62\2\0\1\62\1\0\3\62\1\0\1\62"+
    "\1\0\4\62\1\177\21\62\3\0\4\62\2\0\1\62"+
    "\1\0\3\62\1\0\1\62\1\0\20\62\1\200\5\62"+
    "\3\0\4\62\2\0\1\62\1\0\3\62\1\0\1\62"+
    "\1\0\11\62\1\201\14\62\3\0\4\62\2\0\1\62"+
    "\1\0\3\62\1\0\1\62\1\0\2\62\1\202\23\62"+
    "\3\0\4\62\2\0\1\62\1\0\3\62\1\0\1\62"+
    "\1\0\1\203\25\62\3\0\4\62\2\0\1\62\1\0"+
    "\3\62\1\0\1\62\1\0\5\62\1\204\20\62\3\0"+
    "\2\62\46\144\1\174\1\146\1\205\45\146\2\77\2\0"+
    "\1\77\1\0\3\77\1\0\1\77\1\0\2\77\1\206"+
    "\32\77\2\0\1\77\1\0\3\77\1\0\1\77\1\0"+
    "\1\207\34\77\2\0\1\77\1\0\3\77\1\0\1\77"+
    "\1\0\5\77\1\210\25\77\46\152\1\211\2\17\2\0"+
    "\1\17\2\0\1\17\2\0\1\17\1\0\2\17\1\212"+
    "\4\17\1\0\25\17\2\0\1\17\2\0\1\17\2\0"+
    "\1\17\1\0\5\17\1\213\1\17\1\0\25\17\2\0"+
    "\1\17\2\0\1\17\2\0\1\17\1\0\7\17\1\0"+
    "\1\17\1\214\23\17\2\0\1\17\2\0\1\17\2\0"+
    "\1\17\1\0\1\17\1\215\5\17\1\0\23\17\2\31"+
    "\6\0\1\31\1\0\1\31\1\0\17\31\1\216\6\31"+
    "\4\0\1\31\32\0\1\217\14\0\2\42\2\0\1\42"+
    "\1\0\3\42\1\0\1\42\1\0\4\42\1\220\30\42"+
    "\2\0\1\42\1\0\3\42\1\0\1\42\1\0\1\42"+
    "\1\221\33\42\2\0\1\42\1\0\3\42\1\0\1\42"+
    "\1\0\4\42\1\222\30\42\2\0\1\42\1\0\3\42"+
    "\1\0\1\42\1\0\4\42\1\223\30\42\2\0\1\42"+
    "\1\0\3\42\1\0\1\42\1\0\1\42\1\224\31\42"+
    "\2\62\2\0\1\62\1\0\3\62\1\0\1\62\1\0"+
    "\5\62\1\225\20\62\3\0\4\62\2\0\1\62\1\0"+
    "\3\62\1\0\1\62\1\0\10\62\1\226\15\62\3\0"+
    "\4\62\2\0\1\62\1\0\3\62\1\0\1\62\1\0"+
    "\11\62\1\227\14\62\3\0\4\62\2\0\1\62\1\0"+
    "\3\62\1\0\1\62\1\0\1\230\25\62\3\0\4\62"+
    "\2\0\1\62\1\0\3\62\1\0\1\62\1\0\4\62"+
    "\1\231\21\62\3\0\4\62\2\0\1\62\1\0\3\62"+
    "\1\0\1\62\1\0\13\62\1\232\12\62\3\0\4\62"+
    "\2\0\1\62\1\0\3\62\1\0\1\62\1\0\24\62"+
    "\1\233\1\62\3\0\4\62\2\0\1\62\1\0\3\62"+
    "\1\0\1\62\1\0\25\62\1\234\3\0\2\62\2\77"+
    "\2\0\1\77\1\0\3\77\1\0\1\77\1\0\13\77"+
    "\1\235\21\77\2\0\1\77\1\0\3\77\1\0\1\77"+
    "\1\0\24\77\1\236\10\77\2\0\1\77\1\0\3\77"+
    "\1\0\1\77\1\0\25\77\1\237\5\77\2\17\2\0"+
    "\1\17\2\0\1\17\2\0\1\17\1\0\1\240\6\17"+
    "\1\0\25\17\2\0\1\17\2\0\1\17\2\0\1\17"+
    "\1\0\4\17\1\241\2\17\1\0\25\17\2\0\1\17"+
    "\2\0\1\17\2\0\1\17\1\0\4\17\1\242\2\17"+
    "\1\0\25\17\2\0\1\17\2\0\1\17\2\0\1\17"+
    "\1\0\5\17\1\243\1\17\1\0\23\17\2\31\6\0"+
    "\1\31\1\0\1\31\1\0\11\31\1\244\14\31\4\0"+
    "\1\31\33\0\1\245\13\0\2\42\2\0\1\42\1\0"+
    "\3\42\1\0\1\42\1\0\1\246\34\42\2\0\1\42"+
    "\1\0\3\42\1\0\1\42\1\0\5\42\1\247\27\42"+
    "\2\0\1\42\1\0\3\42\1\0\1\42\1\0\11\42"+
    "\1\250\23\42\2\0\1\42\1\0\3\42\1\0\1\42"+
    "\1\0\1\251\34\42\2\0\1\42\1\0\3\42\1\0"+
    "\1\42\1\0\5\42\1\252\25\42\2\62\2\0\1\62"+
    "\1\0\3\62\1\0\1\62\1\0\4\62\1\253\21\62"+
    "\3\0\4\62\2\0\1\62\1\0\3\62\1\0\1\62"+
    "\1\0\22\62\1\254\3\62\3\0\4\62\2\0\1\62"+
    "\1\0\3\62\1\0\1\62\1\0\4\62\1\255\21\62"+
    "\3\0\4\62\2\0\1\62\1\0\3\62\1\0\1\62"+
    "\1\0\21\62\1\256\4\62\3\0\4\62\2\0\1\62"+
    "\1\0\3\62\1\0\1\62\1\0\11\62\1\257\14\62"+
    "\3\0\4\62\2\0\1\62\1\0\3\62\1\0\1\62"+
    "\1\0\1\62\1\260\24\62\3\0\4\62\2\0\1\62"+
    "\1\0\3\62\1\0\1\62\1\0\14\62\1\261\11\62"+
    "\3\0\4\62\2\0\1\62\1\0\3\62\1\0\1\62"+
    "\1\0\1\262\25\62\3\0\2\62\2\77\2\0\1\77"+
    "\1\0\3\77\1\0\1\77\1\0\1\77\1\263\33\77"+
    "\2\0\1\77\1\0\3\77\1\0\1\77\1\0\14\77"+
    "\1\264\20\77\2\0\1\77\1\0\3\77\1\0\1\77"+
    "\1\0\1\265\32\77\2\17\2\0\1\17\2\0\1\17"+
    "\2\0\1\17\1\0\3\17\1\266\3\17\1\0\25\17"+
    "\2\0\1\17\2\0\1\17\2\0\1\17\1\0\6\17"+
    "\1\267\1\0\25\17\2\0\1\17\2\0\1\17\2\0"+
    "\1\17\1\0\5\17\1\270\1\17\1\0\25\17\2\0"+
    "\1\17\2\0\1\17\2\0\1\17\1\0\7\17\1\0"+
    "\2\17\1\271\20\17\2\31\6\0\1\31\1\0\1\31"+
    "\1\0\4\31\1\272\21\31\4\0\1\31\25\0\1\273"+
    "\21\0\2\42\2\0\1\42\1\0\3\42\1\0\1\42"+
    "\1\0\2\42\1\274\32\42\2\0\1\42\1\0\3\42"+
    "\1\0\1\42\1\0\16\42\1\274\16\42\2\0\1\42"+
    "\1\0\3\42\1\0\1\42\1\0\2\42\1\275\32\42"+
    "\2\0\1\42\1\0\3\42\1\0\1\42\1\0\16\42"+
    "\1\276\14\42\2\62\2\0\1\62\1\0\3\62\1\0"+
    "\1\62\1\0\5\62\1\277\1\300\17\62\3\0\4\62"+
    "\2\0\1\62\1\0\3\62\1\0\1\62\1\0\1\301"+
    "\25\62\3\0\4\62\2\0\1\62\1\0\3\62\1\0"+
    "\1\62\1\0\5\62\1\302\20\62\3\0\4\62\2\0"+
    "\1\62\1\0\3\62\1\0\1\62\1\0\12\62\1\303"+
    "\13\62\3\0\4\62\2\0\1\62\1\0\3\62\1\0"+
    "\1\62\1\0\5\62\1\234\20\62\3\0\4\62\2\0"+
    "\1\62\1\0\3\62\1\0\1\62\1\0\5\62\1\304"+
    "\20\62\3\0\4\62\2\0\1\62\1\0\3\62\1\0"+
    "\1\62\1\0\17\62\1\132\6\62\3\0\2\62\2\77"+
    "\2\0\1\77\1\0\3\77\1\0\1\77\1\0\5\77"+
    "\1\305\27\77\2\0\1\77\1\0\3\77\1\0\1\77"+
    "\1\0\5\77\1\306\27\77\2\0\1\77\1\0\3\77"+
    "\1\0\1\77\1\0\17\77\1\307\13\77\2\17\2\0"+
    "\1\17\2\0\1\17\2\0\1\17\1\0\4\17\1\310"+
    "\2\17\1\0\25\17\2\0\1\17\2\0\1\17\2\0"+
    "\1\17\1\0\7\17\1\0\1\311\24\17\2\0\1\17"+
    "\2\0\1\17\2\0\1\17\1\0\4\17\1\312\2\17"+
    "\1\0\23\17\2\31\6\0\1\31\1\0\1\31\1\0"+
    "\11\31\1\313\14\31\4\0\1\31\20\0\1\314\26\0"+
    "\2\62\2\0\1\62\1\0\3\62\1\0\1\62\1\0"+
    "\1\315\25\62\3\0\4\62\2\0\1\62\1\0\3\62"+
    "\1\0\1\62\1\0\3\62\1\316\22\62\3\0\4\62"+
    "\2\0\1\62\1\0\3\62\1\0\1\62\1\0\10\62"+
    "\1\317\15\62\3\0\4\62\2\0\1\62\1\0\3\62"+
    "\1\0\1\62\1\0\20\62\1\234\5\62\3\0\2\62"+
    "\2\77\2\0\1\77\1\0\3\77\1\0\1\77\1\0"+
    "\1\320\34\77\2\0\1\77\1\0\3\77\1\0\1\77"+
    "\1\0\20\77\1\321\12\77\2\17\2\0\1\17\2\0"+
    "\1\17\2\0\1\17\1\0\3\17\1\322\3\17\1\0"+
    "\23\17\25\0\1\323\21\0\2\62\2\0\1\62\1\0"+
    "\3\62\1\0\1\62\1\0\12\62\1\324\13\62\3\0"+
    "\4\62\2\0\1\62\1\0\3\62\1\0\1\62\1\0"+
    "\12\62\1\325\13\62\3\0\4\62\2\0\1\62\1\0"+
    "\3\62\1\0\1\62\1\0\3\62\1\326\22\62\3\0"+
    "\2\62\2\77\2\0\1\77\1\0\3\77\1\0\1\77"+
    "\1\0\17\77\1\327\15\77\2\0\1\77\1\0\3\77"+
    "\1\0\1\77\1\0\1\330\32\77\2\0\2\323\1\0"+
    "\1\323\35\0\1\331\3\0\2\77\2\0\1\77\1\0"+
    "\3\77\1\0\1\77\1\0\17\77\1\332\13\77";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack();


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     0,  8,  0,  0,  1,  1,  0,  1,  0,  1,  1,  1,  1,  1,  1,  1, 
     1,  9,  9,  9,  1,  1,  1,  1,  1,  9,  9,  1,  1,  9,  9,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  9,  1, 
     1,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  9,  9,  1,  1,  1, 
     1,  1,  1,  9,  9,  9,  0,  1,  1,  1,  0,  1,  1,  0,  0,  1, 
     0,  1,  1,  0,  1,  1,  1,  1,  0,  1,  0,  1,  1,  1,  1,  1, 
     1,  1,  1,  0,  1,  0,  1,  1,  1,  0,  1,  9,  1,  1,  1,  9, 
     1,  1,  0,  9,  1,  1,  9,  1,  1,  1,  9,  9,  1,  1,  1,  1, 
     1,  1,  1,  1,  9,  1,  1,  1,  9,  1,  1,  1,  1,  1,  0,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  1,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  1,  1,  1,  1, 
     1,  1,  0,  1,  1,  1,  1,  1,  9,  1
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  //private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  int yycolumn; 

  /** yy_atEOF == true <=> the scanner is at the EOF */
  private boolean yy_atEOF;

  /* user code: */
	int node_count = 0;
	String currentString;

	private Token createToken(String type) {
		return new Token(type, yytext(), yyline, yychar + startOffset, yylength());
	}

	private int startOffset = 0;
	public void setStartOffset(int offset) {
		this.startOffset = offset;
	}

	public void setLine(int line) {
		this.yyline = line;
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DTDTokenizer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public DTDTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the split, compressed DFA transition table.
   *
   * @return the unpacked transition table
   */
  private static int [] yy_unpack() {
    int [] trans = new int[6630];
    int offset = 0;
    offset = yy_unpack(yy_packed0, offset, trans);
    return trans;
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the index of the last entry
   */
  private static int yy_unpack(String packed, int offset, int [] trans) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 130) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean yy_refill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      //yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if (numRead < 0) {
      return true;
    }
    else {
      yy_endRead+= numRead;  
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */

    if (yy_reader != null)
      yy_reader.close();
  }


  /**
   * Closes the current stream, and resets the
   * scanner to read from a new input stream.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  final public void yyreset(java.io.Reader reader) throws java.io.IOException {
    yyclose();
    yy_reader = reader;
    yy_atEOF  = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = 0;//yy_pushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  final public char yycharat(int pos) {
    return yy_buffer[yy_startRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number)  {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Yytoken yylex() throws java.io.IOException {
    int yy_input;
    int yy_action;

    // cached fields:
    int yy_currentPos_l;
    int yy_markedPos_l;
    int yy_endRead_l = yy_endRead;
    char [] yy_buffer_l = yy_buffer;
    char [] yycmap_l = yycmap;

    int [] yytrans_l = yytrans;
    int [] yy_rowMap_l = yy_rowMap;
    byte [] yy_attr_l = YY_ATTRIBUTE;

    while (true) {
      yy_markedPos_l = yy_markedPos;

      yychar+= yy_markedPos_l-yy_startRead;

      yy_action = -1;

      yy_currentPos_l = yy_currentPos = 
                       yy_startRead = yy_markedPos_l;
  
      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {
    
          if (yy_currentPos_l < yy_endRead_l)
            yy_input = yy_buffer_l[yy_currentPos_l++];
          else if (yy_atEOF) {
            yy_input = YYEOF;
            break yy_forAction;
          }
          else {
            // store back cached positions
            yy_currentPos  = yy_currentPos_l;
            yy_markedPos   = yy_markedPos_l;
            boolean eof = yy_refill();
            // get translated positions and possibly new buffer
            yy_currentPos_l  = yy_currentPos;
            yy_markedPos_l   = yy_markedPos;
            yy_buffer_l      = yy_buffer;
            yy_endRead_l     = yy_endRead;
            if (eof) {
              yy_input = YYEOF;
              break yy_forAction;
            }
            else {
              yy_input = yy_buffer_l[yy_currentPos_l++];
            }
          }
          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = yy_attr_l[yy_state];
          if ( (yy_attributes & 1) == 1 ) {
            yy_action = yy_state; 
            yy_markedPos_l = yy_currentPos_l; 
            if ( (yy_attributes & 8) == 8 ) break yy_forAction;
          }

        }
      }

      // store back cached position
      yy_markedPos = yy_markedPos_l;

      switch (yy_action) {

        case 26: 
          {  yypushback(yylength()); yybegin(YYINITIAL);  }
        case 219: break;
        case 89: 
        case 123: 
          {  yypushback(yylength()); yybegin(ATTRIBUTE_DEFAULT);  }
        case 220: break;
        case 12: 
        case 62: 
        case 63: 
        case 64: 
        case 65: 
        case 102: 
        case 103: 
        case 104: 
        case 133: 
        case 134: 
        case 135: 
        case 156: 
        case 157: 
        case 158: 
        case 178: 
        case 179: 
        case 180: 
        case 196: 
        case 197: 
        case 207: 
        case 208: 
        case 215: 
          {  yypushback(yylength()); yybegin(ATTLIST_CONTENT);  }
        case 221: break;
        case 51: 
        case 52: 
          {  yypushback(yylength()); yybegin(ATTLIST_CONTENT);  }
        case 222: break;
        case 205: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.NMTOKEN_KEYWORD);  }
        case 223: break;
        case 194: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.IDREFS_KEYWORD);  }
        case 224: break;
        case 191: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.ENTITY_KEYWORD);  }
        case 225: break;
        case 107: 
          {  yybegin(COMMENT_CONTENT); return createToken(DTDRegionTypes.COMMENT_START);  }
        case 226: break;
        case 48: 
          {  yybegin(ATTRIBUTE_CONTENT); return createToken(DTDRegionTypes.ATTRIBUTE_NAME);  }
        case 227: break;
        case 39: 
          {  yybegin(EXTERNALID_CONTENT); return createToken(DTDRegionTypes.NAME);  }
        case 228: break;
        case 106: 
        case 136: 
          {  yybegin(ATTLIST_CONTENT); return createToken(DTDRegionTypes.SINGLEQUOTED_LITERAL);  }
        case 229: break;
        case 100: 
        case 132: 
          {  yybegin(ATTLIST_CONTENT); return createToken(DTDRegionTypes.DOUBLEQUOTED_LITERAL);  }
        case 230: break;
        case 202: 
        case 216: 
          {  return createToken(DTDRegionTypes.CONTENT_PCDATA);  }
        case 231: break;
        case 189: 
          {  return createToken(DTDRegionTypes.PUBLIC_KEYWORD);  }
        case 232: break;
        case 188: 
          {  return createToken(DTDRegionTypes.SYSTEM_KEYWORD);  }
        case 233: break;
        case 14: 
        case 20: 
        case 21: 
        case 23: 
        case 71: 
        case 72: 
        case 73: 
        case 75: 
        case 108: 
        case 109: 
        case 110: 
        case 112: 
        case 137: 
        case 138: 
        case 139: 
        case 140: 
        case 159: 
        case 160: 
        case 161: 
        case 162: 
        case 181: 
        case 183: 
        case 184: 
        case 200: 
          {  return createToken(DTDRegionTypes.UNKNOWN_CONTENT);  }
        case 234: break;
        case 4: 
        case 33: 
        case 34: 
        case 35: 
        case 36: 
        case 37: 
        case 81: 
        case 82: 
        case 116: 
        case 117: 
        case 143: 
        case 144: 
        case 165: 
        case 166: 
          {  return createToken(DTDRegionTypes.UNKNOWN_CONTENT);  }
        case 235: break;
        case 7: 
        case 40: 
        case 41: 
        case 42: 
        case 85: 
        case 86: 
        case 87: 
        case 119: 
        case 120: 
        case 121: 
        case 145: 
        case 146: 
        case 147: 
        case 168: 
        case 169: 
          {  return createToken(DTDRegionTypes.UNKNOWN_CONTENT);  }
        case 236: break;
        case 9: 
          {  return createToken(DTDRegionTypes.UNKNOWN_CONTENT);  }
        case 237: break;
        case 10: 
          {  return createToken(DTDRegionTypes.UNKNOWN_CONTENT);  }
        case 238: break;
        case 43: 
        case 45: 
        case 46: 
          {  return createToken(DTDRegionTypes.COMMENT_CONTENT);  }
        case 239: break;
        case 60: 
          {  return createToken(DTDRegionTypes.UNKNOWN_CONTENT);  }
        case 240: break;
        case 198: 
          {  return createToken(DTDRegionTypes.FIXED_KEYWORD);  }
        case 241: break;
        case 214: 
          {  yybegin(ATTLIST_CONTENT); return createToken(DTDRegionTypes.IMPLIED_KEYWORD);  }
        case 242: break;
        case 212: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.NMTOKENS_KEYWORD);  }
        case 243: break;
        case 211: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.ENTITIES_KEYWORD);  }
        case 244: break;
        case 209: 
          {  yybegin(NOTATION_NAME); return createToken(DTDRegionTypes.NOTATION_TAG);  }
        case 245: break;
        case 201: 
          {  yybegin(ATTLIST_NAME); return createToken(DTDRegionTypes.ATTLIST_TAG);  }
        case 246: break;
        case 199: 
          {  yybegin(ELEMENT_NAME); return createToken(DTDRegionTypes.ELEMENT_TAG);  }
        case 247: break;
        case 182: 
          {  yybegin(ENTITY_NAME); return createToken(DTDRegionTypes.ENTITY_TAG);  }
        case 248: break;
        case 167: 
          {  yybegin(NDATA_CONTENT); return createToken(DTDRegionTypes.NDATA_KEYWORD);  }
        case 249: break;
        case 111: 
          {  return createToken(DTDRegionTypes.ENTITY_PARM);  }
        case 250: break;
        case 94: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.ID_KEYWORD);  }
        case 251: break;
        case 25: 
          {  return createToken(DTDRegionTypes.OCCUR_TYPE);  }
        case 252: break;
        case 16: 
          {  return createToken(DTDRegionTypes.EXCLAMATION);  }
        case 253: break;
        case 15: 
          {  return createToken(DTDRegionTypes.WHITESPACE);  }
        case 254: break;
        case 11: 
        case 49: 
        case 50: 
        case 54: 
        case 55: 
        case 56: 
        case 57: 
        case 58: 
        case 61: 
        case 91: 
        case 92: 
        case 93: 
        case 95: 
        case 96: 
        case 97: 
        case 98: 
        case 124: 
        case 125: 
        case 126: 
        case 127: 
        case 128: 
        case 129: 
        case 130: 
        case 131: 
        case 148: 
        case 149: 
        case 150: 
        case 151: 
        case 152: 
        case 153: 
        case 154: 
        case 155: 
        case 170: 
        case 171: 
        case 172: 
        case 175: 
        case 176: 
        case 177: 
        case 190: 
        case 192: 
        case 193: 
        case 195: 
        case 204: 
        case 206: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.PARM_ENTITY_TYPE);  }
        case 255: break;
        case 28: 
          {  return createToken(DTDRegionTypes.LEFT_PAREN);  }
        case 256: break;
        case 29: 
          {  return createToken(DTDRegionTypes.RIGHT_PAREN);  }
        case 257: break;
        case 44: 
          {  return createToken(DTDRegionTypes.WHITESPACE);  }
        case 258: break;
        case 53: 
          {  return createToken(DTDRegionTypes.WHITESPACE);  }
        case 259: break;
        case 59: 
          {  yypushback(yylength()); yybegin(ATTRIBUTE_ENUMERATION);  }
        case 260: break;
        case 67: 
          {  return createToken(DTDRegionTypes.LEFT_PAREN);  }
        case 261: break;
        case 68: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.RIGHT_PAREN);  }
        case 262: break;
        case 69: 
          {  return createToken(DTDRegionTypes.ENUM_CHOICE);  }
        case 263: break;
        case 31: 
          {  yybegin(ENTITY_CONTENT); return createToken(DTDRegionTypes.NAME);  }
        case 264: break;
        case 47: 
          {  yybegin(ATTLIST_CONTENT); return createToken(DTDRegionTypes.NAME);  }
        case 265: break;
        case 187: 
          {  yypushback(yylength()); yybegin(EXTERNALID_CONTENT);  }
        case 266: break;
        case 213: 
          {  yybegin(ATTRIBUTE_ENUMERATION); return createToken(DTDRegionTypes.NOTATION_KEYWORD);  }
        case 267: break;
        case 174: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.CDATA_KEYWORD);  }
        case 268: break;
        case 173: 
          {  yybegin(ATTRIBUTE_DEFAULT); return createToken(DTDRegionTypes.IDREF_KEYWORD);  }
        case 269: break;
        case 217: 
          {  yybegin(ATTLIST_CONTENT); return createToken(DTDRegionTypes.REQUIRED_KEYWORD);  }
        case 270: break;
        case 122: 
          {  yybegin(YYINITIAL); return createToken(DTDRegionTypes.COMMENT_END);  }
        case 271: break;
        case 84: 
        case 118: 
          {  return createToken(DTDRegionTypes.SINGLEQUOTED_LITERAL);  }
        case 272: break;
        case 79: 
        case 115: 
          {  return createToken(DTDRegionTypes.DOUBLEQUOTED_LITERAL);  }
        case 273: break;
        case 24: 
        case 27: 
        case 76: 
        case 113: 
        case 141: 
        case 163: 
        case 185: 
          {  return createToken(DTDRegionTypes.NAME);  }
        case 274: break;
        case 5: 
        case 38: 
          {  yybegin(YYINITIAL); return createToken(DTDRegionTypes.NDATA_VALUE);  }
        case 275: break;
        case 13: 
        case 66: 
          {  return createToken(DTDRegionTypes.NAME);  }
        case 276: break;
        case 18: 
          {  return createToken(DTDRegionTypes.START_TAG);  }
        case 277: break;
        case 17: 
          {  return createToken(DTDRegionTypes.SEMICOLON);  }
        case 278: break;
        case 30: 
          {  return createToken(DTDRegionTypes.CONNECTOR);  }
        case 279: break;
        case 22: 
          {  return createToken(DTDRegionTypes.PERCENT);  }
        case 280: break;
        case 19: 
          {  return createToken(DTDRegionTypes.END_TAG);  }
        case 281: break;
        case 32: 
          {  return createToken(DTDRegionTypes.PERCENT);  }
        case 282: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            return null;
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }


}
