/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;

public abstract class AbstractQuickFixCppCast
extends AbstractAstRewriteQuickFix {
    protected abstract int getCastType();

    public void modifyAST(IIndex index, IMarker marker) {
        IASTTranslationUnit ast;
        try {
            ITranslationUnit tu = this.getTranslationUnitViaEditor(marker);
            ast = tu.getAST(index, 2);
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
            return;
        }
        IASTNode astNode = null;
        if (this.isCodanProblem(marker)) {
            astNode = this.getASTNodeFromMarker(marker, ast);
        }
        if (astNode == null || !(astNode instanceof IASTCastExpression)) {
            return;
        }
        ASTRewrite r = ASTRewrite.create((IASTTranslationUnit)ast);
        INodeFactory factory = ast.getASTNodeFactory();
        IASTCastExpression oldcast = (IASTCastExpression)astNode;
        IASTCastExpression newcast = factory.newCastExpression(this.getCastType(), oldcast.getTypeId().copy(IASTNode.CopyStyle.withLocations), oldcast.getOperand().copy(IASTNode.CopyStyle.withLocations));
        r.replace((IASTNode)oldcast, (IASTNode)newcast, null);
        Change c = r.rewriteAST();
        try {
            c.perform((IProgressMonitor)new NullProgressMonitor());
            marker.delete();
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }
}

