/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.IRefreshAllTarget;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class AbstractDebugVMAdapter
extends AbstractDMVMAdapter
implements SteppingController.ISteppingControlParticipant {
    private final SteppingController fController;

    public AbstractDebugVMAdapter(DsfSession session, SteppingController controller) {
        super(session);
        this.fController = controller;
        try {
            this.fController.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractDebugVMAdapter.this.fController.addSteppingControlParticipant(AbstractDebugVMAdapter.this);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    protected IVMProvider createViewModelProvider(IPresentationContext context) {
        return null;
    }

    @Override
    public void doneHandleEvent(Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            final IRunControl.ISuspendedDMEvent suspendedEvent = (IRunControl.ISuspendedDMEvent)event;
            this.fController.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractDebugVMAdapter.this.fController.doneStepping((IRunControl.IExecutionDMContext)suspendedEvent.getDMContext(), AbstractDebugVMAdapter.this);
                }
            });
        }
    }

    @Override
    public void dispose() {
        try {
            this.fController.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractDebugVMAdapter.this.fController.removeSteppingControlParticipant(AbstractDebugVMAdapter.this);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        super.dispose();
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlRefreshAllDMEvent event) {
        if (this.isDisposed()) {
            return;
        }
        IRefreshAllTarget refreshTarget = (IRefreshAllTarget)this.getSession().getModelAdapter(IRefreshAllTarget.class);
        if (refreshTarget == null) {
            return;
        }
        StructuredSelection debugContext = new StructuredSelection((Object)new IAdaptable(){

            public <T> T getAdapter(Class<T> adapter) {
                if (IVMAdapter.class.equals(adapter)) {
                    return adapter.cast(AbstractDebugVMAdapter.this);
                }
                return null;
            }
        });
        try {
            refreshTarget.refresh((ISelection)debugContext);
        }
        catch (CoreException e) {
            DsfUIPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", "Failed to refresh following receipt of a Refresh All Event.", (Throwable)e));
        }
    }
}

