/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.terminal;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ExecFactory;

public class PtyExecFactory
implements ExecFactory {
    public Optional<Process> exec(String[] cmdLine, Optional<File> workingDirectory, Optional<Map<String, String>> environment, boolean mergeOutput) throws CoreException {
        if (mergeOutput || !PTY.isSupported((PTY.Mode)PTY.Mode.TERMINAL)) {
            return Optional.empty();
        }
        try {
            PTY pty = new PTY(PTY.Mode.TERMINAL);
            pty.setTerminalSize(80, 24);
            String[] env = environment.isEmpty() ? null : (String[])environment.stream().flatMap(m -> m.entrySet().stream()).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
            File wd = workingDirectory.orElse(null);
            return Optional.of(ProcessFactory.getFactory().exec(cmdLine, env, wd, pty));
        }
        catch (IOException e2) {
            throw new CoreException(Status.error((String)"Execution failed", (Throwable)e2));
        }
    }
}

