/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.TclActiveStateDebuggerPreferencePage;
import org.eclipse.dltk.tcl.activestatedebugger.spawnpoint.SpawnpointCommandManager;
import org.eclipse.dltk.tcl.activestatedebugger.spawnpoint.SpawnpointCommands;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.preferences.IPreferenceDelegate;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclSpawnpointPreferenceBlock
implements IListAdapter,
ICheckStateListener {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private final IShellProvider shellProvider;
    private final IPreferenceDelegate<PreferenceKey> delegate;
    private final Set<String> contributed;
    private SpawnpointCommands commands;
    private CheckedListDialogField listDialogField;

    public TclSpawnpointPreferenceBlock(IShellProvider shellProvider, IPreferenceDelegate<PreferenceKey> delegate) {
        this.shellProvider = shellProvider;
        this.delegate = delegate;
        this.contributed = SpawnpointCommandManager.getContributedCommands();
    }

    public Control createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(1808));
        control.setLayout((Layout)new GridLayout(3, false));
        String[] buttons = new String[]{PreferenceMessages.Spawnpoint_Button_Add, PreferenceMessages.Spawnpoint_Button_Edit, PreferenceMessages.Spawnpoint_Button_Delete};
        this.listDialogField = new CheckedListDialogField((IListAdapter)this, buttons, (ILabelProvider)new TclSpawnpointLabelProvider());
        this.listDialogField.setUseLabel(false);
        this.listDialogField.setListGrabExcessHorizontalSpace(true);
        this.listDialogField.doFillIntoGrid(control, 3);
        this.listDialogField.addCheckStateListener((ICheckStateListener)this);
        this.selectionChanged((ListDialogField)this.listDialogField);
        return control;
    }

    public void customButtonPressed(ListDialogField field, int index) {
        switch (index) {
            case 0: {
                String newValue = this.doEdit(null);
                if (newValue == null) break;
                field.addElement((Object)newValue);
                this.listDialogField.setChecked((Object)newValue, true);
                this.commands.getCommands().add(newValue);
                this.commands.getSelectedCommands().add(newValue);
                this.saveCommands();
                break;
            }
            case 1: {
                String oldValue;
                String newValue;
                List selection = field.getSelectedElements();
                if (!this.canEdit(selection) || (newValue = this.doEdit(oldValue = (String)selection.get(0))) == null || newValue.equals(oldValue)) break;
                boolean wasChecked = this.listDialogField.isChecked((Object)oldValue);
                field.replaceElement((Object)oldValue, (Object)newValue);
                this.listDialogField.setChecked((Object)newValue, wasChecked);
                this.commands.getCommands().remove(oldValue);
                this.commands.getCommands().add(newValue);
                if (wasChecked) {
                    this.commands.getSelectedCommands().remove(oldValue);
                    this.commands.getSelectedCommands().add(newValue);
                }
                this.saveCommands();
                break;
            }
            case 2: {
                List selection = field.getSelectedElements();
                if (!this.canDelete(selection)) break;
                field.removeElements(selection);
                this.commands.getCommands().removeAll(selection);
                this.commands.getSelectedCommands().removeAll(selection);
                this.saveCommands();
            }
        }
    }

    private String doEdit(String value) {
        TclSpawnpointInputDialog dialog = new TclSpawnpointInputDialog(this.shellProvider.getShell(), value, this.commands.getCommands());
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public void doubleClicked(ListDialogField field) {
        this.customButtonPressed(field, 1);
    }

    public void selectionChanged(ListDialogField field) {
        List selection = field.getSelectedElements();
        field.enableButton(2, this.canDelete(selection));
        field.enableButton(1, this.canEdit(selection));
    }

    private boolean canDelete(List<String> selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (String selectedCommand : selection) {
            if (!this.contributed.contains(selectedCommand)) continue;
            return false;
        }
        return true;
    }

    private boolean canEdit(List<String> selection) {
        return selection.size() == 1 && !this.contributed.contains(selection.get(0));
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            this.commands.getSelectedCommands().add((String)event.getElement());
        } else {
            this.commands.getSelectedCommands().remove(event.getElement());
        }
        this.saveCommands();
    }

    private void saveCommands() {
        this.delegate.setString((Object)TclActiveStateDebuggerPreferencePage.PREF_SPAWNPOINTS, SpawnpointCommandManager.encode(this.commands));
    }

    public void initValues() {
        this.commands = SpawnpointCommandManager.decode(this.delegate.getString((Object)TclActiveStateDebuggerPreferencePage.PREF_SPAWNPOINTS));
        this.listDialogField.setElements(this.commands.getCommands());
        this.listDialogField.setCheckedElements(this.commands.getSelectedCommands());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TclSpawnpointInputDialog
    extends StatusDialog {
        private final StringDialogField fNameDialogField;
        private final List<String> existingEntries;

        public TclSpawnpointInputDialog(Shell parent, String value, List<String> existingEntries) {
            super(parent);
            this.existingEntries = existingEntries;
            if (value == null) {
                this.setTitle(PreferenceMessages.Spawnpoint_InputDialog_newTitle);
            } else {
                this.setTitle(PreferenceMessages.Spawnpoint_InputDialog_editTitle);
            }
            this.fNameDialogField = new StringDialogField();
            this.fNameDialogField.setLabelText(PreferenceMessages.Spawnpoint_InputDialog_commandLabel);
            this.fNameDialogField.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    TclSpawnpointInputDialog.this.doValidation();
                }
            });
            this.fNameDialogField.setText(value != null ? value : "");
        }

        public String getResult() {
            return this.fNameDialogField.getText().trim();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            inner.setLayout((Layout)layout);
            this.fNameDialogField.doFillIntoGrid(inner, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
            LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), (int)this.convertWidthInCharsToPixels(45));
            this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
            TclSpawnpointInputDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doValidation() {
            StatusInfo status = new StatusInfo();
            String newText = this.fNameDialogField.getText();
            if (newText.length() == 0) {
                status.setError(PreferenceMessages.Spawnpoint_InputDialog_errorEmptyCommandName);
            } else if (!SpawnpointCommandManager.isValidCommandName(newText)) {
                status.setError(PreferenceMessages.Spawnpoint_InputDialog_errorInvalidCommandName);
            } else if (this.existingEntries.contains(newText)) {
                status.setError(PreferenceMessages.Spawnpoint_InputDialog_errorDuplicateCommandName);
            }
            this.updateStatus((IStatus)status);
        }
    }

    private class TclSpawnpointLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private Font boldFont = null;

        private TclSpawnpointLabelProvider() {
        }

        public Font getFont(Object element) {
            if (TclSpawnpointPreferenceBlock.this.contributed.contains(element)) {
                if (this.boldFont == null) {
                    this.boldFont = JFaceResources.getDialogFontDescriptor().setStyle(1).createFont((Device)Display.getCurrent());
                }
                return this.boldFont;
            }
            return null;
        }

        public void dispose() {
            if (this.boldFont != null) {
                this.boldFont.dispose();
                this.boldFont = null;
            }
            super.dispose();
        }
    }
}

