/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.pde.api.tools.annotations.NoReference;

public class CaretInfo
implements Translatable {
    private int ascent;
    private int lineAscent;
    private int descent;
    private int lineDescent;
    private int baseline;
    private int x;

    @NoReference
    protected CaretInfo(int x, int y, int ascent, int descent, int lineAscent, int lineDescent) {
        this.x = x;
        this.baseline = y + ascent;
        this.ascent = ascent;
        this.descent = descent;
        this.lineAscent = lineAscent;
        this.lineDescent = lineDescent;
    }

    protected CaretInfo(CaretInfo info) {
        this.ascent = info.ascent;
        this.baseline = info.baseline;
        this.descent = info.descent;
        this.lineAscent = info.lineAscent;
        this.lineDescent = info.lineDescent;
        this.x = info.x;
    }

    public int getBaseline() {
        return this.baseline;
    }

    public int getHeight() {
        return this.ascent + this.descent;
    }

    public int getLineHeight() {
        return this.lineAscent + this.lineDescent;
    }

    public int getLineY() {
        return this.baseline - this.lineAscent;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.baseline - this.ascent;
    }

    @Override
    public void performScale(double factor) {
        this.x = (int)((double)this.x * factor);
        this.baseline = (int)((double)this.baseline * factor);
        this.descent = (int)((double)this.descent * factor);
        this.ascent = (int)((double)this.ascent * factor);
        this.lineAscent = (int)((double)this.lineAscent * factor);
        this.lineDescent = (int)((double)this.lineDescent * factor);
    }

    @Override
    public void performTranslate(int dx, int dy) {
        this.x += dx;
        this.baseline += dy;
    }
}

