/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.LineBox;
import org.eclipse.pde.api.tools.annotations.NoExtend;

@NoExtend
public abstract class FlowContainerLayout
extends FlowFigureLayout
implements FlowContext {
    LineBox currentLine;

    protected FlowContainerLayout(FlowFigure flowFigure) {
        super(flowFigure);
    }

    @Override
    public void addToCurrentLine(FlowBox child) {
        this.getCurrentLine().add(child);
        this.setContinueOnSameLine(false);
    }

    protected void cleanup() {
        this.currentLine = null;
    }

    protected abstract void createNewLine();

    protected abstract void flush();

    LineBox getCurrentLine() {
        if (this.currentLine == null) {
            this.createNewLine();
        }
        return this.currentLine;
    }

    @Override
    public int getRemainingLineWidth() {
        return this.getCurrentLine().getAvailableWidth();
    }

    @Override
    public boolean isCurrentLineOccupied() {
        return this.currentLine != null && this.currentLine.isOccupied();
    }

    @Override
    protected void layout() {
        this.preLayout();
        this.layoutChildren();
        this.flush();
        this.cleanup();
    }

    protected void layoutChildren() {
        this.getFlowFigure().getChildren().forEach(f -> {
            if (this.forceChildInvalidation((IFigure)f)) {
                f.invalidate();
            }
            f.validate();
        });
    }

    boolean forceChildInvalidation(IFigure f) {
        return true;
    }

    protected abstract void preLayout();
}

