/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.ejb.ActivationConfig;
import org.eclipse.jst.j2ee.ejb.ActivationConfigProperty;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CMRField;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.internal.util.MDBActivationConfigModelUtil;
import org.eclipse.jst.j2ee.model.internal.validation.AValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.DuplicatesTable;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IMessagePrefixEjb20Constants;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRuleList;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class EnterpriseBean20VRule
extends AValidationRule
implements IMessagePrefixEjb20Constants {
    private List _securityRoles = null;
    private static final Map MESSAGE_IDS;
    private static final Object[] DEPENDS_ON;
    private static String JMS_MESSAGING_TYPE;

    static {
        DEPENDS_ON = new Object[]{IValidationRuleList.EJB20_BMP_BEANCLASS, IValidationRuleList.EJB20_BMP_HOME, IValidationRuleList.EJB20_BMP_KEYCLASS, IValidationRuleList.EJB20_BMP_LOCAL, IValidationRuleList.EJB20_BMP_LOCALHOME, IValidationRuleList.EJB20_BMP_REMOTE, IValidationRuleList.EJB20_CMP_BEANCLASS, IValidationRuleList.EJB20_CMP_HOME, IValidationRuleList.EJB20_CMP_KEYCLASS, IValidationRuleList.EJB20_CMP_LOCAL, IValidationRuleList.EJB20_CMP_LOCALHOME, IValidationRuleList.EJB20_CMP_REMOTE, IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS, IValidationRuleList.EJB20_STATEFUL_SESSION_HOME, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME, IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE, IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS, IValidationRuleList.EJB20_STATELESS_SESSION_HOME, IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL, IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME, IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE};
        JMS_MESSAGING_TYPE = "javax.jms.MessageListener";
        MESSAGE_IDS = new HashMap();
        MESSAGE_IDS.put("CHKJ2433", new String[]{"CHKJ2433"});
        MESSAGE_IDS.put("CHKJ2800.named", new String[]{"CHKJ2800.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2800.unnamed", new String[]{"CHKJ2800.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2801", new String[]{"CHKJ2801.ejb20"});
        MESSAGE_IDS.put("CHKJ2802.named", new String[]{"CHKJ2802.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2802.unnamed", new String[]{"CHKJ2802.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2803.named", new String[]{"CHKJ2803.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2803.unnamed", new String[]{"CHKJ2803.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2804.named", new String[]{"CHKJ2804.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2804.unnamed", new String[]{"CHKJ2804.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2805.named", new String[]{"CHKJ2805.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2805.unnamed", new String[]{"CHKJ2805.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2806", new String[]{"CHKJ2806.ejb20"});
        MESSAGE_IDS.put("CHKJ2807", new String[]{"CHKJ2807.ejb20"});
        MESSAGE_IDS.put("CHKJ2808", new String[]{"CHKJ2808.ejb20"});
        MESSAGE_IDS.put("CHKJ2809", new String[]{"CHKJ2809.ejb20"});
        MESSAGE_IDS.put("CHKJ2810.named", new String[]{"CHKJ2810.named.ejb20"});
        MESSAGE_IDS.put("CHKJ2810.unnamed", new String[]{"CHKJ2810.unnamed.ejb20"});
        MESSAGE_IDS.put("CHKJ2813", new String[]{"CHKJ2813.ejb20"});
        MESSAGE_IDS.put("CHKJ2820", new String[]{"CHKJ2820.ejb20"});
        MESSAGE_IDS.put("CHKJ2822", new String[]{"CHKJ2822.ejb20"});
        MESSAGE_IDS.put("CHKJ2823", new String[]{"CHKJ2823.ejb20"});
        MESSAGE_IDS.put("CHKJ2824", new String[]{"CHKJ2824.ejb20"});
        MESSAGE_IDS.put("CHKJ2825", new String[]{"CHKJ2825.ejb20"});
        MESSAGE_IDS.put("CHKJ2826", new String[]{"CHKJ2826.ejb20"});
        MESSAGE_IDS.put("CHKJ2827", new String[]{"CHKJ2827.ejb20"});
        MESSAGE_IDS.put("CHKJ2828", new String[]{"CHKJ2828.ejb20"});
        MESSAGE_IDS.put("CHKJ2830", new String[]{"CHKJ2830.ejb20"});
        MESSAGE_IDS.put("CHKJ2831", new String[]{"CHKJ2831.ejb20"});
        MESSAGE_IDS.put("CHKJ2832", new String[]{"CHKJ2832.ejb20"});
        MESSAGE_IDS.put("CHKJ2833", new String[]{"CHKJ2833.ejb20"});
        MESSAGE_IDS.put("CHKJ2834", new String[]{"CHKJ2834.ejb20"});
        MESSAGE_IDS.put("CHKJ2835", new String[]{"CHKJ2835.ejb20"});
        MESSAGE_IDS.put("CHKJ2836", new String[]{"CHKJ2836.ejb20"});
        MESSAGE_IDS.put("CHKJ2837", new String[]{"CHKJ2837.ejb20"});
        MESSAGE_IDS.put("CHKJ2838", new String[]{"CHKJ2838.ejb20"});
        MESSAGE_IDS.put("CHKJ2839", new String[]{"CHKJ2839.ejb20"});
        MESSAGE_IDS.put("CHKJ2840", new String[]{"CHKJ2840.ejb20"});
        MESSAGE_IDS.put("CHKJ2841", new String[]{"CHKJ2841.ejb20"});
        MESSAGE_IDS.put("CHKJ2845", new String[]{"CHKJ2845.ejb20"});
        MESSAGE_IDS.put("CHKJ2846", new String[]{"CHKJ2846.ejb20"});
        MESSAGE_IDS.put("CHKJ2847", new String[]{"CHKJ2847.ejb20"});
        MESSAGE_IDS.put("CHKJ2852", new String[]{"CHKJ2852"});
        MESSAGE_IDS.put("CHKJ2854", new String[]{"CHKJ2854.ejb20"});
        MESSAGE_IDS.put("CHKJ2855", new String[]{"CHKJ2855.ejb20"});
        MESSAGE_IDS.put("CHKJ2856", new String[]{"CHKJ2856.ejb20"});
        MESSAGE_IDS.put("CHKJ2857", new String[]{"CHKJ2857.ejb20"});
        MESSAGE_IDS.put("CHKJ2858", new String[]{"CHKJ2858.ejb20"});
        MESSAGE_IDS.put("CHKJ2859", new String[]{"CHKJ2859.ejb20"});
        MESSAGE_IDS.put("CHKJ2860", new String[]{"CHKJ2860.ejb20"});
        MESSAGE_IDS.put("CHKJ2880", new String[]{"CHKJ2880.s.ejb20", "CHKJ2880.b.ejb20", "CHKJ2880.c.ejb20"});
        MESSAGE_IDS.put("CHKJ2881", new String[]{"CHKJ2881.s.ejb20", "CHKJ2881.b.ejb20", "CHKJ2881.c.ejb20"});
        MESSAGE_IDS.put("CHKJ2882", new String[]{"CHKJ2882.s.ejb20", "CHKJ2882.b.ejb20", "CHKJ2882.c.ejb20"});
        MESSAGE_IDS.put("CHKJ2883", new String[]{"CHKJ2883.s.ejb20", "CHKJ2883.b.ejb20", "CHKJ2883.c.ejb20"});
        MESSAGE_IDS.put("CHKJ2884", new String[]{"CHKJ2884.s.ejb20", "CHKJ2884.b.ejb20", "CHKJ2884.c.ejb20"});
        MESSAGE_IDS.put("CHKJ2885", new String[]{"CHKJ2885.s.ejb20", "CHKJ2885.b.ejb20", "CHKJ2885.c.ejb20"});
        MESSAGE_IDS.put("CHKJ2907", new String[]{"CHKJ2907"});
    }

    @Override
    public Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    @Override
    public Object getId() {
        return IValidationRuleList.EJB20_ENTERPRISEBEAN;
    }

    @Override
    public Map getMessageIds() {
        return MESSAGE_IDS;
    }

    @Override
    public Object getTarget(Object parent, Object clazz) {
        return parent;
    }

    @Override
    public void validate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        Logger logger = vc.getMsgLogger();
        if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
            LogEntry entry = vc.getLogEntry();
            entry.setSourceID("EnterpriseBean20VRule - validate");
            entry.setText(String.valueOf(this.getClass().getName()) + "::validate(" + targetParent + ", " + target);
            logger.write(Level.FINEST, (Object)entry);
        }
        EJBJar ejbJar = null;
        ejbJar = targetParent instanceof EnterpriseBean ? (EJBJar)vc.loadModel("EJB_MODEL") : (EJBJar)targetParent;
        EnterpriseBean bean = (EnterpriseBean)target;
        this.validate(vc, ejbJar, bean);
    }

    public void validate(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) throws ValidationCancelledException, ValidationException {
        block7: {
            Logger logger = vc.getMsgLogger();
            try {
                boolean reflected = this.validateBeanComponentsReflected(vc, ejbJar, bean);
                this.validateEJBNameElement(vc, ejbJar, bean);
                this.validateReentrantElement(vc, ejbJar, bean);
                this.validateSessionTypeElement(vc, ejbJar, bean);
                this.validateTransactionTypeElement(vc, ejbJar, bean);
                this.validatePersistenceTypeElement(vc, ejbJar, bean);
                this.validateEnvironmentEntries(vc, ejbJar, bean);
                if (!reflected) {
                    return;
                }
                this.validateLocalPairs(vc, ejbJar, bean);
                this.validateRemotePairs(vc, ejbJar, bean);
                this.validateLocalOrRemote(vc, ejbJar, bean);
                if (bean.isContainerManagedEntity()) {
                    ContainerManagedEntity cmp = (ContainerManagedEntity)bean;
                    if (cmp.getPrimKeyField() != null && !cmp.getPrimKeyField().eIsProxy()) {
                        this.validateCMPFieldElement(vc, ejbJar, cmp);
                    }
                    this.validateAbstractSchemaNameElement(vc, ejbJar, cmp);
                    this.validateJavaIdentifier(vc, ejbJar, cmp);
                }
                if (bean.isMessageDriven() && bean.getVersionID() == 21) {
                    this.validateActivationConfiguration(vc, (MessageDriven)bean);
                }
                this.validatePrimKeyClassElement(vc, ejbJar, bean);
                this.validateEJBRef(vc, ejbJar, bean);
            }
            catch (ValidationCancelledException e) {
                throw e;
            }
            catch (Throwable exc) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2852", 2, bean, new String[]{"ejb-jar.xml", bean.getName()}, (IValidationRule)this);
                vc.addMessage(message);
                if (logger == null || !logger.isLoggingLevel(Level.SEVERE)) break block7;
                logger.write(Level.SEVERE, exc);
            }
        }
    }

    public boolean validateBeanComponentsReflected(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        IMessage message;
        boolean isValid = true;
        try {
            ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)bean.getEjbClass());
        }
        catch (InvalidInputException invalidInputException) {
            message = null;
            message = bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_EjbClass()) ? MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2802.named", 1, bean, new String[]{bean.getEjbClassName()}, (IValidationRule)this) : MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2802.unnamed", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
            isValid = false;
        }
        if (bean instanceof MessageDriven) {
            return isValid;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_HomeInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)bean.getHomeInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            message = null;
            message = bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_HomeInterface()) ? MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2803.named", 1, bean, new String[]{bean.getHomeInterfaceName()}, (IValidationRule)this) : MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2803.unnamed", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
            isValid = false;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_RemoteInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)bean.getRemoteInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            message = null;
            message = bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_RemoteInterface()) ? MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2804.named", 1, bean, new String[]{bean.getRemoteInterfaceName()}, (IValidationRule)this) : MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2804.unnamed", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
            isValid = false;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalHomeInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)bean.getLocalHomeInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalHomeInterface())) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2805.named", 1, bean, new String[]{bean.getLocalHomeInterfaceName()}, (IValidationRule)this);
                vc.addMessage(message);
                isValid = false;
            }
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2805.unnamed", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
            isValid = false;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)bean.getLocalInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            message = null;
            message = bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalInterface()) ? MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2800.named", 1, bean, new String[]{bean.getLocalInterfaceName()}, (IValidationRule)this) : MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2800.unnamed", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
            isValid = false;
        }
        if (bean.isEntity()) {
            JavaClass primaryKey = ((Entity)bean).getPrimaryKey();
            try {
                ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)primaryKey);
            }
            catch (InvalidInputException invalidInputException) {
                IMessage message2 = null;
                message2 = bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEntity_PrimaryKey()) ? MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2810.named", 1, bean, new String[]{((Entity)bean).getPrimaryKeyName()}, (IValidationRule)this) : MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2810.unnamed", 1, bean, (IValidationRule)this);
                vc.addMessage(message2);
                isValid = false;
            }
        }
        return isValid;
    }

    public void validateCMPFieldElement(IEJBValidationContext vc, EJBJar ejbJar, ContainerManagedEntity cmp) {
        IMessage message;
        EList fields = cmp.getPersistentAttributes();
        if (fields == null || fields.size() == 0) {
            return;
        }
        boolean mapsToMultipleFields = !ValidationRuleUtility.isPrimitivePrimaryKey(cmp);
        Iterator iterator = fields.iterator();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
        while (iterator.hasNext()) {
            CMPAttribute attrib = (CMPAttribute)iterator.next();
            if (attrib == null) {
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.FINEST)) continue;
                LogEntry entry = vc.getLogEntry();
                entry.setSourceID("DDValidator.validateCMPFieldElement(EnterpriseBean)");
                entry.setText("CMPAttribute is null.");
                logger.write(Level.FINEST, (Object)entry);
                continue;
            }
            fieldNames.add(attrib.getName());
            JavaHelpers fieldType = attrib.getType();
            try {
                ValidationRuleUtility.isValidType(fieldType);
            }
            catch (InvalidInputException invalidInputException) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2830", 2, (EnterpriseBean)cmp, new String[]{attrib.getName()}, (IValidationRule)this);
                vc.addMessage(message);
                continue;
            }
            try {
                if (fieldType.isPrimitive() || ValidationRuleUtility.isSerializable(fieldType, cmp)) continue;
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2855", 4, (EnterpriseBean)cmp, new String[]{attrib.getName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
            catch (InvalidInputException e) {
                String[] stringArray;
                if (e.getJavaClass() == null) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = e.getJavaClass().getQualifiedName();
                }
                String[] msgParm = stringArray;
                IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2907", 2, (EnterpriseBean)cmp, msgParm, (IValidationRule)this);
                vc.addMessage(message2);
            }
        }
        if (mapsToMultipleFields && !ValidationRuleUtility.usesUnknownPrimaryKey(cmp)) {
            List primKeyFields = cmp.getPrimaryKey().getFieldsExtended();
            for (Field keyField : primKeyFields) {
                if (keyField.getName() != null && keyField.getName().equals("serialVersionUID") || fieldNames.contains(keyField.getName())) continue;
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2831", 2, (EnterpriseBean)cmp, new String[]{keyField.getName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateCMRFieldElement(IEJBValidationContext vc, EJBJar ejbJar, ContainerManagedEntity cmp) {
        if (cmp == null) {
            return;
        }
        switch (cmp.getVersionID()) {
            case 10: 
            case 11: {
                break;
            }
            default: {
                List fields = cmp.getCMRFields();
                for (CMRField field : fields) {
                    IMessage message;
                    String fieldName = field.getName();
                    if (fieldName == null || fieldName.equals("")) {
                        message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2857", 4, (EnterpriseBean)cmp, new String[]{field.getName()}, (IValidationRule)this);
                        vc.addMessage(message);
                        continue;
                    }
                    if (!ValidationRuleUtility.isValidJavaIdentifier(fieldName)) {
                        message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2857", 4, (EnterpriseBean)cmp, new String[]{field.getName()}, (IValidationRule)this);
                        vc.addMessage(message);
                    }
                    try {
                        JavaHelpers fieldType = field.getType();
                        if (ValidationRuleUtility.isAssignableFrom(fieldType, (JavaHelpers)cmp.getLocalInterface()) || ValidationRuleUtility.isAssignableFromCollection(fieldType, cmp) || ValidationRuleUtility.isAssignableFromSet(fieldType, cmp)) continue;
                        IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2856", 4, (EnterpriseBean)cmp, new String[]{field.getName()}, (IValidationRule)this);
                        vc.addMessage(message2);
                    }
                    catch (InvalidInputException e) {
                        String[] stringArray;
                        if (e.getJavaClass() == null) {
                            stringArray = new String[]{};
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = e.getJavaClass().getQualifiedName();
                        }
                        String[] msgParm = stringArray;
                        IMessage message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2907", 2, (EnterpriseBean)cmp, msgParm, (IValidationRule)this);
                        vc.addMessage(message3);
                    }
                }
            }
        }
    }

    public void validateEJBNameElement(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        IMessage message;
        if (bean == null) {
            return;
        }
        String name = bean.getName();
        if (name == null || name.equals("")) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2801", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (bean.isContainerManagedEntity() && bean.getVersionID() >= 20) {
            if (!ValidationRuleUtility.isValidJavaIdentifier(name)) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2813", 2, bean, (IValidationRule)this);
                vc.addMessage(message);
            }
            if (ValidationRuleUtility.isReservedWord(name)) {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2859", 4, bean, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateAbstractSchemaNameElement(IEJBValidationContext vc, EJBJar ejbJar, ContainerManagedEntity cmp) {
        if (cmp == null) {
            return;
        }
        switch (cmp.getVersionID()) {
            case 10: 
            case 11: {
                break;
            }
            default: {
                IMessage message;
                String name = cmp.getAbstractSchemaName();
                if (!ValidationRuleUtility.isValidJavaIdentifier(name)) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2858", 2, cmp, (IValidationRule)this);
                    vc.addMessage(message);
                }
                if (!ValidationRuleUtility.isReservedWord(name)) break;
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2860", 4, cmp, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateJavaIdentifier(IEJBValidationContext vc, EJBJar ejbJar, ContainerManagedEntity cmp) {
    }

    public void validateEJBRef(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        if (bean == null) {
            return;
        }
        EList ejbRefs = bean.getEjbRefs();
        if (ejbRefs == null || ejbRefs.size() == 0) {
            return;
        }
        Iterator iterator = ejbRefs.iterator();
        EjbRef ref = null;
        while (iterator.hasNext()) {
            String ejbName;
            ref = (EjbRef)iterator.next();
            if (ref == null) {
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.FINEST)) continue;
                LogEntry entry = vc.getLogEntry();
                entry.setSourceID("DDValidator.validateEJBRef(EnterpriseBean)");
                entry.setText("EjbRef is null in " + bean.getName());
                logger.write(Level.FINEST, (Object)entry);
                continue;
            }
            EnterpriseBean namedEjb = null;
            if (ref.eIsSet((EStructuralFeature)CommonPackage.eINSTANCE.getEjbRef_Link()) && (namedEjb = ejbJar.getEnterpiseBeanFromRef(ref)) != null) {
                String type;
                Integer ejbType = new Integer(ref.getType().getValue());
                boolean wrongType = false;
                String string = type = namedEjb instanceof Session ? "Session" : "Entity";
                if (ejbType == 0) {
                    if (!(namedEjb instanceof Session)) {
                        wrongType = true;
                    }
                } else if (ejbType == 1) {
                    if (!(namedEjb instanceof Entity)) {
                        wrongType = true;
                    }
                } else {
                    wrongType = true;
                }
                if (wrongType) {
                    String[] parms = new String[]{namedEjb.getName(), type};
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2835", 4, bean, parms, (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            this.validateHomeRef(vc, ejbJar, ref, namedEjb);
            this.validateRemoteRef(vc, ejbJar, ref, namedEjb);
            if (!ref.eIsSet((EStructuralFeature)CommonPackage.eINSTANCE.getEjbRef_Name()) || (ejbName = ref.getName()).startsWith("ejb/")) continue;
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2838", 4, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateEnvironmentEntries(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        if (bean == null) {
            return;
        }
        EList envEntries = bean.getEnvironmentProperties();
        if (envEntries == null || envEntries.size() == 0) {
            return;
        }
        EnvEntry envEntry = null;
        Iterator iterator = envEntries.iterator();
        DuplicatesTable envNames = new DuplicatesTable();
        while (iterator.hasNext()) {
            IMessage message;
            envEntry = (EnvEntry)iterator.next();
            if (envEntry == null) {
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.FINEST)) continue;
                LogEntry entry = vc.getLogEntry();
                entry.setSourceID("DDValidator.validateEnvironmentEntries(EnterpriseBean)");
                entry.setText("EjbEntry is null in " + bean.getName());
                logger.write(Level.FINEST, (Object)entry);
                continue;
            }
            if (envEntry.getName() != null) {
                envNames.add(envEntry.getName());
            } else {
                message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2839", 2, bean, (IValidationRule)this);
                vc.addMessage(message);
            }
            if (envEntry.isSetType()) {
                int type = envEntry.getType().getValue();
                if (type == 2 || type == 4 || type == 3 || type == 7 || type == 1 || type == 6 || type == 5 || type == 0 || type == 8) continue;
                IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2840", 2, bean, (IValidationRule)this);
                vc.addMessage(message2);
                continue;
            }
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2840", 2, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (envNames.containsDuplicates()) {
            for (String name : envNames.getDuplicates()) {
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2841", 2, bean, new String[]{name}, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    protected void validateHomeRef(IEJBValidationContext vc, EJBJar ejbJar, EjbRef ref, EnterpriseBean namedEjb) {
        EnterpriseBean bean;
        boolean validType;
        block6: {
            validType = true;
            bean = (EnterpriseBean)ref.eContainer();
            if (ref.eIsSet((EStructuralFeature)CommonPackage.eINSTANCE.getEjbRef_Home())) {
                try {
                    String homeName = ref.getHome();
                    JavaHelpers type = ValidationRuleUtility.getType(homeName, bean);
                    ValidationRuleUtility.isValidType(type);
                    if (namedEjb == null) break block6;
                    JavaClass intfType = namedEjb.getHomeInterface();
                    ValidationRuleUtility.isValidType((JavaHelpers)intfType);
                    if (!ValidationRuleUtility.isAssignableFrom(type, (JavaHelpers)intfType)) {
                        String[] parms = new String[]{namedEjb.getName(), intfType.getName()};
                        IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2836", 4, bean, parms, (IValidationRule)this);
                        vc.addMessage(message);
                    }
                }
                catch (InvalidInputException invalidInputException) {
                    validType = false;
                }
            } else {
                validType = false;
            }
        }
        if (!validType) {
            String[] parms = new String[]{ref.getHome()};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2832", 4, bean, parms, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateLocalPairs(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        if (bean instanceof MessageDriven) {
            return;
        }
        JavaClass local = bean.getLocalInterface();
        JavaClass localHome = bean.getLocalHomeInterface();
        if (local != null && localHome == null) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2880", 2, bean, (IValidationRule)this);
            vc.addMessage(message);
        } else if (local == null && localHome != null) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2882", 2, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateRemotePairs(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        if (bean instanceof MessageDriven) {
            return;
        }
        JavaClass remote = bean.getRemoteInterface();
        JavaClass home = bean.getHomeInterface();
        if (remote != null && home == null) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2881", 2, bean, (IValidationRule)this);
            vc.addMessage(message);
        } else if (remote == null && home != null) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2883", 2, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateLocalOrRemote(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        IMessage message;
        if (bean instanceof MessageDriven) {
            return;
        }
        JavaClass local = bean.getLocalInterface();
        JavaClass localHome = bean.getLocalHomeInterface();
        JavaClass remote = bean.getRemoteInterface();
        JavaClass remoteHome = bean.getHomeInterface();
        if (localHome == null && remoteHome == null) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2884", 2, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (local == null && remote == null) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2885", 2, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validatePersistenceTypeElement(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        Entity entityBean;
        if (bean.isEntity() && !(entityBean = (Entity)bean).isContainerManagedEntity() && !entityBean.isBeanManagedEntity()) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2809", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validatePrimKeyClassElement(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        ContainerManagedEntity cmp;
        CMPAttribute attr;
        if (bean.isEntity() && bean instanceof ContainerManagedEntity && (attr = (cmp = (ContainerManagedEntity)bean).getPrimKeyField()) != null && !attr.eIsProxy() && !this.isValidPrimKeyField(cmp, attr)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2828", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public boolean isValidPrimKeyField(ContainerManagedEntity cmp, CMPAttribute attr) {
        return cmp.getPrimaryKeyName().equals(attr.getType().getJavaName());
    }

    public void validateReentrantElement(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        Entity entity;
        if (bean.isEntity() && !(entity = (Entity)bean).eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEntity_Reentrant())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2806", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateRemoteRef(IEJBValidationContext vc, EJBJar ejbJar, EjbRef ref, EnterpriseBean namedEjb) {
        EnterpriseBean bean;
        boolean validType;
        block6: {
            validType = true;
            bean = (EnterpriseBean)ref.eContainer();
            if (ref.eIsSet((EStructuralFeature)CommonPackage.eINSTANCE.getEjbRef_Remote())) {
                try {
                    String remoteName = ref.getRemote();
                    JavaHelpers type = ValidationRuleUtility.getType(remoteName, bean);
                    ValidationRuleUtility.isValidType(type);
                    if (namedEjb == null) break block6;
                    JavaClass intfType = namedEjb.getRemoteInterface();
                    ValidationRuleUtility.isValidType((JavaHelpers)intfType);
                    if (!ValidationRuleUtility.isAssignableFrom(type, (JavaHelpers)intfType)) {
                        String[] parms = new String[]{namedEjb.getName(), intfType.getName()};
                        IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2837", 4, bean, parms, (IValidationRule)this);
                        vc.addMessage(message);
                    }
                }
                catch (InvalidInputException invalidInputException) {
                    validType = false;
                }
            } else {
                validType = false;
            }
        }
        if (!validType) {
            String[] parms = new String[]{ref.getRemote()};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2833", 4, bean, parms, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateSecurityRoleRefElement(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        if (bean == null) {
            return;
        }
        boolean areSRolesDefined = this._securityRoles != null && this._securityRoles.size() > 0;
        EList securityRoleRefs = bean.getSecurityRoleRefs();
        if (securityRoleRefs != null && securityRoleRefs.size() != 0) {
            class RoleRefWrapper {
                private SecurityRoleRef _ref = null;

                public RoleRefWrapper(SecurityRoleRef ref) {
                    this._ref = ref;
                }

                public boolean equals(Object o) {
                    if (o instanceof RoleRefWrapper) {
                        RoleRefWrapper other = (RoleRefWrapper)o;
                        return this._ref.getName().equals(other.getRoleRef().getName());
                    }
                    return false;
                }

                public int hashCode() {
                    return super.hashCode() + this._ref.getName().hashCode();
                }

                public SecurityRoleRef getRoleRef() {
                    return this._ref;
                }
            }
            DuplicatesTable roleRefNames = new DuplicatesTable();
            int i = 0;
            while (i < securityRoleRefs.size()) {
                IMessage message;
                boolean isLinkDefined;
                SecurityRoleRef ref = (SecurityRoleRef)securityRoleRefs.get(i);
                String roleName = ref.getName();
                if (roleName == null || roleName.equals("")) {
                    roleName = "";
                    String beanName = bean.getName() == null ? "" : bean.getName();
                    IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2822", 2, ref, new String[]{beanName}, (IValidationRule)this);
                    vc.addMessage(message2);
                } else {
                    roleRefNames.add(new RoleRefWrapper(ref));
                }
                String roleLink = ref.getLink();
                boolean bl = isLinkDefined = ref.eIsSet((EStructuralFeature)CommonPackage.eINSTANCE.getSecurityRoleRef_Link()) && roleLink != null && !roleLink.equals("");
                if (areSRolesDefined && !isLinkDefined) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2823", 2, ref, (IValidationRule)this);
                    vc.addMessage(message);
                } else if (!areSRolesDefined && isLinkDefined) {
                    message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2827", 2, ref, (IValidationRule)this);
                    vc.addMessage(message);
                } else if (areSRolesDefined && isLinkDefined) {
                    Iterator iterator = this._securityRoles.iterator();
                    boolean roleExists = false;
                    while (iterator.hasNext()) {
                        SecurityRole role = (SecurityRole)iterator.next();
                        if (!role.getRoleName().equals(roleLink)) continue;
                        roleExists = true;
                        break;
                    }
                    if (!roleExists) {
                        IMessage message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2824", 2, ref, new String[]{roleName}, (IValidationRule)this);
                        vc.addMessage(message3);
                    }
                }
                ++i;
            }
            if (roleRefNames.containsDuplicates()) {
                List duplicates = roleRefNames.getDuplicates();
                Iterator iterator = duplicates.iterator();
                while (iterator.hasNext()) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2820", 2, ((RoleRefWrapper)iterator.next()).getRoleRef(), (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            roleRefNames.clear();
        }
    }

    public void validateSessionTypeElement(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        Session session;
        boolean isValidSess;
        if (bean.isSession() && !(isValidSess = ValidationRuleUtility.isValidSessionTypeElement(session = (Session)bean))) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2807", 1, session, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateTransactionTypeElement(IEJBValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        Session sessionBean;
        if (bean.isSession() && !ValidationRuleUtility.isValidTransactionTypeElement(sessionBean = (Session)bean)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2808", 1, bean, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this._securityRoles = null;
    }

    @Override
    public void preValidate(IEJBValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        super.preValidate(vc, targetParent, target);
        EJBJar ejbJar = (EJBJar)vc.loadModel("EJB_MODEL");
        if (ejbJar == null) {
            return;
        }
        if (ejbJar.getAssemblyDescriptor() == null) {
            return;
        }
        this._securityRoles = ejbJar.getAssemblyDescriptor().getSecurityRoles();
    }

    private void validateActivationConfiguration(IEJBValidationContext vc, MessageDriven bean) {
        EList configProperties;
        ActivationConfig config = bean.getActivationConfig();
        if (config != null && (configProperties = config.getConfigProperties()) != null && !configProperties.isEmpty()) {
            HashSet<String> namePropertySet = new HashSet<String>();
            int i = 0;
            while (i < configProperties.size()) {
                ActivationConfigProperty property = (ActivationConfigProperty)configProperties.get(i);
                boolean doesNotExists = namePropertySet.add(property.getName());
                if (!doesNotExists) {
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2886.ejb21", 1, (EnterpriseBean)bean, bean.getEjbJar(), new String[]{property.getName(), bean.getName()}, (IValidationRule)this);
                    vc.addMessage(message);
                }
                if (this.isJMSMDB(bean)) {
                    this.validationAckModeActivationConfig(vc, bean, property);
                    this.validateDestinationTypeActivationConfig(vc, bean, property);
                    this.validateDurabilityActivationConfig(vc, bean, (List)configProperties, property);
                }
                ++i;
            }
        }
    }

    private boolean isJMSMDB(MessageDriven bean) {
        return bean.getMessagingType() == null || bean.getMessagingType().getQualifiedName().equals(JMS_MESSAGING_TYPE);
    }

    private void validationAckModeActivationConfig(IEJBValidationContext vc, MessageDriven bean, ActivationConfigProperty property) {
        if (property.getName().equals("acknowledgeMode") && !Arrays.asList(MDBActivationConfigModelUtil.ackModeValues).contains(property.getValue())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2887.ejb21", 1, (EnterpriseBean)bean, bean.getEjbJar(), new String[]{property.getName(), property.getValue(), bean.getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    private void validateDestinationTypeActivationConfig(IEJBValidationContext vc, MessageDriven bean, ActivationConfigProperty property) {
        JavaClass messageDestination;
        if (property.getName().equals("destinationType") && !Arrays.asList(MDBActivationConfigModelUtil.destinationTypeValues).contains(property.getValue())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2887.ejb21", 1, (EnterpriseBean)bean, bean.getEjbJar(), new String[]{property.getName(), property.getValue(), bean.getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
        if ((messageDestination = bean.getMessageDestination()) != null && messageDestination.getQualifiedName() != null && property.getName().equals("destinationType") && !messageDestination.getQualifiedName().equals(property.getValue())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2890.ejb21", 1, (EnterpriseBean)bean, bean.getEjbJar(), new String[]{messageDestination.getQualifiedName(), property.getValue(), bean.getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    private void validateDurabilityActivationConfig(IEJBValidationContext vc, MessageDriven bean, List configProperties, ActivationConfigProperty property) {
        if (property.getName().equals("subscriptionDurability") && !Arrays.asList(MDBActivationConfigModelUtil.durabilityValue).contains(property.getValue())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2887.ejb21", 1, (EnterpriseBean)bean, bean.getEjbJar(), new String[]{property.getName(), property.getValue(), bean.getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    class ASNameWrapper {
        private ContainerManagedEntity _bean = null;

        public ASNameWrapper(ContainerManagedEntity bean) {
            this._bean = bean;
        }

        public boolean equals(Object o) {
            if (o instanceof ContainerManagedEntity) {
                ContainerManagedEntity other = (ContainerManagedEntity)o;
                return this._bean.getAbstractSchemaName().equals(other.getAbstractSchemaName());
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + this._bean.getAbstractSchemaName().hashCode();
        }

        public EnterpriseBean getBean() {
            return this._bean;
        }
    }

    class EjbNameWrapper {
        private EnterpriseBean _bean = null;

        public EjbNameWrapper(EnterpriseBean bean) {
            this._bean = bean;
        }

        public boolean equals(Object o) {
            if (o instanceof EnterpriseBean) {
                EnterpriseBean other = (EnterpriseBean)o;
                return this._bean.getName().equals(other.getName());
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + this._bean.getName().hashCode();
        }

        public EnterpriseBean getBean() {
            return this._bean;
        }
    }
}

