/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import org.eclipse.jst.pagedesigner.commands.range.ApplyStyleCommand;
import org.eclipse.jst.pagedesigner.commands.range.Paragraph;
import org.eclipse.jst.pagedesigner.commands.range.ParagraphFinder;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParagraphUnapplyStyleCommand
extends ApplyStyleCommand {
    private String[] _groupTags;

    public ParagraphUnapplyStyleCommand(IHTMLGraphicalViewer viewer, String[] tags, String property, String value) {
        super(viewer, "", property, value);
        this._groupTags = tags;
    }

    public ParagraphUnapplyStyleCommand(IHTMLGraphicalViewer viewer, Element node, String property, String value) {
        super(viewer, node, property, value);
    }

    private DOMRange removeExistingStyles(IDOMPosition start, IDOMPosition end) {
        Node common = null;
        if (EditModelQuery.isSame(start, end)) {
            ParagraphFinder finder = new ParagraphFinder(start);
            Paragraph p = finder.getParagraph(start);
            start = p.getStart();
            end = p.getEnd();
            common = p.getLowestContainer();
        } else {
            common = EditModelQuery.getInstance().getCommonAncestor(start, end);
        }
        if (EditModelQuery.containItem(this._groupTags, common, true)) {
            start = DOMPositionHelper.toDOMRefPosition(start);
            end = DOMPositionHelper.toDOMRefPosition(end);
            Node parent = common.getParentNode();
            EditModelQuery.copyChildren(common, parent);
            common.getParentNode().removeChild(common);
            return new DOMRange(start, end);
        }
        return null;
    }

    @Override
    protected DOMRange doRangeExecute(DOMRange range) {
        return this.removeExistingStyles(range.getStartPosition(), range.getEndPosition());
    }
}

