/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.core.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis.server.AxisServer;
import org.apache.axis.tools.ant.axis.AdminClientTask;
import org.apache.axis.utils.ClassUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class GeronimoAxisDeployCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameter javaWSDLParam;
    private String projectName_;
    private static final String AXIS_SERVER_CONFIG_FILE = "axis.ServerConfigFile";
    IFolder outputRoot;

    public GeronimoAxisDeployCommand(String projectName) {
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        if (this.javaWSDLParam.getProjectURL() == null || this.javaWSDLParam.getProjectURL().equals("")) {
            return StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_PROJECT_URL_PARAM_NOT_SET);
        }
        if (this.javaWSDLParam.getDeploymentFiles() == null || this.javaWSDLParam.getDeploymentFiles().length == 0) {
            return StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_DEPLOY_FILE_PARAM_NOT_SET);
        }
        ProgressUtils.report((IProgressMonitor)monitor, (String)AxisConsumptionCoreMessages.MSG_AXIS_DEPLOY);
        IStatus status = this.executeAdminTask();
        if (status.getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
        }
        if ((status = this.executeAntTask()).getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }

    protected IStatus executeAntTask() {
        final class DeployTask
        extends AdminClientTask {
            public DeployTask() {
                super.setProject(new Project());
                super.getProject().init();
                super.setTaskType("axis");
                super.setTaskName("axis-admin");
                super.setOwningTarget(new Target());
            }
        }
        DeployTask adminClient = new DeployTask();
        String url = this.javaWSDLParam.getProjectURL() + "/services/AdminService";
        adminClient.setUrl(url);
        adminClient.setXmlFile(new File(this.javaWSDLParam.getDeploymentFiles()[0]));
        try {
            BuildException lastException = null;
            int index = 0;
            while (index < 20) {
                try {
                    lastException = null;
                    adminClient.execute();
                }
                catch (BuildException exc) {
                    lastException = exc;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (lastException == null) break;
                ++index;
            }
            if (lastException != null) {
                throw lastException;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().toString();
            }
            Status[] childStatus = new Status[]{StatusUtils.errorStatus((String)message)};
            return StatusUtils.multiStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_AXIS_DEPLOY, (IStatus[])childStatus);
        }
        return Status.OK_STATUS;
    }

    protected IStatus executeAdminTask() {
        IStatus status = Status.OK_STATUS;
        IVirtualComponent component = J2EEUtils.getVirtualComponent((String)this.projectName_);
        this.outputRoot = J2EEUtils.getOutputContainerRoot((IVirtualComponent)component);
        IPath path = new Path("WEB-INF").append("server-config.wsdd");
        IFile descriptorFile = this.outputRoot.getFile(path);
        if (!descriptorFile.exists() && (status = this.createServerConfigFile()).getSeverity() == 4) {
            return status;
        }
        String deployWSDD = this.javaWSDLParam.getDeploymentFiles()[0];
        File deployFile = new File(deployWSDD);
        if (deployFile == null || !deployFile.exists()) {
            return status;
        }
        try {
            Object jarsCP = new String();
            IPath classesPath = new Path("WEB-INF").append("classes");
            IFile classesDir = this.outputRoot.getFile(classesPath);
            jarsCP = "\"" + classesDir.getRawLocation().toOSString() + "\"";
            IPath libPath = new Path("WEB-INF").append("lib");
            IFile libEntry = this.outputRoot.getFile(libPath);
            IFolder libFolder = (IFolder)ResourceUtils.findResource((IPath)libEntry.getFullPath());
            IResource[] JARfiles = libFolder.members();
            int i = 0;
            while (i < JARfiles.length) {
                IResource res = JARfiles[i];
                if (res.getFileExtension().equals("jar")) {
                    jarsCP = (String)jarsCP + ";\"" + res.getRawLocation().toOSString() + "\"";
                }
                ++i;
            }
            String adminCommand = new String("java -Daxis.ServerConfigFile=" + descriptorFile.getRawLocation().toOSString() + " -cp " + (String)jarsCP + " org.apache.axis.utils.Admin server " + deployFile.getCanonicalPath());
            Runtime.getRuntime().exec(adminCommand);
        }
        catch (Exception e) {
            System.setProperty(AXIS_SERVER_CONFIG_FILE, "server-conifg.wsdd");
            e.printStackTrace();
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().toString();
            }
            Status[] childStatus = new Status[]{StatusUtils.errorStatus((String)message)};
            return StatusUtils.multiStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_AXIS_DEPLOY, (IStatus[])childStatus);
        }
        return status;
    }

    private IStatus createServerConfigFile() {
        try {
            IPath path = new Path("WEB-INF").append("server-config.wsdd");
            IFile descriptorFile = this.outputRoot.getFile(path);
            AxisServer preEngine = new AxisServer();
            InputStream is = ClassUtils.getResourceAsStream(preEngine.getClass(), (String)"server-config.wsdd");
            FileOutputStream fos = new FileOutputStream(descriptorFile.getRawLocation().toOSString());
            ResourceUtils.copyStream((InputStream)is, (OutputStream)fos);
            fos.close();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().toString();
            }
            Status[] childStatus = new Status[]{StatusUtils.errorStatus((String)message)};
            return StatusUtils.multiStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_AXIS_DEPLOY, (IStatus[])childStatus);
        }
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }
}

