/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler;

import org.eclipse.dltk.core.Flags;
import org.eclipse.php.core.compiler.IPHPModifiers;

public class PHPFlags
extends Flags
implements IPHPModifiers {
    public static boolean isDefault(int flags) {
        return !PHPFlags.isPrivate((int)flags) && !PHPFlags.isProtected((int)flags) && !PHPFlags.isPublic((int)flags) && !PHPFlags.isPrivateSet(flags) && !PHPFlags.isProtectedSet(flags) && !PHPFlags.isPublicSet(flags);
    }

    public static boolean isNamespace(int flags) {
        return (flags & 0x800) != 0;
    }

    public static boolean isTrait(int flags) {
        return (flags & 0x100000) != 0;
    }

    public static boolean isConstant(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isClass(int flags) {
        return !PHPFlags.isNamespace(flags) && !PHPFlags.isInterface((int)flags) && !PHPFlags.isTrait(flags);
    }

    public static String toString(int mod) {
        int len;
        StringBuilder sb = new StringBuilder();
        if ((mod & 0x40) != 0) {
            sb.append("public ");
        }
        if ((mod & 0x20) != 0) {
            sb.append("protected ");
        }
        if ((mod & 0x10) != 0) {
            sb.append("private ");
        }
        if ((mod & 1) != 0) {
            sb.append("abstract ");
        }
        if ((mod & 0x80) != 0) {
            sb.append("static ");
        }
        if ((mod & 4) != 0) {
            sb.append("final ");
        }
        if ((mod & 0x8000000) != 0) {
            sb.append("readonly ");
        }
        if ((mod & 0x40000000) != 0) {
            sb.append("protected(set) ");
        }
        if ((mod & 0x20000000) != 0) {
            sb.append("private(set) ");
        }
        if ((mod & Integer.MIN_VALUE) != 0) {
            sb.append("public(set) ");
        }
        if ((len = sb.length()) > 0) {
            return sb.toString().substring(0, len - 1);
        }
        return "";
    }

    public static boolean isDeprecated(int flags) {
        return (flags & 0x200000) != 0;
    }

    public static boolean isAnonymous(int flags) {
        return (flags & 0x400000) != 0;
    }

    public static boolean isVariadic(int flags) {
        return (flags & 0x1000000) != 0;
    }

    public static boolean isReference(int flags) {
        return (flags & 0x100) != 0;
    }

    public static boolean isInheritdoc(int flags) {
        return (flags & 0x2000000) != 0;
    }

    public static boolean isNullable(int flags) {
        return (flags & 0x4000000) != 0;
    }

    public static boolean isReadonly(int flags) {
        return (flags & 0x8000000) != 0;
    }

    public static boolean isEnum(int flags) {
        return (flags & 0x10000000) != 0;
    }

    public static boolean isEnumCase(int flags) {
        return (flags & 0x200) != 0;
    }

    public static boolean isPrivateSet(int flags) {
        return (flags & 0x20000000) != 0;
    }

    public static boolean isProtectedSet(int flags) {
        return (flags & 0x40000000) != 0;
    }

    public static boolean isPublicSet(int flags) {
        return (flags & Integer.MIN_VALUE) != 0;
    }
}

