/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.fields;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LayoutUtil {
    public static void doDefaultLayout(Composite parent, DialogField[] editors, boolean labelOnTop) {
        LayoutUtil.doDefaultLayout(parent, editors, labelOnTop, 0, 0);
    }

    public static void doDefaultLayout(Composite parent, DialogField[] editors, boolean labelOnTop, int marginWidth, int marginHeight) {
        int nCulumns = LayoutUtil.getNumberOfColumns(editors);
        Control[][] controls = new Control[editors.length][];
        int i = 0;
        while (i < editors.length) {
            controls[i] = editors[i].doFillIntoGrid(parent, nCulumns);
            ++i;
        }
        if (labelOnTop) {
            LayoutUtil.modifyLabelSpans(controls, --nCulumns);
        }
        GridLayout layout = null;
        layout = parent.getLayout() instanceof GridLayout ? (GridLayout)parent.getLayout() : new GridLayout();
        if (marginWidth != -1) {
            layout.marginWidth = marginWidth;
        }
        if (marginHeight != -1) {
            layout.marginHeight = marginHeight;
        }
        layout.numColumns = nCulumns;
        parent.setLayout((Layout)layout);
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static int getNumberOfColumns(DialogField[] editors) {
        int nCulumns = 0;
        int i = 0;
        while (i < editors.length) {
            nCulumns = Math.max(editors[i].getNumberOfControls(), nCulumns);
            ++i;
        }
        return nCulumns;
    }

    private static void modifyLabelSpans(Control[][] controls, int nCulumns) {
        int i = 0;
        while (i < controls.length) {
            LayoutUtil.setHorizontalSpan(controls[i][0], nCulumns);
            ++i;
        }
    }

    public static void setHeightHint(Control control, int heightHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).heightHint = heightHint;
        }
    }

    public static void setHorizontalGrabbing(Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).grabExcessHorizontalSpace = true;
        }
    }

    public static void setHorizontalIndent(Control control, int horizontalIndent) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalIndent = horizontalIndent;
        }
    }

    public static void setHorizontalSpan(Control control, int span) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalSpan = span;
        } else if (span != 1) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            control.setLayoutData((Object)gd);
        }
    }

    public static void setWidthHint(Control control, int widthHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).widthHint = widthHint;
        }
    }
}

