/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageSort implements Enumerator
{
    SYNCH_CALL_LITERAL(0, "synchCall", "synchCall"),
    ASYNCH_CALL_LITERAL(1, "asynchCall", "asynchCall"),
    ASYNCH_SIGNAL_LITERAL(2, "asynchSignal", "asynchSignal"),
    CREATE_MESSAGE_LITERAL(3, "createMessage", "createMessage"),
    DELETE_MESSAGE_LITERAL(4, "deleteMessage", "deleteMessage"),
    REPLY_LITERAL(5, "reply", "reply");

    public static final int SYNCH_CALL = 0;
    public static final int ASYNCH_CALL = 1;
    public static final int ASYNCH_SIGNAL = 2;
    public static final int CREATE_MESSAGE = 3;
    public static final int DELETE_MESSAGE = 4;
    public static final int REPLY = 5;
    private static final MessageSort[] VALUES_ARRAY;
    public static final List<MessageSort> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MessageSort[]{SYNCH_CALL_LITERAL, ASYNCH_CALL_LITERAL, ASYNCH_SIGNAL_LITERAL, CREATE_MESSAGE_LITERAL, DELETE_MESSAGE_LITERAL, REPLY_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MessageSort get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageSort result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageSort getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageSort result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageSort get(int value) {
        switch (value) {
            case 0: {
                return SYNCH_CALL_LITERAL;
            }
            case 1: {
                return ASYNCH_CALL_LITERAL;
            }
            case 2: {
                return ASYNCH_SIGNAL_LITERAL;
            }
            case 3: {
                return CREATE_MESSAGE_LITERAL;
            }
            case 4: {
                return DELETE_MESSAGE_LITERAL;
            }
            case 5: {
                return REPLY_LITERAL;
            }
        }
        return null;
    }

    private MessageSort(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

