/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import org.eclipse.e4.tools.emf.editor3x.Messages;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.jface.action.Action;

public class UndoAction
extends Action {
    private final IModelResource resource;
    private final IModelResource.ModelListener listener;

    public UndoAction(IModelResource resource) {
        this.resource = resource;
        this.listener = new IModelResource.ModelListener(){

            public void commandStackChanged() {
                UndoAction.this.update();
            }

            public void dirtyChanged() {
            }
        };
        resource.addModelListener(this.listener);
        this.update();
    }

    public void run() {
        if (this.resource.getEditingDomain().getCommandStack().canUndo()) {
            this.resource.getEditingDomain().getCommandStack().undo();
        }
    }

    private void update() {
        if (this.resource.getEditingDomain().getCommandStack().canUndo()) {
            this.setText(String.valueOf(Messages.UndoAction_Undo) + " " + this.resource.getEditingDomain().getCommandStack().getUndoCommand().getLabel());
            this.setEnabled(true);
        } else {
            this.setText(Messages.UndoAction_Undo);
            this.setEnabled(false);
        }
    }

    public void dispose() {
        this.resource.removeModelListener(this.listener);
    }
}

