/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.history.command.AbstractRebaseHistoryCommandHandler;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveHandler;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveView;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class RebaseInteractiveCurrentHandler
extends AbstractRebaseHistoryCommandHandler {
    @Override
    public boolean isEnabled() {
        Repository repository = this.getRepository(this.getPage());
        if (repository == null) {
            return false;
        }
        return repository.getRepositoryState().equals((Object)RepositoryState.SAFE);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PlotCommit commit = (PlotCommit)this.getSelection(event).getFirstElement();
        Repository repository = this.getRepository(event);
        if (repository == null) {
            return null;
        }
        String currentBranch = this.getCurrentBranch(repository);
        final Ref ref = this.getRef(commit, repository, currentBranch);
        String jobname = NLS.bind((String)UIText.RebaseCurrentRefCommand_RebasingCurrentJobName, (Object)currentBranch, (Object)ref.getName());
        AbstractRebaseCommandHandler rebaseCurrentRef = new AbstractRebaseCommandHandler(jobname, UIText.RebaseCurrentRefCommand_RebaseCanceledMessage){

            @Override
            protected RebaseOperation createRebaseOperation(Repository repository2) throws ExecutionException {
                return new RebaseOperation(repository2, ref, (RebaseCommand.InteractiveHandler)RebaseInteractiveHandler.INSTANCE);
            }
        };
        rebaseCurrentRef.execute(repository);
        try {
            RebaseInteractiveView rebaseInteractiveView = (RebaseInteractiveView)HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage().showView("org.eclipse.egit.ui.InteractiveRebaseView");
            rebaseInteractiveView.setInput(repository);
        }
        catch (PartInitException e) {
            Activator.showError(e.getMessage(), e);
        }
        return null;
    }

    @Override
    protected RebaseOperation createRebaseOperation(Repository repository, Ref ref) {
        return new RebaseOperation(repository, ref, (RebaseCommand.InteractiveHandler)RebaseInteractiveHandler.INSTANCE);
    }
}

