/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.widgets.file;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jwt.transformations.api.io.ContentChangeListener;
import org.eclipse.jwt.transformations.internal.TransformationsMessages;
import org.eclipse.jwt.transformations.widgets.file.AbstractFilePickerController;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceFilePickerController
extends AbstractFilePickerController<IFile> {
    private final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public WorkspaceFilePickerController(ContentChangeListener pageListener, AbstractFilePickerController.FileFilter filter, IFile defaultFile) {
        super(pageListener, filter, defaultFile);
    }

    @Override
    protected String fileToPath(IFile file) {
        if (file == null) {
            return "";
        }
        return file.getFullPath().toOSString();
    }

    @Override
    protected IFile pathToFile(String path) {
        try {
            return this.workspaceRoot.getFile((IPath)new Path(path));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    protected boolean isValid(IFile file, AbstractFilePickerController.FileFilter filter) {
        return !(file == null || !filter.getValidExtensions().isEmpty() && !filter.getValidExtensions().contains(file.getFileExtension()) || filter.mustExist() && !file.exists());
    }

    @Override
    protected IFile doSelectFileInDialog(final AbstractFilePickerController.FileFilter filter) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.view.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setMessage(TransformationsMessages.selectFile);
        dialog.setInput((Object)this.workspaceRoot);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    return WorkspaceFilePickerController.this.isValid(file, filter);
                }
                return element instanceof IContainer;
            }
        });
        dialog.open();
        Object result = dialog.getFirstResult();
        if (result != null && result instanceof IFile) {
            return (IFile)result;
        }
        return null;
    }

    @Override
    public void openFile() throws CoreException {
        URI uri = ((IFile)this.getSelection()).getLocationURI();
        IFileStore fileStore = EFS.getStore((URI)uri);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }
}

