/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.model;

import java.io.File;
import java.util.Collections;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.meta.model.core.CoreFactory;
import org.eclipse.jwt.meta.model.core.CorePackage;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.wizards.PackageFilter;
import org.eclipse.jwt.we.misc.wizards.model.CreatePackageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SelectNameWizardPage
extends WizardPage {
    protected Text nameField;
    protected Text iconField;
    protected Tree packageTree;
    protected Menu contextMenu;
    protected MenuItem addSubpackage;
    protected Composite composite;
    protected SelectNameWizardPage thispage;
    protected Package defaultPackage = null;
    protected ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SelectNameWizardPage.this.setPageComplete(SelectNameWizardPage.this.validatePage());
        }
    };
    protected SelectionListener selListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            SelectNameWizardPage.this.setPageComplete(SelectNameWizardPage.this.validatePage());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public SelectNameWizardPage(String pageId, IWorkbench workbench) {
        this(pageId, null, workbench);
    }

    public SelectNameWizardPage(String pageId, Package defaultPackage, IWorkbench workbench) {
        super(pageId);
        this.thispage = this;
        this.defaultPackage = defaultPackage;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        final Shell shell = this.composite.getShell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.composite.setLayoutData((Object)data);
        this.packageTree = new Tree(this.composite, 4);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 4;
        data2.horizontalSpan = 3;
        this.packageTree.setLayoutData((Object)data2);
        TreeViewer packageViewer = new TreeViewer(this.packageTree);
        packageViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        packageViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory()));
        packageViewer.setInput((Object)GeneralHelper.getActiveInstance().getMainModelResource());
        PackageFilter filter = new PackageFilter();
        packageViewer.addFilter((ViewerFilter)filter);
        packageViewer.expandAll();
        this.packageTree.addSelectionListener(this.selListener);
        this.contextMenu = new Menu((Decorations)this.composite.getShell(), 8);
        this.packageTree.setMenu(this.contextMenu);
        this.addSubpackage = new MenuItem(this.contextMenu, 8);
        this.addSubpackage.setText(PluginProperties.wizards_NewPackage);
        final Button addPackageButton = new Button(this.composite, 0x800000);
        addPackageButton.setEnabled(false);
        addPackageButton.setText(PluginProperties.wizards_NewPackage);
        GridData data3 = new GridData();
        data3.horizontalSpan = 3;
        data3.verticalSpan = 1;
        data3.horizontalAlignment = 3;
        addPackageButton.setLayoutData((Object)data3);
        addPackageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreatePackageDialog packagedialog = new CreatePackageDialog(shell);
                packagedialog.open(SelectNameWizardPage.this.thispage);
            }
        });
        this.packageTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SelectNameWizardPage.this.packageTree.getSelection()[0].getData() instanceof XMIResourceImpl) {
                    SelectNameWizardPage.this.addSubpackage.setEnabled(false);
                    addPackageButton.setEnabled(false);
                } else {
                    SelectNameWizardPage.this.addSubpackage.setEnabled(true);
                    addPackageButton.setEnabled(true);
                }
            }
        });
        this.addSubpackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreatePackageDialog packagedialog = new CreatePackageDialog(shell);
                packagedialog.open(SelectNameWizardPage.this.thispage);
            }
        });
        Label nameLabel = new Label(this.composite, 131072);
        nameLabel.setText(String.valueOf(org.eclipse.jwt.meta.PluginProperties.model_NamedElement_name_name) + ":");
        this.nameField = new Text(this.composite, 2048);
        GridData data4 = new GridData();
        data4.horizontalAlignment = 4;
        data4.grabExcessHorizontalSpace = true;
        data4.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)data4);
        this.nameField.addModifyListener(this.validator);
        Label iconLabel = new Label(this.composite, 131072);
        iconLabel.setText(String.valueOf(org.eclipse.jwt.meta.PluginProperties.model_NamedElement_icon_name) + ":");
        this.iconField = new Text(this.composite, 2048);
        GridData data5 = new GridData();
        data5.horizontalAlignment = 4;
        data5.grabExcessHorizontalSpace = true;
        this.iconField.setLayoutData((Object)data5);
        this.iconField.addModifyListener(this.validator);
        Button browseButton = new Button(this.composite, 8);
        browseButton.setText(PluginProperties.browse_button);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                File iconPath;
                String filePath = "";
                String result = "";
                String[] filterExtensions = new String[]{"*.png;*.gif;*.ico"};
                String[] extensionNames = new String[]{PluginProperties.wizards_Files_iconfiles};
                FileDialog fileDialog = new FileDialog(SelectNameWizardPage.this.getShell(), 4096);
                fileDialog.setFilterExtensions(filterExtensions);
                fileDialog.setFilterNames(extensionNames);
                if (SelectNameWizardPage.this.iconField.getText().equals("") && (iconPath = new File("icons")).exists()) {
                    fileDialog.setFilterPath(iconPath.getAbsolutePath());
                }
                if ((filePath = fileDialog.open()) != null) {
                    iconPath = new Path(filePath);
                    String temp = "";
                    int i = iconPath.segmentCount() - 1;
                    while (i > 0) {
                        if (SelectNameWizardPage.this.pathinPlugin(temp = temp != "" ? String.valueOf(iconPath.segment(i)) + "/" + temp : String.valueOf(iconPath.segment(i)) + temp)) {
                            result = temp;
                        }
                        --i;
                    }
                    if (result == "") {
                        result = filePath;
                    }
                    SelectNameWizardPage.this.iconField.setText(result);
                }
            }
        });
        if (this.defaultPackage != null) {
            this.packageTree.setSelection((TreeItem)packageViewer.testFindItem((Object)this.defaultPackage));
            addPackageButton.setEnabled(true);
        }
        this.nameField.setFocus();
        this.setPageComplete(this.validatePage());
        this.setControl((Control)this.composite);
    }

    public String getName() {
        return this.nameField.getText();
    }

    public Package getPackage() {
        if (this.packageTree.getSelection() != null && this.packageTree.getSelection()[0].getData() instanceof Package) {
            return (Package)this.packageTree.getSelection()[0].getData();
        }
        return null;
    }

    public String getIconPath() {
        return this.iconField.getText();
    }

    protected boolean validatePage() {
        if (this.nameField.getText().length() == 0) {
            this.setErrorMessage(null);
            return false;
        }
        if (this.packageTree.getSelection().length != 0) {
            if (this.packageTree.getSelection()[0].getData() instanceof XMIResourceImpl) {
                this.setErrorMessage(null);
                return false;
            }
            return true;
        }
        return false;
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }

    public AdapterFactory getAdapterFactory() {
        return (AdapterFactory)GeneralHelper.getActiveInstance().getAdapter(AdapterFactory.class);
    }

    private boolean pathinPlugin(String path) {
        ImageDescriptor result = AbstractUIPlugin.imageDescriptorFromPlugin((String)Plugin.getId(), (String)path);
        return result != null;
    }

    public void createSubpackage(String packagename) {
        Package superpackage = this.packageTree.getSelection() != null ? (this.packageTree.getSelection()[0].getData() instanceof Package ? (Package)this.packageTree.getSelection()[0].getData() : null) : null;
        CoreFactory factory = CoreFactory.eINSTANCE;
        Package newpackage = factory.createPackage();
        newpackage.setName(packagename);
        newpackage.setSuperpackage(superpackage);
        CommandParameter childDescriptor = new CommandParameter(null, (Object)CorePackage.Literals.PACKAGE__ELEMENTS, (Object)newpackage);
        Command cmd = CreateChildCommand.create((EditingDomain)this.getEditingDomain(), (Object)superpackage, (Object)childDescriptor, Collections.singleton(superpackage));
        this.getEditingDomain().getCommandStack().execute(cmd);
    }
}

