/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.cs2as;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.context.Base2ASConversion;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.cs2as.CS2ASConversion;
import org.eclipse.ocl.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.BaseCSPackage;
import org.eclipse.ocl.xtext.basecs.ConstraintCS;
import org.eclipse.ocl.xtext.basecs.ContextLessElementCS;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.basecs.NamedElementCS;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.SpecificationCS;
import org.eclipse.ocl.xtext.essentialoclcs.BooleanLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.CollectionLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.CollectionLiteralPartCS;
import org.eclipse.ocl.xtext.essentialoclcs.CollectionTypeCS;
import org.eclipse.ocl.xtext.essentialoclcs.ContextCS;
import org.eclipse.ocl.xtext.essentialoclcs.ExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.ExpSpecificationCS;
import org.eclipse.ocl.xtext.essentialoclcs.IfExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.IfThenExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.InvalidLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.LetVariableCS;
import org.eclipse.ocl.xtext.essentialoclcs.LiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.MapLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.MapLiteralPartCS;
import org.eclipse.ocl.xtext.essentialoclcs.MapTypeCS;
import org.eclipse.ocl.xtext.essentialoclcs.NameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.xtext.essentialoclcs.NavigationRole;
import org.eclipse.ocl.xtext.essentialoclcs.NestedExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NullLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NumberLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.PrefixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.PrimitiveLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.RoundBracketedClauseCS;
import org.eclipse.ocl.xtext.essentialoclcs.SelfExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.ShadowPartCS;
import org.eclipse.ocl.xtext.essentialoclcs.StringLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.TupleLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.TupleLiteralPartCS;
import org.eclipse.ocl.xtext.essentialoclcs.TypeLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.TypeNameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.UnlimitedNaturalLiteralExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.VariableCS;
import org.eclipse.ocl.xtext.essentialoclcs.util.AbstractEssentialOCLCSContainmentVisitor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class EssentialOCLCSContainmentVisitor
extends AbstractEssentialOCLCSContainmentVisitor {
    private static final Logger logger = Logger.getLogger(EssentialOCLCSContainmentVisitor.class);

    public EssentialOCLCSContainmentVisitor(@NonNull CS2ASConversion context) {
        super(context);
    }

    private void setParameterRole(@NonNull NavigatingArgCS csArgument, @NonNull NavigationRole aRole) {
        csArgument.setRole(aRole);
        ExpCS csName = csArgument.getOwnedNameExpression();
        if (csName instanceof NameExpCS) {
            PathNameCS csPathName = ((NameExpCS)csName).getOwnedPathName();
            Variable parameter = aRole == NavigationRole.ITERATOR ? (Variable)((CS2ASConversion)this.context).refreshModelElement(Variable.class, PivotPackage.Literals.ITERATOR_VARIABLE, (ModelElementCS)csName) : (aRole == NavigationRole.ACCUMULATOR ? (Variable)((CS2ASConversion)this.context).refreshModelElement(Variable.class, PivotPackage.Literals.RESULT_VARIABLE, (ModelElementCS)csName) : (Variable)((CS2ASConversion)this.context).refreshModelElement(Variable.class, PivotPackage.Literals.VARIABLE, (ModelElementCS)csName));
            ICompositeNode node = NodeModelUtils.getNode((EObject)csName);
            if (node != null) {
                String varName = ElementUtil.getTextName((ElementCS)csName);
                assert (varName != null);
                ((CS2ASConversion)this.context).refreshName((NamedElement)parameter, varName);
                EList path = csPathName.getOwnedPathElements();
                PathElementCS csPathElement = (PathElementCS)path.get(path.size() - 1);
                csPathElement.setReferredElement((Element)parameter);
                csPathElement.setElementType(null);
            }
        }
    }

    @Override
    public Continuation<?> visitBooleanLiteralExpCS(@NonNull BooleanLiteralExpCS csElement) {
        @NonNull BooleanLiteralExp pivotElement = (BooleanLiteralExp)((CS2ASConversion)this.context).refreshModelElement(BooleanLiteralExp.class, PivotPackage.Literals.BOOLEAN_LITERAL_EXP, (ModelElementCS)csElement);
        pivotElement.setBooleanSymbol(Boolean.valueOf(csElement.getSymbol()).booleanValue());
        return null;
    }

    @Override
    public Continuation<?> visitCollectionLiteralExpCS(@NonNull CollectionLiteralExpCS csElement) {
        @NonNull CollectionLiteralExp pivotElement = (CollectionLiteralExp)((CS2ASConversion)this.context).refreshModelElement(CollectionLiteralExp.class, PivotPackage.Literals.COLLECTION_LITERAL_EXP, (ModelElementCS)csElement);
        ((CS2ASConversion)this.context).refreshPivotList(CollectionLiteralPart.class, pivotElement.getOwnedParts(), csElement.getOwnedParts());
        return null;
    }

    @Override
    public Continuation<?> visitCollectionLiteralPartCS(@NonNull CollectionLiteralPartCS csElement) {
        if (csElement.getOwnedLastExpression() == null) {
            ((CS2ASConversion)this.context).refreshModelElement(CollectionItem.class, PivotPackage.Literals.COLLECTION_ITEM, (ModelElementCS)csElement);
        } else {
            ((CS2ASConversion)this.context).refreshModelElement(CollectionRange.class, PivotPackage.Literals.COLLECTION_RANGE, (ModelElementCS)csElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitCollectionTypeCS(@NonNull CollectionTypeCS csElement) {
        return null;
    }

    public Continuation<?> visitConstraintCS(@NonNull ConstraintCS csElement) {
        @NonNull Constraint asConstraint = (Constraint)this.refreshNamedElement(Constraint.class, PivotPackage.Literals.CONSTRAINT, (NamedElementCS)csElement);
        ExpSpecificationCS csStatusSpecification = (ExpSpecificationCS)csElement.getOwnedSpecification();
        ExpSpecificationCS csMessageSpecification = (ExpSpecificationCS)csElement.getOwnedMessageSpecification();
        if (csMessageSpecification == null) {
            ExpressionInOCL asSpecification = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)csStatusSpecification);
            if (asSpecification == null) {
                asSpecification = PivotFactory.eINSTANCE.createExpressionInOCL();
            }
            asConstraint.setOwnedSpecification((LanguageExpression)asSpecification);
        } else {
            TupleLiteralExp asTupleLiteralExp;
            PropertyCallExp asTuplePartExp;
            ExpressionInOCL asExpressionInOCL;
            HashMap<@NonNull String, @NonNull PrimitiveType> tupleParts = new HashMap<String, PrimitiveType>();
            tupleParts.put("message", this.standardLibrary.getStringType());
            tupleParts.put("status", this.standardLibrary.getBooleanType());
            TupleType tupleType = this.metamodelManager.getCompleteModel().getTupleManager().getTupleType("Tuple", tupleParts);
            Property statusProperty = (Property)NameUtil.getNameable((Iterable)tupleType.getOwnedProperties(), (String)"status");
            LanguageExpression asSpecification = asConstraint.getOwnedSpecification();
            if (asSpecification instanceof ExpressionInOCL) {
                asExpressionInOCL = (ExpressionInOCL)asSpecification;
            } else {
                asExpressionInOCL = PivotFactory.eINSTANCE.createExpressionInOCL();
                asConstraint.setOwnedSpecification((LanguageExpression)asExpressionInOCL);
            }
            OCLExpression asExpression = asExpressionInOCL.getOwnedBody();
            if (asExpression instanceof PropertyCallExp) {
                asTuplePartExp = (PropertyCallExp)asExpression;
            } else {
                asTuplePartExp = PivotFactory.eINSTANCE.createPropertyCallExp();
                asExpressionInOCL.setOwnedBody((OCLExpression)asTuplePartExp);
            }
            asTuplePartExp.setReferredProperty(statusProperty);
            if (statusProperty != null) {
                asTuplePartExp.setType(statusProperty.getType());
            }
            asTuplePartExp.setIsRequired(true);
            asExpression = asTuplePartExp.getOwnedSource();
            if (asExpression instanceof TupleLiteralExp) {
                asTupleLiteralExp = (TupleLiteralExp)asExpression;
            } else {
                asTupleLiteralExp = PivotFactory.eINSTANCE.createTupleLiteralExp();
                asTuplePartExp.setOwnedSource((OCLExpression)asTupleLiteralExp);
            }
            asTupleLiteralExp.setType((Type)tupleType);
            asTupleLiteralExp.setIsRequired(true);
            ArrayList<TupleLiteralPart> parts = new ArrayList<TupleLiteralPart>();
            TupleLiteralPart asStatusPart = (TupleLiteralPart)PivotUtil.getPivot(TupleLiteralPart.class, (Pivotable)csStatusSpecification);
            TupleLiteralPart asMessagePart = (TupleLiteralPart)PivotUtil.getPivot(TupleLiteralPart.class, (Pivotable)csMessageSpecification);
            if (asMessagePart != null && asStatusPart != null) {
                parts.add(asMessagePart);
                parts.add(asStatusPart);
            }
            ((CS2ASConversion)this.context).refreshList(asTupleLiteralExp.getOwnedParts(), parts);
        }
        return null;
    }

    @Override
    public Continuation<?> visitContextCS(@NonNull ContextCS csElement) {
        @NonNull ExpressionInOCL pivotElement = (ExpressionInOCL)((CS2ASConversion)this.context).refreshModelElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (ModelElementCS)csElement);
        PivotUtil.setBody((ExpressionInOCL)pivotElement, null, null);
        ParserContext parserContext = ElementUtil.basicGetParserContext((EObject)csElement);
        if (parserContext != null) {
            parserContext.initialize((Base2ASConversion)this.context, pivotElement);
        }
        return null;
    }

    public @Nullable Continuation<?> visitContextLessElementCS(@NonNull ContextLessElementCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitExpCS(@NonNull ExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitExpSpecificationCS(@NonNull ExpSpecificationCS csElement) {
        EObject eContainer = csElement.eContainer();
        if (eContainer instanceof ConstraintCS) {
            ConstraintCS csConstraint = (ConstraintCS)eContainer;
            SpecificationCS csStatusSpecification = csConstraint.getOwnedSpecification();
            SpecificationCS csMessageSpecification = csConstraint.getOwnedMessageSpecification();
            if (csStatusSpecification != null && csMessageSpecification != null) {
                @NonNull TupleLiteralPart csTupleLiteralPart = (TupleLiteralPart)((CS2ASConversion)this.context).refreshModelElement(TupleLiteralPart.class, PivotPackage.Literals.TUPLE_LITERAL_PART, (ModelElementCS)csElement);
                EStructuralFeature eContainingFeature = csElement.eContainingFeature();
                if (eContainingFeature == BaseCSPackage.Literals.CONSTRAINT_CS__OWNED_SPECIFICATION) {
                    csTupleLiteralPart.setName("status");
                    csTupleLiteralPart.setType((Type)this.standardLibrary.getBooleanType());
                } else if (eContainingFeature == BaseCSPackage.Literals.CONSTRAINT_CS__OWNED_MESSAGE_SPECIFICATION) {
                    csTupleLiteralPart.setName("message");
                    csTupleLiteralPart.setType((Type)this.standardLibrary.getStringType());
                } else {
                    logger.error((Object)("unknown ExpSpecificationCS.eContainingFeature" + eContainingFeature));
                }
                return null;
            }
        }
        ((CS2ASConversion)this.context).refreshModelElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitIfExpCS(@NonNull IfExpCS csElement) {
        IfExp asIfExp = (IfExp)((CS2ASConversion)this.context).refreshModelElement(IfExp.class, PivotPackage.Literals.IF_EXP, (ModelElementCS)csElement);
        asIfExp.setIsElseIf(false);
        return null;
    }

    @Override
    public Continuation<?> visitIfThenExpCS(@NonNull IfThenExpCS csElement) {
        IfExp asIfExp = (IfExp)((CS2ASConversion)this.context).refreshModelElement(IfExp.class, PivotPackage.Literals.IF_EXP, (ModelElementCS)csElement);
        asIfExp.setIsElseIf(true);
        return null;
    }

    @Override
    public Continuation<?> visitInfixExpCS(@NonNull InfixExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitInvalidLiteralExpCS(@NonNull InvalidLiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitLetVariableCS(@NonNull LetVariableCS csElement) {
        this.refreshNamedElement(LetVariable.class, PivotPackage.Literals.LET_VARIABLE, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitLiteralExpCS(@NonNull LiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitMapLiteralExpCS(@NonNull MapLiteralExpCS csElement) {
        @NonNull MapLiteralExp pivotElement = (MapLiteralExp)((CS2ASConversion)this.context).refreshModelElement(MapLiteralExp.class, PivotPackage.Literals.MAP_LITERAL_EXP, (ModelElementCS)csElement);
        ((CS2ASConversion)this.context).refreshPivotList(MapLiteralPart.class, pivotElement.getOwnedParts(), csElement.getOwnedParts());
        return null;
    }

    @Override
    public Continuation<?> visitMapLiteralPartCS(@NonNull MapLiteralPartCS csElement) {
        ((CS2ASConversion)this.context).refreshModelElement(MapLiteralPart.class, PivotPackage.Literals.MAP_LITERAL_PART, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitMapTypeCS(@NonNull MapTypeCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNameExpCS(@NonNull NameExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNavigatingArgCS(@NonNull NavigatingArgCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNestedExpCS(@NonNull NestedExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNullLiteralExpCS(@NonNull NullLiteralExpCS csElement) {
        ((CS2ASConversion)this.context).refreshModelElement(NullLiteralExp.class, PivotPackage.Literals.NULL_LITERAL_EXP, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitNumberLiteralExpCS(@NonNull NumberLiteralExpCS csElement) {
        Number number = csElement.getSymbol();
        if (number instanceof BigDecimal || number instanceof Double || number instanceof Float) {
            @NonNull RealLiteralExp pivotElement = (RealLiteralExp)((CS2ASConversion)this.context).refreshModelElement(RealLiteralExp.class, PivotPackage.Literals.REAL_LITERAL_EXP, (ModelElementCS)csElement);
            pivotElement.setRealSymbol(number);
        } else {
            if (number instanceof BigInteger) {
                boolean isNegative;
                BigInteger bigInteger = (BigInteger)number;
                boolean bl = isNegative = bigInteger.signum() < 0;
                if (isNegative) {
                    if (bigInteger.compareTo(ValueUtil.INTEGER_MIN_VALUE) >= 0) {
                        number = bigInteger.intValue();
                    } else if (bigInteger.compareTo(ValueUtil.LONG_MIN_VALUE) >= 0) {
                        number = bigInteger.longValue();
                    }
                } else if (bigInteger.compareTo(ValueUtil.INTEGER_MAX_VALUE) <= 0) {
                    number = bigInteger.intValue();
                } else if (bigInteger.compareTo(ValueUtil.LONG_MAX_VALUE) <= 0) {
                    number = bigInteger.longValue();
                }
            } else {
                boolean isNegative;
                long longValue = number.longValue();
                boolean bl = isNegative = longValue < 0L;
                number = isNegative ? (Number)(longValue >= Integer.MIN_VALUE ? (Number)((int)longValue) : (Number)longValue) : (Number)(longValue <= Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue);
            }
            @NonNull IntegerLiteralExp pivotElement = (IntegerLiteralExp)((CS2ASConversion)this.context).refreshModelElement(IntegerLiteralExp.class, PivotPackage.Literals.INTEGER_LITERAL_EXP, (ModelElementCS)csElement);
            pivotElement.setIntegerSymbol(number);
        }
        return null;
    }

    @Override
    public Continuation<?> visitPrefixExpCS(@NonNull PrefixExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrimitiveLiteralExpCS(@NonNull PrimitiveLiteralExpCS csElement) {
        return null;
    }

    @Override
    public @Nullable Continuation<?> visitRoundBracketedClauseCS(@NonNull RoundBracketedClauseCS csElement) {
        EList<NavigatingArgCS> csArguments = csElement.getOwnedArguments();
        if (csArguments.size() > 0) {
            NavigationRole role = NavigationRole.EXPRESSION;
            int i = csArguments.size() - 1;
            while (i >= 0) {
                @NonNull NavigatingArgCS csArgument = (NavigatingArgCS)csArguments.get(i);
                switch (role) {
                    case EXPRESSION: {
                        csArgument.setRole(NavigationRole.EXPRESSION);
                        if (!"|".equals(csArgument.getPrefix())) break;
                        role = NavigationRole.ACCUMULATOR;
                        break;
                    }
                    case ACCUMULATOR: {
                        if (csArgument.getOwnedInitExpression() != null) {
                            this.setParameterRole(csArgument, NavigationRole.ACCUMULATOR);
                            if (!";".equals(csArgument.getPrefix())) break;
                            role = NavigationRole.ITERATOR;
                            break;
                        }
                        role = NavigationRole.ITERATOR;
                        this.setParameterRole(csArgument, NavigationRole.ITERATOR);
                        break;
                    }
                    case ITERATOR: {
                        this.setParameterRole(csArgument, NavigationRole.ITERATOR);
                    }
                }
                --i;
            }
        }
        return null;
    }

    @Override
    public Continuation<?> visitSelfExpCS(@NonNull SelfExpCS csElement) {
        ((CS2ASConversion)this.context).refreshModelElement(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitShadowPartCS(@NonNull ShadowPartCS csElement) {
        ((CS2ASConversion)this.context).refreshModelElement(ShadowPart.class, PivotPackage.Literals.SHADOW_PART, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitStringLiteralExpCS(@NonNull StringLiteralExpCS csElement) {
        @NonNull StringLiteralExp pivotElement = (StringLiteralExp)((CS2ASConversion)this.context).refreshModelElement(StringLiteralExp.class, PivotPackage.Literals.STRING_LITERAL_EXP, (ModelElementCS)csElement);
        EList<String> segments = csElement.getSegments();
        if (segments.size() == 0) {
            pivotElement.setStringSymbol("");
        } else if (segments.size() == 1) {
            pivotElement.setStringSymbol((String)segments.get(0));
        } else {
            StringBuilder s = new StringBuilder();
            for (String segment : segments) {
                s.append(segment);
            }
            pivotElement.setStringSymbol(s.toString());
        }
        return null;
    }

    @Override
    public Continuation<?> visitTupleLiteralExpCS(@NonNull TupleLiteralExpCS csElement) {
        @NonNull TupleLiteralExp pivotElement = (TupleLiteralExp)((CS2ASConversion)this.context).refreshModelElement(TupleLiteralExp.class, PivotPackage.Literals.TUPLE_LITERAL_EXP, (ModelElementCS)csElement);
        ((CS2ASConversion)this.context).refreshPivotList(TupleLiteralPart.class, pivotElement.getOwnedParts(), csElement.getOwnedParts());
        return null;
    }

    @Override
    public Continuation<?> visitTupleLiteralPartCS(@NonNull TupleLiteralPartCS csElement) {
        this.refreshNamedElement(TupleLiteralPart.class, PivotPackage.Literals.TUPLE_LITERAL_PART, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitTypeLiteralExpCS(@NonNull TypeLiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTypeNameExpCS(@NonNull TypeNameExpCS csElement) {
        PathNameCS pathName = csElement.getOwnedPathName();
        assert (pathName != null);
        CS2AS.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.TYPE, (ElementCS)csElement, null);
        return null;
    }

    @Override
    public Continuation<?> visitUnlimitedNaturalLiteralExpCS(@NonNull UnlimitedNaturalLiteralExpCS csElement) {
        @NonNull UnlimitedNaturalLiteralExp pivotElement = (UnlimitedNaturalLiteralExp)((CS2ASConversion)this.context).refreshModelElement(UnlimitedNaturalLiteralExp.class, PivotPackage.Literals.UNLIMITED_NATURAL_LITERAL_EXP, (ModelElementCS)csElement);
        pivotElement.setName("*");
        pivotElement.setUnlimitedNaturalSymbol((Number)Unlimited.INSTANCE);
        return null;
    }

    @Override
    public Continuation<?> visitVariableCS(@NonNull VariableCS csElement) {
        this.refreshNamedElement(Variable.class, PivotPackage.Literals.VARIABLE, csElement);
        return null;
    }
}

