/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IGrillingEditpolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.SimpleSnapHelper;

public class InteractionGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy
implements IGrillingEditpolicy {
    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        ConnectionAnchor anchor = ((NodeEditPart)request.getTargetEditPart()).getSourceConnectionAnchor((Request)request);
        if (DiagramEditPartsUtil.isSnapToGridActive((EditPart)this.getHost()) && anchor instanceof AnchorHelper.InnerPointAnchor) {
            PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)anchor).getTerminal());
            PrecisionRectangle ptOnScreen = new PrecisionRectangle((double)pt.x, (double)pt.y, 0.0, 0.0);
            SimpleSnapHelper.snapAPoint(ptOnScreen, this.getHost().getRoot());
            this.computeSourcePosition(request, new PrecisionPoint(ptOnScreen.x, ptOnScreen.y));
            Map parameters = request.getExtendedData();
            parameters.put("EDGE_SOURCE_POINT", request.getLocation().getCopy());
        }
        return super.getConnectionCreateCommand(request);
    }

    protected void computeSourcePosition(CreateConnectionRequest request, PrecisionPoint wanted) {
        ConnectionAnchor anchor = ((NodeEditPart)request.getTargetEditPart()).getSourceConnectionAnchor((Request)request);
        if (DiagramEditPartsUtil.isSnapToGridActive((EditPart)this.getHost()) && anchor instanceof AnchorHelper.InnerPointAnchor) {
            PrecisionPoint resultedPoint = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)anchor).getTerminal());
            while (resultedPoint.getDistance((Point)wanted) > 5.0) {
                Point original = request.getLocation().getCopy();
                PrecisionPoint diff = new PrecisionPoint(original.x - resultedPoint.x, original.y - resultedPoint.y);
                PrecisionRectangle ptOnScreen = new PrecisionRectangle((double)resultedPoint.x, (double)resultedPoint.y, 0.0, 0.0);
                SimpleSnapHelper.snapAPoint(ptOnScreen, this.getHost().getRoot());
                PrecisionPoint Result = new PrecisionPoint(ptOnScreen.x + diff.x, ptOnScreen.y + diff.y);
                request.setLocation((Point)Result);
                anchor = ((NodeEditPart)request.getTargetEditPart()).getSourceConnectionAnchor((Request)request);
                resultedPoint = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)anchor).getTerminal());
            }
        }
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        Command cmd = super.getConnectionAndRelationshipCompleteCommand(request);
        return cmd;
    }

    protected Connection createDummyConnection(Request req) {
        if (req instanceof CreateUnspecifiedTypeConnectionRequest) {
            ConnectionAnchor anchor;
            CreateUnspecifiedTypeConnectionRequest request2 = (CreateUnspecifiedTypeConnectionRequest)req;
            if (DiagramEditPartsUtil.isSnapToGridActive((EditPart)this.getHost()) && (anchor = ((NodeEditPart)request2.getTargetEditPart()).getSourceConnectionAnchor((Request)request2)) instanceof AnchorHelper.InnerPointAnchor) {
                PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)anchor).getTerminal());
                PrecisionRectangle ptOnScreen = new PrecisionRectangle((double)pt.x, (double)pt.y, 0.0, 0.0);
                SimpleSnapHelper.snapAPoint(ptOnScreen, this.getHost().getRoot());
                this.computeSourcePosition((CreateConnectionRequest)request2, new PrecisionPoint(ptOnScreen.x, ptOnScreen.y));
            }
        }
        return super.createDummyConnection(req);
    }

    public void showSourceFeedback(Request request) {
        super.showSourceFeedback(request);
    }

    protected FeedbackHelper getFeedbackHelper(CreateConnectionRequest request) {
        return super.getFeedbackHelper(request);
    }
}

