/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.dnd.ui;

import org.eclipse.papyrus.uml.diagram.usecase.dnd.ui.UsecaseOwnerComposite;
import org.eclipse.papyrus.uml.diagram.usecase.dnd.ui.UsecaseSubjectComposite;
import org.eclipse.papyrus.uml.diagram.usecase.messages.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.UseCase;

public class UsecaseSelectionDialog
extends SelectionDialog {
    private final UseCase sourceUsecase;
    private final Classifier subject;
    private UsecaseSubjectComposite usecaseSubjectComposite;
    private UsecaseOwnerComposite usecaseOwnerComposite;

    public UsecaseSelectionDialog(Shell parentShell, UseCase sourceUsecase, Classifier subject) {
        super(parentShell);
        this.sourceUsecase = sourceUsecase;
        this.subject = subject;
    }

    public void create() {
        this.setTitle(Messages.UsecaseSelectionDialog_TITLE);
        super.create();
        Composite parent = this.getDialogArea();
        if (!this.sourceUsecase.getSubjects().contains((Object)this.subject)) {
            this.usecaseSubjectComposite = new UsecaseSubjectComposite(parent, this.computeInitialStatusForSubject());
        }
        if (!this.sourceUsecase.getOwner().equals(this.subject)) {
            this.usecaseOwnerComposite = new UsecaseOwnerComposite(parent, this.computeInitialStatusForOwner());
        }
        parent.layout();
        this.getShell().pack();
    }

    private boolean computeInitialStatusForOwner() {
        return this.sourceUsecase.getOwner().equals(this.subject);
    }

    private boolean computeInitialStatusForSubject() {
        return this.sourceUsecase.getSubjects().contains((Object)this.subject);
    }

    public Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isKeepOwner() {
        if (this.usecaseOwnerComposite != null) {
            return this.usecaseOwnerComposite.isKeepOwner();
        }
        return true;
    }

    public boolean isKeepSubject() {
        if (this.usecaseSubjectComposite != null) {
            return this.usecaseSubjectComposite.isKeepSubject();
        }
        return true;
    }
}

