/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectionDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public abstract class AbstractUMLMultiValueCellEditor
extends AbstractDialogCellEditor {
    private Collection<Object> returnedValue;
    protected ITableAxisElementProvider manager;
    private Object axisElement;

    protected AbstractUMLMultiValueCellEditor(Object axisElement, ITableAxisElementProvider elementProvider) {
        this.manager = elementProvider;
        this.axisElement = axisElement;
    }

    public Object getAxisElement() {
        return this.axisElement;
    }

    public int open() {
        NatTable nattable;
        int result = ((Dialog)this.dialog).open();
        if (this.manager instanceof IAdaptable && (nattable = (NatTable)((IAdaptable)this.manager).getAdapter(NatTable.class)) != null && !nattable.isDisposed()) {
            nattable.forceFocus();
        }
        return result;
    }

    public Object createDialogInstance() {
        int columnIndex = this.layerCell.getColumnIndex();
        int rowIndex = this.layerCell.getRowIndex();
        Object row = this.manager.getRowElement(rowIndex);
        Object column = this.manager.getColumnElement(columnIndex);
        row = AxisUtils.getRepresentedElement((Object)row);
        column = AxisUtils.getRepresentedElement((Object)column);
        Element editedElement = null;
        Object feature = null;
        if (row instanceof EObject && column == this.axisElement) {
            editedElement = (Element)row;
            feature = column;
        } else {
            editedElement = (Element)column;
            feature = row;
        }
        EStructuralFeature realFeature = null;
        Element realEditedObject = null;
        Stereotype stereotype = null;
        List<Stereotype> stereotypesWithEditedFeatureAppliedOnElement = null;
        if (feature instanceof EStructuralFeature) {
            realFeature = (EStructuralFeature)feature;
            realEditedObject = editedElement;
        } else {
            String id = AxisUtils.getPropertyId((Object)this.axisElement);
            stereotypesWithEditedFeatureAppliedOnElement = UMLTableUtils.getAppliedStereotypesWithThisProperty(editedElement, id);
            stereotype = stereotypesWithEditedFeatureAppliedOnElement.get(0);
            realEditedObject = editedElement.getStereotypeApplication(stereotypesWithEditedFeatureAppliedOnElement.get(0));
            Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)editedElement, id);
            realFeature = realEditedObject.eClass().getEStructuralFeature(prop.getName());
        }
        if (stereotypesWithEditedFeatureAppliedOnElement == null || stereotypesWithEditedFeatureAppliedOnElement.size() <= 1) {
            this.dialog = this.createDialog((EObject)realEditedObject, realFeature, stereotype, editedElement.eResource().getResourceSet());
        }
        return this.dialog;
    }

    protected Object createDialog(EObject realEditedObject, EStructuralFeature realFeature, Stereotype stereotype, ResourceSet resourceSet) {
        ReferenceValueFactory factory;
        Collection coll;
        UMLContentProvider p = new UMLContentProvider(realEditedObject, realFeature, stereotype, resourceSet);
        String title = realFeature.getName();
        boolean unique = realFeature.isUnique();
        boolean ordered = realFeature.isOrdered();
        int upperBound = realFeature.getUpperBound();
        Object value = realEditedObject.eGet(realFeature);
        IElementSelector selector = this.getElementSelector(unique, (ILabelProvider)new UMLLabelProvider(), (IStaticContentProvider)p);
        MultipleValueSelectionDialog dialog = new MultipleValueSelectionDialog(Display.getCurrent().getActiveShell(), selector, title, unique, ordered, upperBound){

            protected void okPressed() {
                Object[] result;
                super.okPressed();
                ArrayList<Object> newValue = new ArrayList<Object>();
                Object[] objectArray = result = this.getResult();
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    newValue.add(object);
                    ++n2;
                }
                AbstractUMLMultiValueCellEditor.this.returnedValue = newValue;
                AbstractUMLMultiValueCellEditor.this.editHandler.commit(newValue, SelectionLayer.MoveDirectionEnum.NONE);
            }
        };
        dialog.setContextElement((Object)realEditedObject);
        dialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        if (value != null && value instanceof Collection && !(coll = (Collection)value).isEmpty()) {
            dialog.setInitialSelections(coll.toArray());
        }
        if ((factory = this.getFactory()) != null) {
            dialog.setFactory(factory);
        }
        return dialog;
    }

    protected abstract ReferenceValueFactory getFactory();

    protected abstract IElementSelector getElementSelector(boolean var1, ILabelProvider var2, IStaticContentProvider var3);

    public Object getDialogInstance() {
        return this.dialog;
    }

    public Object getEditorValue() {
        return this.returnedValue;
    }

    public void setEditorValue(Object value) {
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }
}

