/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAccessStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineNameNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IAccessId;
import org.eclipse.photran.internal.core.parser.IInternalSubprogram;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class SafeDeleteInternalSubprogramRefactoring
extends FortranEditorRefactoring {
    private ASTSubroutineSubprogramNode subProgramNode;

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        List<Definition> definitionsList;
        this.ensureProjectHasRefactoringEnabled(status);
        IASTNode selectedNode = SafeDeleteInternalSubprogramRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selectedNode == null) {
            this.fail(Messages.SafeDeleteInternalSubprogramRefactoring_NoSubroutineSelected);
        }
        if (selectedNode instanceof ASTSubroutineSubprogramNode) {
            this.subProgramNode = (ASTSubroutineSubprogramNode)selectedNode;
        } else if (selectedNode instanceof ASTSubroutineStmtNode || selectedNode instanceof ASTSubroutineNameNode) {
            ASTSubroutineSubprogramNode NearestAncestor;
            this.subProgramNode = NearestAncestor = selectedNode.findNearestAncestor(ASTSubroutineSubprogramNode.class);
        }
        if (this.subProgramNode == null) {
            this.fail(Messages.SafeDeleteInternalSubprogramRefactoring_NoSubroutineSelected);
        }
        if ((definitionsList = this.subProgramNode.getSubroutineStmt().getSubroutineName().getSubroutineName().resolveBinding()).size() == 0) {
            throw new VPGRefactoring.PreconditionFailure(Messages.SafeDeleteInternalSubprogramRefactoring_NoDefinition);
        }
        if (definitionsList.size() > 1) {
            throw new VPGRefactoring.PreconditionFailure(Messages.SafeDeleteInternalSubprogramRefactoring_MultipleDefinitions);
        }
        if (!definitionsList.get(0).isInternalSubprogramDefinition()) {
            throw new VPGRefactoring.PreconditionFailure(Messages.SafeDeleteInternalSubprogramRefactoring_NotAnInternalSubprogram);
        }
        for (PhotranTokenRef tokenRef : definitionsList.get(0).findAllReferences(true)) {
            if (tokenRef.findToken().findNearestAncestor(ASTAccessStmtNode.class) != null || tokenRef.findToken().findNearestAncestor(ASTSubroutineSubprogramNode.class) == this.subProgramNode) continue;
            this.fail(Messages.SafeDeleteInternalSubprogramRefactoring_SubroutineMustHaveOnlyInternalReferences);
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.removeReferenceInAccessStatement();
        this.removeSubProgram();
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAllASTs();
    }

    private void removeSubProgram() {
        ScopingNode enclosingScope = this.subProgramNode.findNearestAncestor(ScopingNode.class);
        if (enclosingScope != null) {
            IASTListNode<IInternalSubprogram> internalSubprogramList = enclosingScope.getInternalSubprograms();
            if (internalSubprogramList.size() == 1) {
                enclosingScope.getContainsStmt().removeFromTree();
            }
            this.subProgramNode.removeFromTree();
        }
    }

    private void removeReferenceInAccessStatement() {
        List<Definition> definitionsList = this.subProgramNode.getSubroutineStmt().getSubroutineName().getSubroutineName().resolveBinding();
        for (PhotranTokenRef tokenRef : definitionsList.get(0).findAllReferences(true)) {
            if (tokenRef.findToken().findNearestAncestor(ASTAccessStmtNode.class) == null) continue;
            IASTListNode<IAccessId> accessIdList = tokenRef.findToken().findNearestAncestor(ASTAccessStmtNode.class).getAccessIdList();
            if (accessIdList.size() == 1) {
                tokenRef.findToken().findNearestAncestor(ASTAccessStmtNode.class).removeFromTree();
                continue;
            }
            Token token = tokenRef.findToken();
            IAccessId accessID = token.findNearestAncestor(IAccessId.class);
            accessIdList.remove(accessID);
        }
    }

    @Override
    public String getName() {
        return Messages.SafeDeleteInternalSubprogramRefactoring_Name;
    }
}

