/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPProblemIdentifier;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.php.internal.ui.text.correction.proposals.CUCorrectionProposal;
import org.eclipse.php.ui.text.correction.IInvocationContext;
import org.eclipse.php.ui.text.correction.IProblemLocation;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.TextEdit;

public class RemoveUnusedUseStatementProposal
extends CUCorrectionProposal {
    private IProblemLocation fLocation;
    private IInvocationContext fContext;

    public RemoveUnusedUseStatementProposal(IInvocationContext context, IProblemLocation location, int relevance) {
        super(RemoveUnusedUseStatementProposal.getMessage(location), context.getCompilationUnit(), relevance, DLTKPluginImages.get((String)"org.eclipse.dltk.ui.correction_delete_import.png"));
        this.fLocation = location;
        this.fContext = context;
    }

    private static String getMessage(IProblemLocation location) {
        String message = "";
        if (!(location.getProblemIdentifier() instanceof PHPProblemIdentifier)) {
            return message;
        }
        PHPProblemIdentifier id = (PHPProblemIdentifier)location.getProblemIdentifier();
        switch (id) {
            case ImportNotFound: 
            case UnusedImport: {
                message = CorrectionMessages.RemoveUnusedUseStatementProposal_removeunusedusestatement_description;
                break;
            }
            case DuplicateImport: {
                message = CorrectionMessages.RemoveUnusedUseStatementProposal_removeduplicateusestatement_description;
                break;
            }
            case UnnecessaryImport: {
                message = CorrectionMessages.RemoveUnusedUseStatementProposal_removeunnecessaryusestatement_description;
                break;
            }
        }
        return message;
    }

    @Override
    protected void addEdits(IDocument doc, TextEdit root) throws CoreException {
        super.addEdits(doc, root);
        try {
            ASTNode coveredNode;
            Program astRoot = this.fContext.getASTRoot();
            ASTNode current = coveredNode = this.fLocation.getCoveredNode(astRoot);
            while (!(coveredNode instanceof UseStatement)) {
                coveredNode = coveredNode.getParent();
            }
            UseStatement use = (UseStatement)coveredNode;
            List parts = use.parts();
            if (parts.size() == 1) {
                int line = doc.getLineOfOffset(coveredNode.getStart());
                int lineStart = doc.getLineOffset(line);
                int length = doc.getLineLength(line);
                root.addChild((TextEdit)new DeleteEdit(lineStart, length));
                return;
            }
            String currentNamespace = null;
            currentNamespace = current instanceof NamespaceName ? RemoveUnusedUseStatementProposal.getNamespaceName((NamespaceName)current) : ((Identifier)current).getName();
            int index = 0;
            for (UseStatementPart part : parts) {
                String namespace = part.getFullUseStatementName();
                if (currentNamespace.equals(namespace)) {
                    int start = part.getStart();
                    int length = 0;
                    if (index == 0) {
                        UseStatementPart next = (UseStatementPart)parts.get(1);
                        length = next.getStart() - part.getStart();
                    } else {
                        UseStatementPart prev = (UseStatementPart)parts.get(index - 1);
                        start = prev.getEnd();
                        length = part.getEnd() - start;
                    }
                    root.addChild((TextEdit)new DeleteEdit(start, length));
                    return;
                }
                ++index;
            }
        }
        catch (BadLocationException e) {
            PHPUiPlugin.log(e);
        }
    }

    private static String getNamespaceName(NamespaceName namespace) {
        StringBuilder namespaces = new StringBuilder("");
        List segments = namespace.segments();
        int idx = 0;
        for (Identifier segment : segments) {
            if (idx == 0) {
                namespaces.append(segment.getName());
            } else {
                namespaces.append("\\").append(segment.getName());
            }
            ++idx;
        }
        return namespaces.toString();
    }
}

