/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.ConnectionBendpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEndpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionLabelEvent;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramLabelDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.FunctionUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.internal.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.forms.PropertiesViewContributorPart;

public class StandardDiagramConnectionPart
extends DiagramConnectionPart
implements PropertiesViewContributorPart {
    protected DiagramConnectionTemplate connectionTemplate;
    protected IDiagramExplicitConnectionBindingDef bindingDef;
    protected Element modelElement;
    private ModelPath endpoint1Path;
    private ModelPath endpoint2Path;
    private Element srcNodeModel;
    private Element targetNodeModel;
    private ReferenceValue<?, ?> endpointReferenceValue1;
    private ReferenceValue<?, ?> endpointReferenceValue2;
    private Listener referenceServiceListener1;
    private Listener referenceServiceListener2;
    private PropertyDef endpoint1Property;
    private PropertyDef endpoint2Property;
    protected FunctionResult labelFunctionResult;
    protected Value<?> labelProperty;
    protected FunctionResult idFunctionResult;
    protected Listener modelPropertyListener;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private List<Point> bendPoints = new ArrayList<Point>();
    private Point labelPosition;
    protected static final String CONNECTION_ID_SEPARATOR = "&";

    public StandardDiagramConnectionPart() {
    }

    public StandardDiagramConnectionPart(IDiagramExplicitConnectionBindingDef bindingDef, ModelPath endpoint1Path, ModelPath endpoint2Path) {
        this.bindingDef = bindingDef;
        this.endpoint1Path = endpoint1Path;
        this.endpoint2Path = endpoint2Path;
    }

    protected void initLabelId() {
        this.connectionTemplate = (DiagramConnectionTemplate)this.parent();
        this.modelElement = this.getModelElement();
        IDiagramLabelDef labelDef = (IDiagramLabelDef)this.bindingDef.getLabel().content();
        if (labelDef != null) {
            this.labelFunctionResult = this.initExpression((Function)labelDef.getText().content(), String.class, null, new Runnable(){

                @Override
                public void run() {
                    StandardDiagramConnectionPart.this.refreshLabel();
                }
            });
            this.labelProperty = FunctionUtil.getFunctionProperty(this.modelElement, this.labelFunctionResult);
        }
        this.idFunctionResult = this.initExpression((Function)this.bindingDef.getInstanceId().content(), String.class, null, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    protected void init() {
        this.initLabelId();
        this.srcNodeModel = this.resolveEndpoint(this.modelElement, this.endpoint1Path);
        this.targetNodeModel = this.resolveEndpoint(this.modelElement, this.endpoint2Path);
        this.endpoint1Property = this.modelElement.property(this.endpoint1Path).definition();
        this.endpoint2Property = this.modelElement.property(this.endpoint2Path).definition();
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                StandardDiagramConnectionPart.this.handleModelPropertyChange(event);
            }
        };
        this.addModelListener();
        this.addReferenceServiceListeners();
    }

    public DiagramConnectionTemplate getDiagramConnectionTemplate() {
        return this.connectionTemplate;
    }

    @Override
    public Element getLocalModelElement() {
        return this.modelElement;
    }

    @Override
    public Element getEndpoint1() {
        return this.srcNodeModel;
    }

    @Override
    public Element getEndpoint2() {
        return this.targetNodeModel;
    }

    @Override
    public boolean canEditLabel() {
        return this.labelProperty != null;
    }

    @Override
    public boolean removable() {
        return true;
    }

    @Override
    public void remove() {
        Element element = this.getLocalModelElement();
        ElementList list = (ElementList)element.parent();
        list.remove((Object)element);
        this.pruneListParentIfNecessary(list);
    }

    private void pruneListParentIfNecessary(ElementList<?> list) {
        if (list.isEmpty() && this.connectionTemplate.getConnectionType() == DiagramConnectionTemplate.ConnectionType.OneToMany && list.element().parent() instanceof ElementList) {
            ElementList grandParent = (ElementList)list.element().parent();
            grandParent.remove((Object)list.element());
        }
    }

    @Override
    public String getLabel() {
        String label = null;
        if (this.labelFunctionResult != null) {
            label = (String)this.labelFunctionResult.value();
        }
        return label;
    }

    @Override
    public void setLabel(String newValue) {
        if (this.labelProperty != null) {
            this.labelProperty.write((Object)newValue, true);
        }
    }

    @Override
    public IDiagramConnectionDef getConnectionDef() {
        return (IDiagramConnectionDef)this.definition();
    }

    public void refreshLabel() {
        this.notifyUpdateLabel();
    }

    @Override
    public String getConnectionTypeId() {
        return (String)this.definition.getId().content();
    }

    public String getInstanceId() {
        String id = null;
        if (this.idFunctionResult != null) {
            id = (String)this.idFunctionResult.value();
        }
        return id;
    }

    @Override
    public String getId() {
        StringBuffer buffer = new StringBuffer(this.getConnectionTypeId());
        buffer.append(CONNECTION_ID_SEPARATOR);
        String instanceId = this.getInstanceId();
        if (instanceId != null && instanceId.length() > 0) {
            buffer.append(this.getInstanceId());
            buffer.append(CONNECTION_ID_SEPARATOR);
        }
        List<StandardDiagramConnectionPart> connParts = this.getDiagramConnectionTemplate().getDiagramConnections(null);
        int index = connParts.indexOf(this);
        buffer.append(index);
        return buffer.toString();
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram.Connection");
        contextSet.add("Sapphire.Diagram.Connection.Hidden");
        return contextSet;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        if (this.idFunctionResult != null) {
            this.idFunctionResult.dispose();
        }
        this.removeModelListener();
    }

    protected void resetEndpoint1(DiagramNodePart newSrcNode) {
        this.srcNodeModel = newSrcNode.getLocalModelElement();
        String endpoint1Value = this.connectionTemplate.getSerializedEndpoint1(newSrcNode);
        this.connectionTemplate.setSerializedEndpoint1(this.modelElement, endpoint1Value);
    }

    protected void resetEndpoint2(DiagramNodePart newTargetNode) {
        this.targetNodeModel = newTargetNode.getLocalModelElement();
        String endpoint2Value = this.connectionTemplate.getSerializedEndpoint2(newTargetNode);
        this.connectionTemplate.setSerializedEndpoint2(this.modelElement, endpoint2Value);
    }

    protected Element resolveEndpoint(Element modelElement, ModelPath endpointPath) {
        if (endpointPath.length() == 1) {
            SapphireDiagramEditorPagePart diagramEditorPart;
            DiagramNodePart targetNode;
            String propertyName = ((ModelPath.PropertySegment)endpointPath.head()).getPropertyName();
            PropertyDef modelProperty = this.resolve(modelElement, propertyName);
            if (!(modelProperty instanceof ValueProperty)) {
                throw new RuntimeException("Property " + propertyName + " not a ValueProperty");
            }
            ValueProperty property = (ValueProperty)modelProperty;
            Value valObj = modelElement.property(property);
            if (!(valObj instanceof ReferenceValue)) {
                throw new RuntimeException("Property " + propertyName + " value not a reference");
            }
            ReferenceValue refVal = (ReferenceValue)valObj;
            Object targetObj = refVal.target();
            if (targetObj == null && refVal.text() != null && (targetNode = (diagramEditorPart = this.getDiagramConnectionTemplate().getDiagramEditor()).getNode(refVal.text())) != null) {
                targetObj = targetNode.getLocalModelElement();
            }
            return (Element)targetObj;
        }
        ModelPath.Segment head = endpointPath.head();
        if (head instanceof ModelPath.ParentElementSegment) {
            Property parent = modelElement.parent();
            if (parent == null) {
                throw new RuntimeException("Invalid model path: " + endpointPath);
            }
            return this.resolveEndpoint(parent.element(), endpointPath.tail());
        }
        throw new RuntimeException("Invalid model path: " + endpointPath);
    }

    protected ReferenceValue<?, ?> resolveEndpointReferenceValue(Element modelElement, ModelPath endpointPath) {
        if (endpointPath.length() == 1) {
            String propertyName = ((ModelPath.PropertySegment)endpointPath.head()).getPropertyName();
            PropertyDef modelProperty = this.resolve(modelElement, propertyName);
            if (!(modelProperty instanceof ValueProperty)) {
                throw new RuntimeException("Property " + propertyName + " not a ValueProperty");
            }
            ValueProperty property = (ValueProperty)modelProperty;
            Value valObj = modelElement.property(property);
            if (!(valObj instanceof ReferenceValue)) {
                throw new RuntimeException("Property " + propertyName + " value not a reference");
            }
            ReferenceValue refVal = (ReferenceValue)valObj;
            return refVal;
        }
        ModelPath.Segment head = endpointPath.head();
        if (head instanceof ModelPath.ParentElementSegment) {
            Property parent = modelElement.parent();
            if (parent == null) {
                throw new RuntimeException("Invalid model path: " + endpointPath);
            }
            return this.resolveEndpointReferenceValue(parent.element(), endpointPath.tail());
        }
        throw new RuntimeException("Invalid model path: " + endpointPath);
    }

    protected void setModelProperty(Element modelElement, String propertyName, Object value) {
        if (propertyName != null) {
            ElementType type = modelElement.type();
            PropertyDef property = type.property(propertyName);
            if (property == null) {
                throw new RuntimeException("Could not find property " + propertyName + " in " + type.getQualifiedName());
            }
            if (!(property instanceof ValueProperty)) {
                throw new RuntimeException("Property " + propertyName + " not a ValueProperty");
            }
            modelElement.property((ValueProperty)property).write(value, true);
        }
    }

    protected void setModelProperty(Element modelElement, ModelPath propertyPath, Object value) {
        if (propertyPath.length() == 1) {
            String propertyName = ((ModelPath.PropertySegment)propertyPath.head()).getPropertyName();
            this.setModelProperty(modelElement, propertyName, value);
        } else if (propertyPath.head() instanceof ModelPath.ParentElementSegment) {
            Property parent = modelElement.parent();
            this.setModelProperty(parent.element(), propertyPath.tail(), value);
        }
    }

    public void addModelListener() {
        this.modelElement.attach(this.modelPropertyListener, this.endpoint1Path);
        this.modelElement.attach(this.modelPropertyListener, this.endpoint2Path);
    }

    public void removeModelListener() {
        this.modelElement.detach(this.modelPropertyListener, this.endpoint1Path);
        this.modelElement.detach(this.modelPropertyListener, this.endpoint2Path);
    }

    public void addReferenceServiceListeners() {
        ReferenceService refService;
        this.endpointReferenceValue1 = this.resolveEndpointReferenceValue(this.modelElement, this.endpoint1Path);
        if (this.endpointReferenceValue1 != null) {
            refService = (ReferenceService)this.endpointReferenceValue1.service(ReferenceService.class);
            this.referenceServiceListener1 = new Listener(){

                public void handle(Event event) {
                    StandardDiagramConnectionPart.this.handleEndpoint1ReferenceChange();
                }
            };
            if (refService != null) {
                refService.attach(this.referenceServiceListener1);
            }
        }
        this.endpointReferenceValue2 = this.resolveEndpointReferenceValue(this.modelElement, this.endpoint2Path);
        if (this.endpointReferenceValue2 != null) {
            refService = (ReferenceService)this.endpointReferenceValue2.service(ReferenceService.class);
            this.referenceServiceListener2 = new Listener(){

                public void handle(Event event) {
                    StandardDiagramConnectionPart.this.handleEndpoint2ReferenceChange();
                }
            };
            if (refService != null) {
                refService.attach(this.referenceServiceListener2);
            }
        }
    }

    @Override
    public StandardDiagramConnectionPart reconnect(DiagramNodePart newSrcNode, DiagramNodePart newTargetNode) {
        if (newSrcNode != null && newSrcNode.getLocalModelElement() == this.getEndpoint1() && newTargetNode != null && newTargetNode.getLocalModelElement() == this.getEndpoint2()) {
            return this;
        }
        if (newSrcNode != null && newTargetNode != null) {
            StandardDiagramConnectionPart newConnPart = this.getDiagramConnectionTemplate().createNewDiagramConnection(newSrcNode, newTargetNode);
            Element oldConnElement = this.getLocalModelElement();
            newConnPart.getLocalModelElement().copy(oldConnElement);
            newConnPart.resetBendpoints(this.getBendpoints());
            if (newSrcNode.getLocalModelElement() != this.getEndpoint1()) {
                newConnPart.resetEndpoint1(newSrcNode);
            }
            if (newTargetNode.getLocalModelElement() != this.getEndpoint2()) {
                newConnPart.resetEndpoint2(newTargetNode);
            }
            ElementList list = (ElementList)oldConnElement.parent();
            list.remove((Object)oldConnElement);
            this.pruneListParentIfNecessary(list);
            return newConnPart;
        }
        return null;
    }

    protected void handleModelPropertyChange(PropertyEvent event) {
        PropertyDef property = event.property().definition();
        if (property.name().equals(this.endpoint1Property.name()) || property.name().equals(this.endpoint2Property.name())) {
            boolean sourceChange;
            boolean bl = sourceChange = property.name().equals(this.endpoint1Property.name());
            if (sourceChange) {
                this.srcNodeModel = this.resolveEndpoint(this.modelElement, this.endpoint1Path);
            } else {
                this.targetNodeModel = this.resolveEndpoint(this.modelElement, this.endpoint2Path);
            }
            this.notifyConnectionEndpointUpdate();
        }
    }

    protected void handleEndpoint1ReferenceChange() {
        Element newSourceModel = this.resolveEndpoint(this.modelElement, this.endpoint1Path);
        if (newSourceModel != this.srcNodeModel) {
            this.srcNodeModel = newSourceModel;
            this.notifyConnectionEndpointUpdate();
        }
    }

    protected void handleEndpoint2ReferenceChange() {
        Element newTargetModel = this.resolveEndpoint(this.modelElement, this.endpoint2Path);
        if (newTargetModel != this.targetNodeModel) {
            this.targetNodeModel = newTargetModel;
            this.notifyConnectionEndpointUpdate();
        }
    }

    protected void notifyUpdateLabel() {
        ConnectionLabelEvent labelEvent = new ConnectionLabelEvent(this, false);
        this.broadcast(labelEvent);
    }

    protected void notifyConnectionEndpointUpdate() {
        ConnectionEndpointsEvent event = new ConnectionEndpointsEvent(this);
        this.broadcast(event);
    }

    protected void notifyAddBendpoint() {
        ConnectionBendpointsEvent event = new ConnectionBendpointsEvent(this);
        this.broadcast(event);
    }

    protected void notifyRemoveBendpoint() {
        ConnectionBendpointsEvent event = new ConnectionBendpointsEvent(this);
        this.broadcast(event);
    }

    protected void notifyMoveBendpoint() {
        ConnectionBendpointsEvent event = new ConnectionBendpointsEvent(this);
        this.broadcast(event);
    }

    protected void notifyResetBendpoints() {
        ConnectionBendpointsEvent event = new ConnectionBendpointsEvent(this, true);
        this.broadcast(event);
    }

    protected void notifyMoveConnectionLabel() {
        ConnectionLabelEvent labelEvent = new ConnectionLabelEvent(this, true);
        this.broadcast(labelEvent);
    }

    @Override
    public PropertiesViewContributionPart getPropertiesViewContribution() {
        if (this.propertiesViewContributionManager == null) {
            this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.getLocalModelElement(), this.getConnectionDef());
        }
        return this.propertiesViewContributionManager.getPropertiesViewContribution();
    }

    @Override
    public void addBendpoint(int index, int x, int y) {
        this.bendPoints.add(index, new Point(x, y));
        this.notifyAddBendpoint();
    }

    @Override
    public void removeBendpoint(int index) {
        this.bendPoints.remove(index);
        this.notifyRemoveBendpoint();
    }

    @Override
    public void removeAllBendpoints() {
        this.bendPoints.clear();
        this.notifyRemoveBendpoint();
    }

    @Override
    public void updateBendpoint(int index, int x, int y) {
        if (index < this.bendPoints.size()) {
            this.bendPoints.set(index, new Point(x, y));
        }
        this.notifyMoveBendpoint();
    }

    @Override
    public void resetBendpoints(List<Point> bendpoints) {
        boolean changed = false;
        if (bendpoints.size() != this.bendPoints.size()) {
            changed = true;
        } else {
            int i = 0;
            while (i < bendpoints.size()) {
                Point newPt = bendpoints.get(i);
                Point oldPt = this.bendPoints.get(i);
                if (newPt.getX() != oldPt.getX() || newPt.getY() != oldPt.getY()) {
                    changed = true;
                    break;
                }
                ++i;
            }
        }
        if (changed) {
            this.bendPoints.clear();
            this.bendPoints.addAll(bendpoints);
            this.notifyResetBendpoints();
        }
    }

    @Override
    public List<Point> getBendpoints() {
        ArrayList<Point> bendPoints = new ArrayList<Point>();
        bendPoints.addAll(this.bendPoints);
        return bendPoints;
    }

    @Override
    public Point getLabelPosition() {
        return this.labelPosition;
    }

    @Override
    public void setLabelPosition(Point newPos) {
        boolean changed = false;
        if (this.labelPosition == null && newPos != null) {
            this.labelPosition = new Point(newPos);
            changed = true;
        } else if (this.labelPosition != null && newPos == null) {
            this.labelPosition = null;
            changed = true;
        } else if (this.labelPosition != null && newPos != null && !this.labelPosition.equals(newPos)) {
            this.labelPosition.setX(newPos.getX());
            this.labelPosition.setY(newPos.getY());
            changed = true;
        }
        if (changed) {
            this.notifyMoveConnectionLabel();
        }
    }
}

