/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.history.data.SVNLocalFileRevision;
import org.eclipse.team.svn.ui.history.model.AbstractLogNode;
import org.eclipse.team.svn.ui.history.model.ILogNode;
import org.eclipse.team.svn.ui.utility.DateFormatter;

public class LocalLogNode
extends AbstractLogNode {
    protected SVNLocalFileRevision entry;

    public LocalLogNode(SVNLocalFileRevision entry, ILogNode parent) {
        super(parent);
        this.entry = entry;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IFileRevision.class)) {
            return this.entry;
        }
        return null;
    }

    public ILogNode[] getChildren() {
        return null;
    }

    public Object getEntity() {
        return this.entry;
    }

    public boolean requiresBoldFont(long currentRevision) {
        return this.entry.isCurrentState();
    }

    public ImageDescriptor getImageDescriptor() {
        return SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/local_rev.gif");
    }

    public String getLabel(int columnIndex, int labelType, long currentRevision) {
        switch (columnIndex) {
            case 1: {
                return DateFormatter.formatDate(this.entry.getTimestamp());
            }
            case 0: {
                if (this.entry.isCurrentState()) {
                    if (currentRevision != -1L) {
                        return SVNUIMessages.format((String)SVNUIMessages.LogMessagesComposite_CurrentRevision, (Object[])new String[]{String.valueOf(currentRevision)});
                    }
                    return "*";
                }
                return "";
            }
            case 4: {
                String retVal = this.entry.getComment();
                if (labelType == 0) {
                    return FileUtility.formatMultilineText((String)retVal);
                }
                if (labelType == 1) {
                    return AbstractLogNode.flattenMultiLineText(retVal, " ");
                }
                return retVal;
            }
        }
        return "";
    }

    public int getType() {
        return 3;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getAuthor() {
        return "";
    }

    public int getChangesCount() {
        return 0;
    }

    public String getComment() {
        return this.entry.getComment();
    }

    public long getRevision() {
        return -1L;
    }

    public long getTimeStamp() {
        return this.entry.getTimestamp();
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalLogNode) {
            return this.entry.equals((Object)((LocalLogNode)obj).entry);
        }
        return false;
    }
}

