/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.wizard.AbstractSVNWizard;
import org.eclipse.team.svn.ui.wizard.shareproject.AddRepositoryLocationPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewRepositoryLocationWizard
extends AbstractSVNWizard
implements INewWizard {
    protected AddRepositoryLocationPage locationPage;
    protected IRepositoryLocation editable;
    protected boolean performAction;
    protected IRepositoryLocation backup;

    public NewRepositoryLocationWizard() {
        this(null, true);
    }

    public NewRepositoryLocationWizard(IRepositoryLocation editable, boolean performAction) {
        this.performAction = performAction;
        this.editable = editable;
        if (this.editable != null) {
            this.setWindowTitle(SVNUIMessages.NewRepositoryLocationWizard_Title_Edit);
            this.backup = SVNRemoteStorage.instance().newRepositoryLocation();
            SVNRemoteStorage.instance().copyRepositoryLocation(this.backup, editable);
        } else {
            this.setWindowTitle(SVNUIMessages.NewRepositoryLocationWizard_Title_New);
        }
    }

    public void addPages() {
        this.locationPage = new AddRepositoryLocationPage(this.editable);
        this.addPage((IWizardPage)this.locationPage);
    }

    public IActionOperation getOperationToPerform() {
        return this.locationPage.getOperationToPeform();
    }

    public boolean performCancel() {
        if (this.editable != null) {
            SVNRemoteStorage.instance().copyRepositoryLocation(this.editable, this.backup);
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        if (this.locationPage.performFinish()) {
            IActionOperation op;
            if (this.performAction && (op = this.locationPage.getOperationToPeform()) != null) {
                UIMonitorUtility.doTaskBusyDefault(op);
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

