/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.context.surrogate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.util.IProvider;
import org.eclipse.viatra.query.runtime.matchers.util.SingletonInstanceProvider;

public class SurrogateQueryRegistry {
    private Map<IInputKey, IProvider<PQuery>> registeredSurrogateQueryMap = Maps.newHashMap();
    private Map<IInputKey, IProvider<PQuery>> dynamicSurrogateQueryMap = Maps.newHashMap();
    private static final SurrogateQueryRegistry INSTANCE = new SurrogateQueryRegistry();

    private SurrogateQueryRegistry() {
    }

    public static SurrogateQueryRegistry instance() {
        return INSTANCE;
    }

    public IProvider<PQuery> registerSurrogateQueryForFeature(IInputKey feature, PQuery surrogateQuery) {
        Preconditions.checkArgument((surrogateQuery != null ? 1 : 0) != 0, (Object)"Surrogate query must not be null!");
        return this.registerSurrogateQueryForFeature(feature, new SingletonInstanceProvider<PQuery>(surrogateQuery));
    }

    public IProvider<PQuery> registerSurrogateQueryForFeature(IInputKey feature, IProvider<PQuery> surrogateQueryProvider) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        Preconditions.checkArgument((surrogateQueryProvider != null ? 1 : 0) != 0, (Object)"Surrogate query must not be null!");
        return this.registeredSurrogateQueryMap.put(feature, surrogateQueryProvider);
    }

    public IProvider<PQuery> addDynamicSurrogateQueryForFeature(IInputKey feature, PQuery surrogateQuery) {
        Preconditions.checkArgument((surrogateQuery != null ? 1 : 0) != 0, (Object)"Surrogate query FQN must not be null!");
        return this.addDynamicSurrogateQueryForFeature(feature, new SingletonInstanceProvider<PQuery>(surrogateQuery));
    }

    public IProvider<PQuery> addDynamicSurrogateQueryForFeature(IInputKey feature, IProvider<PQuery> surrogateQuery) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        Preconditions.checkArgument((surrogateQuery != null ? 1 : 0) != 0, (Object)"Surrogate query FQN must not be null!");
        return this.dynamicSurrogateQueryMap.put(feature, surrogateQuery);
    }

    public IProvider<PQuery> removeDynamicSurrogateQueryForFeature(IInputKey feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        return this.dynamicSurrogateQueryMap.remove(feature);
    }

    public boolean hasSurrogateQueryFQN(IInputKey feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        boolean surrogateExists = this.dynamicSurrogateQueryMap.containsKey(feature);
        if (!surrogateExists) {
            surrogateExists = this.registeredSurrogateQueryMap.containsKey(feature);
        }
        return surrogateExists;
    }

    public PQuery getSurrogateQuery(IInputKey feature) {
        Preconditions.checkArgument((feature != null ? 1 : 0) != 0, (Object)"Feature must not be null!");
        IProvider<PQuery> surrogate = this.dynamicSurrogateQueryMap.get(feature);
        if (surrogate == null) {
            surrogate = this.registeredSurrogateQueryMap.get(feature);
        }
        if (surrogate != null) {
            return surrogate.get();
        }
        throw new NoSuchElementException(String.format("Feature %s has no surrogate query defined! Use #hasSurrogateQueryFQN to check existence.", feature));
    }

    public Set<IInputKey> getRegisteredSurrogateQueries() {
        return ImmutableSet.builder().addAll(this.getRegisteredSurrogateQueriesInternal()).build();
    }

    private Set<IInputKey> getRegisteredSurrogateQueriesInternal() {
        return this.registeredSurrogateQueryMap.keySet();
    }

    public Set<IInputKey> getDynamicSurrogateQueries() {
        return ImmutableSet.builder().addAll(this.getDynamicSurrogateQueriesInternal()).build();
    }

    private Set<IInputKey> getDynamicSurrogateQueriesInternal() {
        return this.dynamicSurrogateQueryMap.keySet();
    }

    public Set<IInputKey> getAllSurrogateQueries() {
        return Sets.union(this.getRegisteredSurrogateQueriesInternal(), this.getDynamicSurrogateQueriesInternal());
    }
}

