/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.io.Serializable;
import org.gradle.api.Incubating;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.impldep.org.apache.commons.lang.builder.EqualsBuilder;
import org.gradle.internal.impldep.org.apache.commons.lang.builder.HashCodeBuilder;

public class DefaultParallelismConfiguration
implements Serializable,
ParallelismConfiguration {
    public static final ParallelismConfiguration DEFAULT = new DefaultParallelismConfiguration();
    private boolean parallelProjectExecution;
    private int maxWorkerCount;

    public DefaultParallelismConfiguration() {
        this.maxWorkerCount = Runtime.getRuntime().availableProcessors();
    }

    public DefaultParallelismConfiguration(boolean parallelProjectExecution, int maxWorkerCount) {
        this.parallelProjectExecution = parallelProjectExecution;
        this.maxWorkerCount = maxWorkerCount;
    }

    @Incubating
    public boolean isParallelProjectExecutionEnabled() {
        return this.parallelProjectExecution;
    }

    @Incubating
    public void setParallelProjectExecutionEnabled(boolean parallelProjectExecution) {
        this.parallelProjectExecution = parallelProjectExecution;
    }

    @Incubating
    public int getMaxWorkerCount() {
        return this.maxWorkerCount;
    }

    @Incubating
    public void setMaxWorkerCount(int maxWorkerCount) {
        if (maxWorkerCount < 1) {
            throw new IllegalArgumentException("Max worker count must be > 0");
        }
        this.maxWorkerCount = maxWorkerCount;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}

