/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.junit.jupiter.engine.discovery.predicates.IsNestedTestClass;
import org.junit.jupiter.engine.discovery.predicates.IsPotentialTestContainer;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestTemplateMethod;
import org.junit.platform.commons.util.ReflectionUtils;

class IsTestClassWithTests
implements Predicate<Class<?>> {
    private static final IsTestMethod isTestMethod = new IsTestMethod();
    private static final IsTestFactoryMethod isTestFactoryMethod = new IsTestFactoryMethod();
    private static final IsTestTemplateMethod isTestTemplateMethod = new IsTestTemplateMethod();
    private static final Predicate<Method> isTestOrTestFactoryOrTestTemplateMethod = isTestMethod.or(isTestFactoryMethod).or(isTestTemplateMethod);
    private static final IsPotentialTestContainer isPotentialTestContainer = new IsPotentialTestContainer();
    private static final IsNestedTestClass isNestedTestClass = new IsNestedTestClass();

    IsTestClassWithTests() {
    }

    @Override
    public boolean test(Class<?> candidate) {
        if (!isPotentialTestContainer.test(candidate)) {
            return false;
        }
        return this.hasTestOrTestFactoryOrTestTemplateMethods(candidate) || this.hasNestedTests(candidate);
    }

    private boolean hasTestOrTestFactoryOrTestTemplateMethods(Class<?> candidate) {
        return ReflectionUtils.isMethodPresent(candidate, isTestOrTestFactoryOrTestTemplateMethod);
    }

    private boolean hasNestedTests(Class<?> candidate) {
        return !ReflectionUtils.findNestedClasses(candidate, (Predicate)isNestedTestClass).isEmpty();
    }
}

