/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.rules;

import java.lang.reflect.Member;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.migrationsupport.rules.adapter.AbstractTestRuleAdapter;
import org.junit.jupiter.migrationsupport.rules.adapter.GenericBeforeAndAfterAdvice;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMember;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMemberFactory;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.rules.TestRule;

abstract class AbstractTestRuleSupport<T extends Member>
implements BeforeEachCallback,
TestExecutionExceptionHandler,
AfterEachCallback {
    private final Class<? extends TestRule> ruleType;
    private final Function<TestRuleAnnotatedMember, AbstractTestRuleAdapter> adapterGenerator;

    AbstractTestRuleSupport(Function<TestRuleAnnotatedMember, AbstractTestRuleAdapter> adapterGenerator, Class<? extends TestRule> ruleType) {
        this.adapterGenerator = adapterGenerator;
        this.ruleType = ruleType;
    }

    protected abstract List<T> findRuleAnnotatedMembers(Object var1);

    protected Class<? extends TestRule> getRuleType() {
        return this.ruleType;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.invokeAppropriateMethodOnRuleAnnotatedMembers(context, GenericBeforeAndAfterAdvice::before);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.invokeAppropriateMethodOnRuleAnnotatedMembers(context, advice -> {
            try {
                advice.handleTestExecutionException(throwable);
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.invokeAppropriateMethodOnRuleAnnotatedMembers(context, GenericBeforeAndAfterAdvice::after);
    }

    private void invokeAppropriateMethodOnRuleAnnotatedMembers(ExtensionContext context, Consumer<GenericBeforeAndAfterAdvice> methodCaller) {
        Object testInstance = context.getRequiredTestInstance();
        List<T> members = this.findRuleAnnotatedMembers(testInstance);
        members.stream().map(member -> TestRuleAnnotatedMemberFactory.from(testInstance, member)).map(this.adapterGenerator).forEach(methodCaller::accept);
    }
}

