/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.transport.smtp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.SSLSocket;
import org.apache.geronimo.javamail.authentication.ClientAuthenticator;
import org.apache.geronimo.javamail.authentication.CramMD5Authenticator;
import org.apache.geronimo.javamail.authentication.DigestMD5Authenticator;
import org.apache.geronimo.javamail.authentication.LoginAuthenticator;
import org.apache.geronimo.javamail.authentication.PlainAuthenticator;
import org.apache.geronimo.javamail.transport.smtp.MalformedSMTPReplyException;
import org.apache.geronimo.javamail.transport.smtp.SMTPAddressFailedException;
import org.apache.geronimo.javamail.transport.smtp.SMTPAddressSucceededException;
import org.apache.geronimo.javamail.transport.smtp.SMTPMessage;
import org.apache.geronimo.javamail.transport.smtp.SMTPReply;
import org.apache.geronimo.javamail.transport.smtp.SMTPSendFailedException;
import org.apache.geronimo.javamail.util.MIMEOutputStream;
import org.apache.geronimo.javamail.util.TraceInputStream;
import org.apache.geronimo.javamail.util.TraceOutputStream;
import org.apache.geronimo.mail.util.Base64;
import org.apache.geronimo.mail.util.XText;

public class SMTPTransport
extends Transport {
    protected static final char CR = '\r';
    protected static final char LF = '\n';
    protected static final String MAIL_LOCALHOST = "mail.localhost";
    protected static final String MAIL_SSLFACTORY_CLASS = "mail.SSLSocketFactory.class";
    protected static final String MAIL_SMTP_AUTH = "auth";
    protected static final String MAIL_SMTP_PORT = "port";
    protected static final String MAIL_SMTP_LOCALHOST = "localhost";
    protected static final String MAIL_SMTP_TIMEOUT = "timeout";
    protected static final String MAIL_SMTP_SASL_REALM = "sasl.realm";
    protected static final String MAIL_SMTP_TLS = "starttls.enable";
    protected static final String MAIL_SMTP_FACTORY_CLASS = "socketFactory.class";
    protected static final String MAIL_SMTP_FACTORY_FALLBACK = "socketFactory.fallback";
    protected static final String MAIL_SMTP_FACTORY_PORT = "socketFactory.port";
    protected static final String MAIL_SMTP_REPORT_SUCCESS = "reportsuccess";
    protected static final String MAIL_SMTP_STARTTLS_ENABLE = "starttls.enable";
    protected static final String MAIL_SMTP_DSN_NOTIFY = "dsn.notify";
    protected static final String MAIL_SMTP_SENDPARTIAL = "sendpartial";
    protected static final String MAIL_SMTP_LOCALADDRESS = "localaddress";
    protected static final String MAIL_SMTP_LOCALPORT = "localport";
    protected static final String MAIL_SMTP_QUITWAIT = "quitwait";
    protected static final String MAIL_SMTP_FROM = "from";
    protected static final String MAIL_SMTP_DSN_RET = "dsn.ret";
    protected static final String MAIL_SMTP_SUBMITTER = "submitter";
    protected static final String MAIL_SMTP_EXTENSION = "mailextension";
    protected static final String MAIL_SMTP_EHLO = "ehlo";
    protected static final String MAIL_SMTP_ENCODE_TRACE = "encodetrace";
    protected static final int MIN_MILLIS = 60000;
    protected static final int TIMEOUT = 300000;
    protected static final String DEFAULT_MAIL_HOST = "localhost";
    protected static final int DEFAULT_MAIL_SMTP_PORT = 25;
    protected static final int DEFAULT_MAIL_SMTPS_PORT = 465;
    protected static final int SERVICE_READY = 220;
    protected static final int SERVICE_CLOSING = 221;
    protected static final int AUTHENTICATION_COMPLETE = 235;
    protected static final int COMMAND_ACCEPTED = 250;
    protected static final int ADDRESS_NOT_LOCAL = 251;
    protected static final int AUTHENTICATION_CHALLENGE = 334;
    protected static final int START_MAIL_INPUT = 354;
    protected static final int SERVICE_NOT_AVAILABLE = 421;
    protected static final int MAILBOX_BUSY = 450;
    protected static final int PROCESSING_ERROR = 451;
    protected static final int INSUFFICIENT_STORAGE = 452;
    protected static final int COMMAND_SYNTAX_ERROR = 500;
    protected static final int PARAMETER_SYNTAX_ERROR = 501;
    protected static final int COMMAND_NOT_IMPLEMENTED = 502;
    protected static final int INVALID_COMMAND_SEQUENCE = 503;
    protected static final int COMMAND_PARAMETER_NOT_IMPLEMENTED = 504;
    protected static final int MAILBOX_NOT_FOUND = 550;
    protected static final int USER_NOT_LOCAL = 551;
    protected static final int MAILBOX_FULL = 552;
    protected static final int INVALID_MAILBOX = 553;
    protected static final int TRANSACTION_FAILED = 553;
    protected static final String AUTHENTICATION_PLAIN = "PLAIN";
    protected static final String AUTHENTICATION_LOGIN = "LOGIN";
    protected static final String AUTHENTICATION_CRAMMD5 = "CRAM-MD5";
    protected static final String AUTHENTICATION_DIGESTMD5 = "DIGEST-MD5";
    protected String protocol;
    protected String host;
    protected int defaultPort;
    protected int port;
    protected Socket socket;
    protected String localHost;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected HashMap serverAuthenticationMechanisms;
    protected HashMap serverExtensionArgs;
    protected boolean reportSuccess;
    protected boolean serverTLS = false;
    protected boolean useTLS = false;
    protected boolean sslConnection = false;
    protected String username;
    protected String password;
    protected String realm;
    protected SMTPReply lastServerResponse = null;
    protected PrintStream debugStream;

    public SMTPTransport(Session session, URLName name) {
        this(session, name, "smtp", 25, false);
    }

    protected SMTPTransport(Session session, URLName name, String protocol, int defaultPort, boolean sslConnection) {
        super(session, name);
        this.protocol = protocol;
        this.defaultPort = defaultPort;
        this.sslConnection = sslConnection;
        this.reportSuccess = this.isProtocolPropertyTrue(MAIL_SMTP_REPORT_SUCCESS);
        this.useTLS = this.isProtocolPropertyTrue("starttls.enable");
        this.debugStream = session.getDebugOut();
    }

    public void connect(Socket socket) throws MessagingException {
        this.socket = socket;
        super.connect();
    }

    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        boolean mustAuthenticate;
        if (this.debug) {
            this.debugOut("Connecting to server " + host + ":" + port + " for user " + username);
        }
        if ((mustAuthenticate = this.isProtocolPropertyTrue(MAIL_SMTP_AUTH)) && (username == null || password == null)) {
            return false;
        }
        if (port == -1) {
            port = this.defaultPort;
            String configuredPort = this.getProtocolProperty(MAIL_SMTP_PORT);
            if (configuredPort != null) {
                port = Integer.parseInt(configuredPort);
            }
        }
        if (host == null) {
            host = "localhost";
        }
        try {
            this.getConnection(host, port, username, password);
            if (!this.getWelcome()) {
                throw new MessagingException("Error in getting welcome msg");
            }
            if (!this.sendHandshake()) {
                throw new MessagingException("Error in saying EHLO to server");
            }
            if (!this.processAuthentication()) {
                if (this.debug) {
                    this.debugOut("User authentication failure");
                }
                throw new AuthenticationFailedException("Error authenticating with server");
            }
        }
        catch (IOException e) {
            if (this.debug) {
                this.debugOut("I/O exception establishing connection", e);
            }
            throw new MessagingException("Connection error", e);
        }
        return true;
    }

    public void sendMessage(Message message, Address[] addresses) throws MessagingException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        if (message == null) {
            throw new MessagingException("Null message");
        }
        if (!(message instanceof MimeMessage)) {
            throw new MessagingException("SMTP can only send MimeMessages");
        }
        if (addresses == null || addresses.length == 0) {
            throw new MessagingException("Null or empty address array");
        }
        boolean haveGroup = false;
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i] instanceof InternetAddress) {
                if (!((InternetAddress)addresses[i]).isGroup()) continue;
                haveGroup = true;
                continue;
            }
            throw new MessagingException("Illegal InternetAddress " + addresses[i]);
        }
        if (haveGroup) {
            addresses = this.expandGroups(addresses);
        }
        SendStatus[] stats = new SendStatus[addresses.length];
        Address[] sent = null;
        Address[] unsent = null;
        Address[] invalid = null;
        try {
            MessagingException successes;
            if (!this.sendMailFrom(message)) {
                unsent = addresses;
                sent = new Address[]{};
                invalid = new Address[]{};
                this.notifyTransportListeners(2, sent, unsent, invalid, message);
                SMTPReply last = this.lastServerResponse;
                throw new SMTPSendFailedException("MAIL FROM", last.getCode(), last.getMessage(), null, sent, unsent, invalid);
            }
            String dsn = null;
            if (message instanceof SMTPMessage) {
                int options = ((SMTPMessage)message).getNotifyOptions();
                switch (options) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        dsn = "NEVER";
                        break;
                    }
                    case 1: {
                        dsn = "SUCCESS";
                        break;
                    }
                    case 2: {
                        dsn = "FAILURE";
                        break;
                    }
                    case 4: {
                        dsn = "DELAY";
                        break;
                    }
                    case 3: {
                        dsn = "SUCCESS,FAILURE";
                        break;
                    }
                    case 5: {
                        dsn = "SUCCESS,DELAY";
                        break;
                    }
                    case 6: {
                        dsn = "FAILURE,DELAY";
                        break;
                    }
                    case 7: {
                        dsn = "SUCCESS,FAILURE,DELAY";
                    }
                }
            }
            if (dsn == null) {
                dsn = this.getProtocolProperty(MAIL_SMTP_DSN_NOTIFY);
            }
            boolean sendFailure = false;
            ArrayList<InternetAddress> sentAddresses = new ArrayList<InternetAddress>();
            ArrayList<InternetAddress> unsentAddresses = new ArrayList<InternetAddress>();
            ArrayList<InternetAddress> invalidAddresses = new ArrayList<InternetAddress>();
            block22: for (int i = 0; i < addresses.length; ++i) {
                SendStatus status;
                InternetAddress target = (InternetAddress)addresses[i];
                stats[i] = status = this.sendRcptTo(target, dsn);
                switch (status.getStatus()) {
                    case 0: {
                        sentAddresses.add(target);
                        continue block22;
                    }
                    case 1: 
                    case 3: {
                        sendFailure = true;
                        invalidAddresses.add(target);
                        continue block22;
                    }
                    case 2: {
                        sendFailure = true;
                        unsentAddresses.add(target);
                    }
                }
            }
            if (sendFailure) {
                boolean partialSends = false;
                if (message instanceof SMTPMessage) {
                    partialSends = ((SMTPMessage)message).getSendPartial();
                }
                if (!partialSends) {
                    partialSends = this.isProtocolPropertyTrue(MAIL_SMTP_SENDPARTIAL);
                }
                if (!partialSends || sentAddresses.isEmpty()) {
                    unsentAddresses.addAll(sentAddresses);
                    sent = new Address[]{};
                    unsent = unsentAddresses.toArray(new Address[0]);
                    invalid = invalidAddresses.toArray(new Address[0]);
                    this.resetConnection();
                    MessagingException failures = this.generateExceptionChain(stats, false);
                    throw new SMTPSendFailedException("MAIL TO", 0, "Invalid Address", failures, sent, unsent, invalid);
                }
            }
            try {
                this.sendData(message);
            }
            catch (MessagingException e) {
                unsentAddresses.addAll(sentAddresses);
                sent = new Address[]{};
                unsent = unsentAddresses.toArray(new Address[0]);
                invalid = invalidAddresses.toArray(new Address[0]);
                this.notifyTransportListeners(2, sent, unsent, invalid, message);
                throw new SMTPSendFailedException("DATA", 0, "Send failure", e, sent, unsent, invalid);
            }
            sent = sentAddresses.toArray(new Address[0]);
            unsent = unsentAddresses.toArray(new Address[0]);
            invalid = invalidAddresses.toArray(new Address[0]);
            if (sendFailure) {
                this.notifyTransportListeners(3, sent, unsent, invalid, message);
                MessagingException failures = this.generateExceptionChain(stats, this.getReportSuccess());
                throw new SMTPSendFailedException("MAIL TO", 0, "Invalid Address", failures, sent, unsent, invalid);
            }
            this.notifyTransportListeners(1, sent, unsent, invalid, message);
            if (this.reportSuccess && (successes = this.generateExceptionChain(stats, this.reportSuccess)) != null) {
                throw successes;
            }
        }
        catch (SMTPSendFailedException e) {
            throw e;
        }
        catch (MessagingException e) {
            this.notifyTransportListeners(2, sent, unsent, invalid, message);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MessagingException {
        if (this.socket == null) {
            return;
        }
        try {
            this.sendQuit();
        }
        finally {
            this.closeServerConnection();
        }
    }

    protected MessagingException generateExceptionChain(SendStatus[] stats, boolean reportSuccess) {
        MessagingException current = null;
        for (int i = 0; i < stats.length; ++i) {
            MessagingException nextException;
            SendStatus status = stats[i];
            if (status == null || (nextException = stats[i].getException(reportSuccess)) == null) continue;
            if (current == null) {
                current = nextException;
                continue;
            }
            current.setNextException(nextException);
            current = nextException;
        }
        return current;
    }

    protected void resetConnection() throws MessagingException {
        SMTPReply last = this.lastServerResponse;
        SMTPReply line = this.sendCommand("RSET");
        if (line.getCode() != 250) {
            this.close();
        }
        this.lastServerResponse = last;
    }

    protected Address[] expandGroups(Address[] addresses) throws MessagingException {
        ArrayList<InternetAddress> expandedAddresses = new ArrayList<InternetAddress>();
        for (int i = 0; i < addresses.length; ++i) {
            InternetAddress address = (InternetAddress)addresses[i];
            if (!address.isGroup()) {
                expandedAddresses.add(address);
                continue;
            }
            InternetAddress[] groupAddresses = address.getGroup(true);
            for (int j = 1; j < groupAddresses.length; ++j) {
                expandedAddresses.add(groupAddresses[j]);
            }
        }
        return expandedAddresses.toArray(new Address[0]);
    }

    protected void getConnection(String host, int port, String username, String password) throws IOException {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.useTLS = this.isProtocolPropertyTrue("starttls.enable");
        this.serverAuthenticationMechanisms = new HashMap();
        if (this.socket == null) {
            if (this.sslConnection) {
                this.getConnectedSSLSocket();
            } else {
                this.getConnectedSocket();
            }
        } else {
            port = this.socket.getPort();
            host = this.socket.getInetAddress().getHostName();
        }
        this.inputStream = new TraceInputStream(this.socket.getInputStream(), this.debugStream, this.debug, this.isProtocolPropertyTrue(MAIL_SMTP_ENCODE_TRACE));
        this.outputStream = new TraceOutputStream(this.socket.getOutputStream(), this.debugStream, this.debug, this.isProtocolPropertyTrue(MAIL_SMTP_ENCODE_TRACE));
    }

    protected String getProtocolProperty(String name) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.getSessionProperty(fullName);
    }

    protected String getSessionProperty(String name) {
        return this.session.getProperty(name);
    }

    protected String getSessionProperty(String name, String defaultValue) {
        String result = this.session.getProperty(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    protected String getProtocolProperty(String name, String defaultValue) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.getSessionProperty(fullName, defaultValue);
    }

    protected int getIntSessionProperty(String name, int defaultValue) {
        String result = this.getSessionProperty(name);
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected int getIntProtocolProperty(String name, int defaultValue) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.getIntSessionProperty(fullName, defaultValue);
    }

    protected boolean isProtocolPropertyTrue(String name) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.isSessionPropertyTrue(fullName);
    }

    protected boolean isSessionPropertyTrue(String name) {
        String property = this.session.getProperty(name);
        if (property != null) {
            return property.equals("true");
        }
        return false;
    }

    protected boolean isSessionPropertyFalse(String name) {
        String property = this.session.getProperty(name);
        if (property != null) {
            return property.equals("false");
        }
        return false;
    }

    protected boolean isProtocolPropertyFalse(String name) {
        String fullName = "mail." + this.protocol + "." + name;
        return this.isSessionPropertyTrue(fullName);
    }

    protected void closeServerConnection() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    protected void getConnectedSocket() throws IOException {
        if (this.debug) {
            this.debugOut("Attempting plain socket connection to server " + this.host + ":" + this.port);
        }
        String socketFactory = this.getProtocolProperty(MAIL_SMTP_FACTORY_CLASS);
        int timeout = this.getIntProtocolProperty(MAIL_SMTP_TIMEOUT, -1);
        InetAddress localAddress = null;
        String localAddrProp = this.getProtocolProperty(MAIL_SMTP_LOCALADDRESS);
        if (localAddrProp != null) {
            localAddress = InetAddress.getByName(localAddrProp);
        }
        int localPort = this.getIntProtocolProperty(MAIL_SMTP_LOCALPORT, 0);
        this.socket = null;
        if (socketFactory == null) {
            this.socket = new Socket(this.host, this.port, localAddress, localPort);
        } else {
            try {
                int socketFactoryPort = this.getIntProtocolProperty(MAIL_SMTP_FACTORY_PORT, -1);
                Integer portArg = new Integer(socketFactoryPort == -1 ? this.port : socketFactoryPort);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = loader.loadClass(socketFactory);
                Method getDefault = factoryClass.getMethod("getDefault", new Class[0]);
                Object defFactory = getDefault.invoke(new Object(), new Object[0]);
                if (localAddress != null) {
                    Class[] createSocketSig = new Class[]{String.class, Integer.TYPE, InetAddress.class, Integer.TYPE};
                    Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                    Object[] createSocketArgs = new Object[]{this.host, portArg, localAddress, new Integer(localPort)};
                    this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                } else {
                    Class[] createSocketSig = new Class[]{String.class, Integer.TYPE};
                    Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                    Object[] createSocketArgs = new Object[]{this.host, portArg};
                    this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                }
            }
            catch (Throwable e) {
                if (this.isProtocolPropertyTrue(MAIL_SMTP_FACTORY_FALLBACK)) {
                    if (this.debug) {
                        this.debugOut("First plain socket attempt faile, falling back to default factory", e);
                    }
                    this.socket = new Socket(this.host, this.port, localAddress, localPort);
                }
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                if (this.debug) {
                    this.debugOut("Plain socket creation failure", e);
                }
                IOException ioe = new IOException("Error connecting to " + this.host + ", " + this.port);
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (timeout >= 0) {
            this.socket.setSoTimeout(timeout);
        }
    }

    protected void getConnectedSSLSocket() throws IOException {
        if (this.debug) {
            this.debugOut("Attempting SSL socket connection to server " + this.host + ":" + this.port);
        }
        String socketFactory = this.getProtocolProperty(MAIL_SMTP_FACTORY_CLASS, this.getSessionProperty(MAIL_SSLFACTORY_CLASS, "javax.net.ssl.SSLSocketFactory"));
        int timeout = this.getIntProtocolProperty(MAIL_SMTP_TIMEOUT, -1);
        InetAddress localAddress = null;
        String localAddrProp = this.getProtocolProperty(MAIL_SMTP_LOCALADDRESS);
        if (localAddrProp != null) {
            localAddress = InetAddress.getByName(localAddrProp);
        }
        int localPort = this.getIntProtocolProperty(MAIL_SMTP_LOCALPORT, 0);
        this.socket = null;
        if (socketFactory == null) {
            this.socket = new Socket(this.host, this.port, localAddress, localPort);
        } else {
            boolean fallback = this.isProtocolPropertyTrue(MAIL_SMTP_FACTORY_FALLBACK);
            while (true) {
                try {
                    int socketFactoryPort;
                    if (this.debug) {
                        this.debugOut("Creating SSL socket using factory " + socketFactory);
                    }
                    Integer portArg = new Integer((socketFactoryPort = this.getIntProtocolProperty(MAIL_SMTP_FACTORY_PORT, -1)) == -1 ? this.port : socketFactoryPort);
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> factoryClass = loader.loadClass(socketFactory);
                    Method getDefault = factoryClass.getMethod("getDefault", new Class[0]);
                    Object defFactory = getDefault.invoke(new Object(), new Object[0]);
                    if (localAddress != null) {
                        Class[] createSocketSig = new Class[]{String.class, Integer.TYPE, InetAddress.class, Integer.TYPE};
                        Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                        Object[] createSocketArgs = new Object[]{this.host, portArg, localAddress, new Integer(localPort)};
                        this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                        break;
                    }
                    Class[] createSocketSig = new Class[]{String.class, Integer.TYPE};
                    Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
                    Object[] createSocketArgs = new Object[]{this.host, portArg};
                    this.socket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
                }
                catch (Throwable e) {
                    if (fallback) {
                        if (this.debug) {
                            this.debugOut("First attempt at creating SSL socket failed, falling back to default factory");
                        }
                        socketFactory = "javax.net.ssl.SSLSocketFactory";
                        fallback = false;
                        continue;
                    }
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    if (this.debug) {
                        this.debugOut("Failure creating SSL socket", e);
                    }
                    IOException ioe = new IOException("Error connecting to " + this.host + ", " + this.port);
                    ioe.initCause(e);
                    throw ioe;
                }
                break;
            }
        }
        if (timeout >= 0) {
            this.socket.setSoTimeout(timeout);
        }
    }

    protected void getConnectedTLSSocket() throws MessagingException {
        SMTPReply line;
        if (this.debug) {
            this.debugOut("Attempting to negotiate STARTTLS with server " + this.host);
        }
        if ((line = this.sendCommand("STARTTLS")).getCode() != 220) {
            if (this.debug) {
                this.debugOut("STARTTLS command rejected by SMTP server " + this.host);
            }
            throw new MessagingException("Unable to make TLS server connection");
        }
        try {
            String host = this.socket.getInetAddress().getHostName();
            int port = this.socket.getPort();
            String socketFactory = this.getProtocolProperty(MAIL_SMTP_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> factoryClass = loader.loadClass(socketFactory);
            Method getDefault = factoryClass.getMethod("getDefault", new Class[0]);
            Object defFactory = getDefault.invoke(new Object(), new Object[0]);
            Class[] createSocketSig = new Class[]{Socket.class, String.class, Integer.TYPE, Boolean.TYPE};
            Method createSocket = factoryClass.getMethod("createSocket", createSocketSig);
            Object[] createSocketArgs = new Object[]{this.socket, host, new Integer(port), Boolean.TRUE};
            Socket sslSocket = (Socket)createSocket.invoke(defFactory, createSocketArgs);
            if (sslSocket instanceof SSLSocket) {
                ((SSLSocket)sslSocket).setEnabledProtocols(new String[]{"TLSv1"});
                ((SSLSocket)sslSocket).setUseClientMode(true);
                ((SSLSocket)sslSocket).startHandshake();
            }
            this.inputStream = new TraceInputStream(sslSocket.getInputStream(), this.debugStream, this.debug, this.isProtocolPropertyTrue(MAIL_SMTP_ENCODE_TRACE));
            this.outputStream = new TraceOutputStream(sslSocket.getOutputStream(), this.debugStream, this.debug, this.isProtocolPropertyTrue(MAIL_SMTP_ENCODE_TRACE));
            this.socket = sslSocket;
        }
        catch (Exception e) {
            if (this.debug) {
                this.debugOut("Failure attempting to convert connection to TLS", e);
            }
            throw new MessagingException("Unable to convert connection to SSL", e);
        }
    }

    protected boolean getWelcome() throws MessagingException {
        SMTPReply line = this.getReply();
        return !line.isError();
    }

    protected void sendData(Message msg) throws MessagingException {
        SMTPReply line = this.sendCommand("DATA");
        if (line.isError()) {
            throw new MessagingException("Error issuing SMTP 'DATA' command: " + line);
        }
        try {
            MIMEOutputStream mimeOut = new MIMEOutputStream(this.outputStream);
            msg.writeTo(mimeOut);
            mimeOut.flush();
        }
        catch (IOException e) {
            throw new MessagingException(e.toString());
        }
        catch (MessagingException e) {
            throw new MessagingException(e.toString());
        }
        this.sendLine("");
        this.sendLine(".");
        try {
            line = new SMTPReply(this.receiveLine(600000));
        }
        catch (MalformedSMTPReplyException e) {
            throw new MessagingException(e.toString());
        }
        catch (MessagingException e) {
            throw new MessagingException(e.toString());
        }
        if (line.isError()) {
            throw new MessagingException("Error issuing SMTP 'DATA' command: " + line);
        }
    }

    protected void sendQuit() throws MessagingException {
        if (this.isProtocolPropertyTrue(MAIL_SMTP_QUITWAIT)) {
            this.sendCommand("QUIT");
        } else {
            this.sendLine("QUIT");
        }
    }

    protected SendStatus sendRcptTo(InternetAddress addr, String dsn) throws MessagingException {
        StringBuffer command = new StringBuffer();
        command.append("RCPT TO: ");
        command.append(this.fixEmailAddress(addr.getAddress()));
        if (dsn != null) {
            command.append(" NOTIFY=");
            command.append(dsn);
        }
        String commandString = command.toString();
        SMTPReply line = this.sendCommand(commandString);
        switch (line.getCode()) {
            case 250: 
            case 251: {
                return new SendStatus(0, addr, commandString, line);
            }
            case 501: 
            case 503: 
            case 550: 
            case 551: 
            case 553: {
                return new SendStatus(1, addr, commandString, line);
            }
            case 421: 
            case 450: 
            case 451: 
            case 452: 
            case 552: {
                return new SendStatus(2, addr, commandString, line);
            }
        }
        return new SendStatus(3, addr, commandString, line);
    }

    protected boolean sendMailFrom(Message message) throws MessagingException {
        SMTPReply line;
        String from = null;
        if (message instanceof SMTPMessage) {
            from = ((SMTPMessage)message).getEnvelopeFrom();
        }
        if (from == null || from.length() == 0) {
            from = this.getProtocolProperty(MAIL_SMTP_FROM);
        }
        if (from == null || from.length() == 0) {
            Address[] fromAddresses = message.getFrom();
            if (fromAddresses != null && fromAddresses.length > 0) {
                from = ((InternetAddress)fromAddresses[0]).getAddress();
            } else {
                InternetAddress local = InternetAddress.getLocalAddress(this.session);
                if (local != null) {
                    from = local.getAddress();
                }
            }
        }
        if (from == null || from.length() == 0) {
            throw new MessagingException("no FROM address");
        }
        StringBuffer command = new StringBuffer();
        command.append("MAIL FROM: ");
        command.append(this.fixEmailAddress(from));
        if (this.supportsExtension("DSN")) {
            String returnNotification = null;
            if (message instanceof SMTPMessage) {
                switch (((SMTPMessage)message).getReturnOption()) {
                    case 1: {
                        returnNotification = "FULL";
                        break;
                    }
                    case 2: {
                        returnNotification = "HDRS";
                    }
                }
            }
            if (returnNotification == null) {
                returnNotification = this.getProtocolProperty(MAIL_SMTP_DSN_RET);
            }
            if (returnNotification != null) {
                command.append(" RET=");
                command.append(returnNotification);
            }
        }
        if (this.supportsExtension("AUTH")) {
            String submitter = null;
            if (message instanceof SMTPMessage) {
                submitter = ((SMTPMessage)message).getSubmitter();
            }
            if (submitter == null) {
                submitter = this.getProtocolProperty(MAIL_SMTP_SUBMITTER);
            }
            if (submitter != null) {
                command.append(" AUTH=");
                try {
                    command.append(new String(XText.encode(submitter.getBytes("US-ASCII"))));
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessagingException("Invalid submitter value " + submitter);
                }
            }
        }
        String extension = null;
        if (message instanceof SMTPMessage) {
            extension = ((SMTPMessage)message).getMailExtension();
        }
        if (extension == null) {
            extension = this.getProtocolProperty(MAIL_SMTP_EXTENSION);
        }
        if (extension != null && extension.length() != 0) {
            command.append(' ');
            command.append(extension);
        }
        return (line = this.sendCommand(command.toString())).getCode() == 250;
    }

    protected SMTPReply sendCommand(String data) throws MessagingException {
        this.sendLine(data);
        return this.getReply();
    }

    protected void sendLine(String data) throws MessagingException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new MessagingException("no connection");
        }
        try {
            System.out.println(">>>>>Sending data " + data + "<<<<<<");
            this.outputStream.write(data.getBytes());
            this.outputStream.write(13);
            this.outputStream.write(10);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new MessagingException(e.toString());
        }
    }

    protected String receiveLine() throws MessagingException {
        return this.receiveLine(300000);
    }

    protected SMTPReply getReply() throws MessagingException {
        try {
            this.lastServerResponse = new SMTPReply(this.receiveLine());
        }
        catch (MalformedSMTPReplyException e) {
            throw new MessagingException(e.toString());
        }
        catch (MessagingException e) {
            throw e;
        }
        return this.lastServerResponse;
    }

    public String getLastServerResponse() {
        if (this.lastServerResponse == null) {
            return "";
        }
        return this.lastServerResponse.getReply();
    }

    protected String receiveLine(int delayMillis) throws MessagingException {
        if (this.socket == null || !this.socket.isConnected()) {
            throw new MessagingException("no connection");
        }
        int timeout = 0;
        try {
            String line;
            int c;
            timeout = this.socket.getSoTimeout();
            this.socket.setSoTimeout(delayMillis);
            StringBuffer buff = new StringBuffer();
            boolean crFound = false;
            boolean lfFound = false;
            while ((c = this.inputStream.read()) != -1 && !crFound && !lfFound) {
                if (c == 13) {
                    crFound = true;
                    continue;
                }
                if (c == 10) {
                    lfFound = true;
                    continue;
                }
                buff.append((char)c);
            }
            String string = line = buff.toString();
            return string;
        }
        catch (SocketException e) {
            throw new MessagingException(e.toString());
        }
        catch (IOException e) {
            throw new MessagingException(e.toString());
        }
        finally {
            try {
                this.socket.setSoTimeout(timeout);
            }
            catch (SocketException e) {}
        }
    }

    protected String fixEmailAddress(String mail) {
        if (mail.charAt(0) == '<') {
            return mail;
        }
        return "<" + mail + ">";
    }

    protected boolean sendHandshake() throws MessagingException {
        boolean useEhlo;
        boolean bl = useEhlo = !this.isProtocolPropertyFalse(MAIL_SMTP_EHLO);
        if (useEhlo) {
            if (!this.sendEhlo()) {
                this.sendHelo();
            }
        } else {
            this.sendHelo();
        }
        if (this.useTLS) {
            if (!this.serverTLS) {
                throw new MessagingException("Server doesn't support required transport level security");
            }
            this.getConnectedTLSSocket();
            this.serverAuthenticationMechanisms.clear();
            if (!this.sendEhlo()) {
                throw new MessagingException("Failure sending EHLO command to SMTP server");
            }
        }
        return true;
    }

    protected boolean sendEhlo() throws MessagingException {
        this.sendLine("EHLO " + this.getLocalHost());
        SMTPReply line = this.getReply();
        if (line.getCode() != 250) {
            return false;
        }
        this.serverExtensionArgs = new HashMap();
        while (line.isContinued()) {
            line = this.getReply();
            if (line.getCode() != 250) {
                return false;
            }
            this.processExtension(line.getMessage());
        }
        return true;
    }

    protected void sendHelo() throws MessagingException {
        this.sendLine("HELO " + this.getLocalHost());
        SMTPReply line = this.getReply();
        if (line.getCode() != 250) {
            throw new MessagingException("Failure sending HELO command to SMTP server");
        }
    }

    public String getLocalHost() throws MessagingException {
        if (this.localHost == null) {
            try {
                this.localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (this.localHost == null) {
                this.localHost = this.getProtocolProperty("localhost");
            }
            if (this.localHost == null) {
                this.localHost = this.getSessionProperty(MAIL_LOCALHOST);
            }
            if (this.localHost == null) {
                throw new MessagingException("Can't get local hostname.  Please correctly configure JDK/DNS or set mail.smtp.localhost");
            }
        }
        return this.localHost;
    }

    public boolean getReportSuccess() {
        return this.reportSuccess;
    }

    public void setReportSuccess(boolean report) {
        this.reportSuccess = report;
    }

    public boolean getStartTLS() {
        return this.reportSuccess;
    }

    public void setStartTLS(boolean start) {
        this.useTLS = start;
    }

    public String getSASLRealm() {
        if (this.realm == null) {
            this.realm = this.getProtocolProperty(MAIL_SMTP_SASL_REALM);
        }
        return this.realm;
    }

    public void setSASLRealm(String name) {
        this.realm = name;
    }

    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }

    protected void processExtension(String extension) {
        String extensionName = extension.toUpperCase();
        String argument = "";
        int delimiter = extension.indexOf(32);
        if (delimiter != -1) {
            extensionName = extension.substring(0, delimiter).toUpperCase();
            argument = extension.substring(delimiter + 1);
        }
        this.serverExtensionArgs.put(extensionName, argument);
        if (extensionName.equals("AUTH")) {
            if (argument == null) {
                this.serverAuthenticationMechanisms.put(AUTHENTICATION_LOGIN, AUTHENTICATION_LOGIN);
            } else {
                StringTokenizer tokenizer = new StringTokenizer(argument);
                while (tokenizer.hasMoreTokens()) {
                    String mechanism = tokenizer.nextToken().toUpperCase();
                    this.serverAuthenticationMechanisms.put(mechanism, mechanism);
                }
            }
        } else if (extensionName.equals("AUTH=LOGIN")) {
            this.serverAuthenticationMechanisms.put(AUTHENTICATION_LOGIN, AUTHENTICATION_LOGIN);
        } else if (extensionName.equals("STARTTLS")) {
            this.serverTLS = true;
        }
    }

    public String extensionParameter(String name) {
        if (this.serverExtensionArgs != null) {
            return (String)this.serverExtensionArgs.get(name);
        }
        return null;
    }

    public boolean supportsExtension(String name) {
        return this.extensionParameter(name) != null;
    }

    protected boolean supportsAuthentication(String mechanism) {
        return this.serverAuthenticationMechanisms.get(mechanism) != null;
    }

    protected boolean processAuthentication() throws MessagingException {
        SMTPReply line;
        StringBuffer command;
        if (!this.isProtocolPropertyTrue(MAIL_SMTP_AUTH)) {
            return true;
        }
        if (this.username == null || this.password == null) {
            return false;
        }
        ClientAuthenticator authenticator = null;
        if (this.supportsAuthentication(AUTHENTICATION_DIGESTMD5)) {
            authenticator = new DigestMD5Authenticator(this.host, this.username, this.password, this.getSASLRealm());
        } else if (this.supportsAuthentication(AUTHENTICATION_CRAMMD5)) {
            authenticator = new CramMD5Authenticator(this.username, this.password);
        } else if (this.supportsAuthentication(AUTHENTICATION_LOGIN)) {
            authenticator = new LoginAuthenticator(this.username, this.password);
        } else if (this.supportsAuthentication(AUTHENTICATION_PLAIN)) {
            authenticator = new PlainAuthenticator(this.username, this.password);
        } else {
            return false;
        }
        if (this.debug) {
            this.debugOut("Authenticating for user: " + this.username + " using " + authenticator.getMechanismName());
        }
        if (authenticator.hasInitialResponse()) {
            command = new StringBuffer();
            command.append("AUTH ");
            command.append(authenticator.getMechanismName());
            command.append(" ");
            command.append(new String(Base64.encode(authenticator.evaluateChallenge(null))));
            this.sendLine(command.toString());
        } else {
            command = new StringBuffer();
            command.append("AUTH ");
            command.append(authenticator.getMechanismName());
            this.sendLine(command.toString());
        }
        while (true) {
            try {
                line = new SMTPReply(this.receiveLine());
            }
            catch (MalformedSMTPReplyException e) {
                throw new MessagingException(e.toString());
            }
            catch (MessagingException e) {
                throw e;
            }
            if (line.getCode() == 235) {
                if (this.debug) {
                    this.debugOut("Successful SMTP authentication");
                }
                return true;
            }
            if (line.getCode() != 334) break;
            if (authenticator.isComplete()) {
                return false;
            }
            byte[] challenge = Base64.decode(line.getMessage().getBytes());
            this.sendLine(new String(Base64.encode(authenticator.evaluateChallenge(challenge))));
        }
        if (this.debug) {
            this.debugOut("Authentication failure " + line);
        }
        return false;
    }

    protected void debugOut(String message) {
        this.debugStream.println("SMTPTransport DEBUG: " + message);
    }

    protected void debugOut(String message, Throwable e) {
        this.debugOut("Received exception -> " + message);
        this.debugOut("Exception message -> " + e.getMessage());
        e.printStackTrace(this.debugStream);
    }

    public class SendStatus {
        public static final int SUCCESS = 0;
        public static final int INVALID_ADDRESS = 1;
        public static final int SEND_FAILURE = 2;
        public static final int GENERAL_ERROR = 3;
        int status;
        InternetAddress address;
        String cmd;
        SMTPReply reply;

        public SendStatus(int s, InternetAddress a, String c, SMTPReply r) {
            this.cmd = c;
            this.status = s;
            this.address = a;
            this.reply = r;
        }

        public int getStatus() {
            return this.status;
        }

        public InternetAddress getAddress() {
            return this.address;
        }

        public SMTPReply getReply() {
            return this.reply;
        }

        public String getCommand() {
            return this.cmd;
        }

        public MessagingException getException(boolean reportSuccess) {
            if (this.status != 0) {
                return new SMTPAddressFailedException(this.address, this.cmd, this.reply.getCode(), this.reply.getMessage());
            }
            if (reportSuccess) {
                return new SMTPAddressSucceededException(this.address, this.cmd, this.reply.getCode(), this.reply.getMessage());
            }
            return null;
        }
    }
}

