/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group.config;

import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.config.IConfiguration;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.action.ColumnGroupExpandCollapseAction;
import net.sourceforge.nattable.group.action.ColumnGroupHeaderReorderDragMode;
import net.sourceforge.nattable.group.action.ColumnHeaderReorderDragMode;
import net.sourceforge.nattable.group.action.CreateColumnGroupAction;
import net.sourceforge.nattable.group.action.UngroupColumnsAction;
import net.sourceforge.nattable.group.painter.ColumnGroupHeaderTextPainter;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.painter.cell.decorator.BeveledBorderDecorator;
import net.sourceforge.nattable.ui.binding.UiBindingRegistry;
import net.sourceforge.nattable.ui.matcher.KeyEventMatcher;
import net.sourceforge.nattable.ui.matcher.MouseEventMatcher;

public class DefaultColumnGroupHeaderLayerConfiguration
implements IConfiguration {
    private final ColumnGroupModel columnGroupModel;

    public DefaultColumnGroupHeaderLayerConfiguration(ColumnGroupModel columnGroupModel) {
        this.columnGroupModel = columnGroupModel;
    }

    public void configureLayer(ILayer layer) {
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, new BeveledBorderDecorator(new ColumnGroupHeaderTextPainter(this.columnGroupModel)), "NORMAL", "COLUMN_GROUP_HEADER");
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.columnGroupHeaderLeftClick(0), new ColumnGroupHeaderReorderDragMode(this.columnGroupModel));
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.columnHeaderLeftClick(0), new ColumnHeaderReorderDragMode(this.columnGroupModel));
        uiBindingRegistry.registerDoubleClickBinding(MouseEventMatcher.columnGroupHeaderLeftClick(0), new ColumnGroupExpandCollapseAction());
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(262144, 103), new CreateColumnGroupAction());
        uiBindingRegistry.registerKeyBinding(new KeyEventMatcher(262144, 117), new UngroupColumnsAction());
    }
}

