/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.xpath;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathCreator {
    private static final String TEXT_NODE_NAME = "#text";
    private static final String TEXT_NODE = "text()";
    private static final String RIGHT_BRACKET = "]";
    private static final String LEFT_BRACKET = "[";
    private static final String SLASH = "/";

    public static String childPathSequence(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        Document document = null;
        if (node != null) {
            document = node.getOwnerDocument();
        }
        while (node != null && node != document) {
            String string = node.getNodeName();
            int n = XPathCreator.countSiblingByName(node, string);
            if (TEXT_NODE_NAME.equalsIgnoreCase(string)) {
                string = TEXT_NODE;
            }
            if (n > 0) {
                stringBuffer.insert(0, SLASH + string + LEFT_BRACKET + ++n + RIGHT_BRACKET);
            } else {
                stringBuffer.insert(0, SLASH + string);
            }
            node = node.getParentNode();
        }
        return stringBuffer.toString();
    }

    private static int countSiblingByName(Node node, String string) {
        int n = 0;
        if (node != null) {
            node = node.getPreviousSibling();
        }
        while (node != null) {
            if (node.getNodeName().equals(string)) {
                ++n;
            }
            node = node.getPreviousSibling();
        }
        return n;
    }
}

