/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import org.eclipse.actf.util.httpproxy.core.IClientConnection;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMalformedResponseMessage;

public class Session {
    static final Logger LOGGER = Logger.getLogger(Session.class);
    private IHTTPRequestMessage fRequestMsg = null;
    private IHTTPResponseMessage fResponseMsg = null;

    public synchronized IHTTPRequestMessage getRequestMessage() {
        return this.fRequestMsg;
    }

    public synchronized void start(IHTTPRequestMessage iHTTPRequestMessage) throws InterruptedException {
        if (iHTTPRequestMessage == this.fRequestMsg) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("A session started: stat=" + this.fRequestMsg + ", req=" + iHTTPRequestMessage);
        }
        while (this.fRequestMsg != null) {
            this.wait();
        }
        this.fRequestMsg = iHTTPRequestMessage;
        this.notifyAll();
    }

    public synchronized void start(IHTTPRequestMessage iHTTPRequestMessage, long l) throws InterruptedException, TimeoutException {
        if (iHTTPRequestMessage == this.fRequestMsg) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("A session started: stat=" + this.fRequestMsg + ", req=" + iHTTPRequestMessage);
        }
        if (this.fRequestMsg != null) {
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (l3 > 0L) {
                this.wait(l3);
                if (this.fResponseMsg == null) break;
                l3 = l2 - System.currentTimeMillis();
            }
            if (this.fRequestMsg == null) {
                throw new TimeoutException("Session.start");
            }
        }
        this.fRequestMsg = iHTTPRequestMessage;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean receiveResponse(IHTTPResponseMessage var1_1) throws InterruptedException {
        if (this.fRequestMsg == null || this.fRequestMsg.getSerial() == var1_1.getSerial()) ** GOTO lbl4
        return false;
lbl-1000:
        // 1 sources

        {
            this.wait();
lbl4:
            // 2 sources

            ** while (this.fResponseMsg != null)
        }
lbl5:
        // 1 sources

        this.fResponseMsg = var1_1;
        this.notifyAll();
        return true;
    }

    protected synchronized IHTTPResponseMessage waitResponse(long l) throws InterruptedException, TimeoutException {
        if (this.fResponseMsg == null) {
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (l3 > 0L) {
                this.wait(l3);
                if (this.fResponseMsg != null) break;
                l3 = l2 - System.currentTimeMillis();
            }
            if (this.fResponseMsg == null) {
                throw new TimeoutException("ResponseSync.get");
            }
        }
        IHTTPResponseMessage iHTTPResponseMessage = this.fResponseMsg;
        this.fResponseMsg = null;
        return iHTTPResponseMessage;
    }

    protected synchronized void notifyCompletion() {
        this.fRequestMsg = null;
        this.notifyAll();
    }

    public synchronized IHTTPResponseMessage getAndSendResponse(IClientConnection iClientConnection, long l) throws InterruptedException, TimeoutException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getAndSendResponse: entrered");
        }
        long l2 = System.currentTimeMillis();
        IHTTPResponseMessage iHTTPResponseMessage = this.waitResponse(l);
        if (iHTTPResponseMessage instanceof HTTPMalformedResponseMessage) {
            throw ((HTTPMalformedResponseMessage)iHTTPResponseMessage).getIOException();
        }
        long l3 = System.currentTimeMillis();
        if ((l -= l3 - l2) <= 0L) {
            l = 1L;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getAndSendResponse: got a response");
        }
        try {
            iClientConnection.sendResponse(l, iHTTPResponseMessage);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("getAndSendResponse: sent a response");
            }
        }
        catch (IOException iOException) {
            return iHTTPResponseMessage;
        }
        catch (TimeoutException timeoutException) {
            return iHTTPResponseMessage;
        }
        this.notifyCompletion();
        return null;
    }

    public synchronized IHTTPResponseMessage getResponse(long l) throws InterruptedException, TimeoutException, IOException {
        IHTTPResponseMessage iHTTPResponseMessage = this.waitResponse(l);
        this.notifyCompletion();
        if (iHTTPResponseMessage instanceof HTTPMalformedResponseMessage) {
            throw ((HTTPMalformedResponseMessage)iHTTPResponseMessage).getIOException();
        }
        return iHTTPResponseMessage;
    }
}

