/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorSRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorXYZ;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYXY;

public class ColorIRGB {
    int R;
    int G;
    int B;

    public ColorIRGB() {
    }

    public ColorIRGB(int n) {
        this.R = n >> 16 & 0xFF;
        this.G = n >> 8 & 0xFF;
        this.B = n & 0xFF;
    }

    public ColorIRGB(int n, int n2, int n3) throws ColorException {
        this.setR(n);
        this.setG(n2);
        this.setB(n3);
    }

    public ColorIRGB(int n, int n2, int n3, boolean bl) throws ColorException {
        this.setR(n, bl);
        this.setG(n2, bl);
        this.setB(n3, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ColorIRGB(String string) throws ColorException {
        Pattern pattern = Pattern.compile("^\\s*(\\S.+\\S)\\s*$");
        Matcher matcher = pattern.matcher(string.toLowerCase());
        if (!matcher.find()) {
            throw new ColorException("There no color spacifications. Input string is \"" + string + "\"");
        }
        String string2 = matcher.group(1);
        String string3 = ColorUtil.predefinedColor2Pound(string2);
        if (string3 != null) {
            string2 = string3;
        }
        if (string2.startsWith("#")) {
            if ((string2 = string2.substring(1)).length() == 6) {
                String string4 = string2.substring(0, 2);
                String string5 = string2.substring(2, 4);
                String string6 = string2.substring(4);
                try {
                    this.R = Integer.parseInt(string4, 16);
                    this.G = Integer.parseInt(string5, 16);
                    this.B = Integer.parseInt(string6, 16);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new ColorException("Bad color specification(1): #" + string2);
                }
            } else {
                if (string2.length() != 3) throw new ColorException("Bad color specification(3): #" + string2);
                String string7 = string2.substring(0, 1);
                String string8 = string2.substring(1, 2);
                String string9 = string2.substring(2);
                try {
                    this.R = Integer.parseInt(String.valueOf(string7) + string7, 16);
                    this.G = Integer.parseInt(String.valueOf(string8) + string8, 16);
                    this.B = Integer.parseInt(String.valueOf(string9) + string9, 16);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new ColorException("Bad color specification(2): #" + string2);
                }
            }
        } else if (string2.startsWith("rgb(") && string2.endsWith(")")) {
            string2 = string2.substring(4);
            if ((string2 = string2.substring(0, string2.length() - 1)).indexOf("%") == -1) {
                Pattern pattern2 = Pattern.compile("^\\s*([\\+\\-]?\\d+)\\s*\\,\\s*([\\+\\-]?\\d+)\\s*\\,\\s*([\\+\\-]?\\d+)\\s*$");
                Matcher matcher2 = pattern2.matcher(string2);
                if (!matcher2.find()) {
                    throw new ColorException("Bad color specification(4): rgb(" + string2 + ")");
                }
                try {
                    this.setR(Integer.parseInt(matcher2.group(1)), false);
                    this.setG(Integer.parseInt(matcher2.group(2)), false);
                    this.setB(Integer.parseInt(matcher2.group(3)), false);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    throw new ColorException("Bad color specification(5): rgb(" + string2 + ")");
                }
            } else {
                Pattern pattern3 = Pattern.compile("^\\s*([\\+\\-]?\\d+(\\.\\d+)*)\\%\\s*\\,\\s*([\\+\\-]?\\d+(\\.\\d+)*)\\%\\s*\\,\\s*([\\+\\-]?\\d+(\\.\\d+)*)\\%\\s*$");
                Matcher matcher3 = pattern3.matcher(string2);
                if (!matcher3.find()) {
                    throw new ColorException("Bad color specification(6): rgb(" + string2 + ")");
                }
                try {
                    this.setR((int)(Float.parseFloat(matcher3.group(1)) / 100.0f * 255.0f), false);
                    this.setG((int)(Float.parseFloat(matcher3.group(3)) / 100.0f * 255.0f), false);
                    this.setB((int)(Float.parseFloat(matcher3.group(5)) / 100.0f * 255.0f), false);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new ColorException("Bad color specification(7): rgb(" + string2 + ")");
                }
            }
        } else {
            if (!string2.equals("transparent")) throw new ColorException("Unknown color specification: " + string2);
            this.R = 255;
            this.G = 255;
            this.B = 255;
        }
    }

    public int getR() {
        return this.R;
    }

    public int getG() {
        return this.G;
    }

    public int getB() {
        return this.B;
    }

    public void setR(int n) throws ColorException {
        this.setR(n, false);
    }

    public void setR(int n, boolean bl) throws ColorException {
        if (n < 0) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.R = 0;
        } else if (255 < n) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.R = 255;
        } else {
            this.R = n;
        }
    }

    public void setG(int n) throws ColorException {
        this.setG(n, false);
    }

    public void setG(int n, boolean bl) throws ColorException {
        if (n < 0) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.G = 0;
        } else if (255 < n) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.G = 255;
        } else {
            this.G = n;
        }
    }

    public void setB(int n) throws ColorException {
        this.setB(n, false);
    }

    public void setB(int n, boolean bl) throws ColorException {
        if (n < 0) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.B = 0;
        } else if (255 < n) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.B = 255;
        } else {
            this.B = n;
        }
    }

    public boolean equals(ColorIRGB colorIRGB) throws ColorException {
        if (colorIRGB == null) {
            throw new ColorException("The parameter is null.");
        }
        return colorIRGB.getR() == this.R && colorIRGB.getG() == this.G && colorIRGB.getB() == this.B;
    }

    public boolean equals(int n) {
        return this.toInt() == n;
    }

    public ColorSRGB toSRGB() throws ColorException {
        return this.toSRGB(false);
    }

    public ColorSRGB toSRGB(boolean bl) throws ColorException {
        ColorSRGB colorSRGB = new ColorSRGB((float)this.R / 255.0f, (float)this.G / 255.0f, (float)this.B / 255.0f, bl);
        return colorSRGB;
    }

    public ColorXYZ toXYZ() throws ColorException {
        return this.toXYZ(false);
    }

    public ColorXYZ toXYZ(boolean bl) throws ColorException {
        return this.toSRGB(bl).toXYZ(bl);
    }

    public ColorYXY toYXY() throws ColorException {
        return this.toYXY(false);
    }

    public ColorYXY toYXY(boolean bl) throws ColorException {
        return this.toSRGB(bl).toXYZ(bl).toYXY(bl);
    }

    public int toInt() {
        return (this.R & 0xFF) << 16 | (this.G & 0xFF) << 8 | this.B & 0xFF;
    }

    public void dump(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.dump(printWriter);
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("-------");
        printWriter.println("dumping color values");
        printWriter.println("R= " + this.R + ", G= " + this.G + ", B= " + this.B);
        printWriter.println("-------");
    }
}

