/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.script.IDataRow;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class DataRow
implements IDataRow {
    protected DataSetRuntime dataSet;
    protected IResultMetaData metaData;

    public DataRow(DataSetRuntime dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public IDataSetInstanceHandle getDataSet() {
        return this.dataSet;
    }

    @Override
    public IResultMetaData getResultMetaData() throws BirtException {
        IResultObject obj;
        if (this.metaData == null && (obj = this.dataSet.getCurrentRow()) != null && obj.getResultClass() != null) {
            this.metaData = new ResultMetaData(obj.getResultClass());
        }
        return this.metaData;
    }

    @Override
    public Object getColumnValue(int index) throws BirtException {
        if (index == 0) {
            return this.dataSet.getCurrentRowIndex();
        }
        return this.getAndCheckResultObject().getFieldValue(index);
    }

    @Override
    public Object getColumnValue(String name) throws BirtException {
        return this.getAndCheckResultObject().getFieldValue(name);
    }

    @Override
    public void setColumnValue(int index, Object value) throws BirtException {
        if (!this.dataSet.allowUpdateRowData()) {
            throw new DataException("data.engine.NoRowUpdate");
        }
        IResultObject obj = this.getAndCheckResultObject();
        Class fieldClass = obj.getResultClass().getFieldValueClass(index);
        if (fieldClass != DataType.AnyType.class) {
            try {
                value = DataTypeUtil.convert((Object)value, (Class)fieldClass);
            }
            catch (BirtException e) {
                if (obj.getResultClass() instanceof ResultClass) {
                    if (obj.getResultClass().wasAnyType(index)) {
                        throw new IllegalArgumentException(DataResourceHandle.getInstance().getMessage("data.engine.possibleMixedDataTypeInColumn"));
                    }
                }
                throw e;
            }
        }
        obj.setCustomFieldValue(index, value);
    }

    @Override
    public void setColumnValue(String name, Object value) throws BirtException {
        if (!this.dataSet.allowUpdateRowData()) {
            throw new DataException("data.engine.NoRowUpdate");
        }
        IResultObject obj = this.getAndCheckResultObject();
        Class fieldClass = obj.getResultClass().getFieldValueClass(name);
        if (fieldClass != DataType.AnyType.class) {
            try {
                value = DataTypeUtil.convert((Object)value, (Class)fieldClass);
            }
            catch (BirtException e) {
                if (obj.getResultClass() instanceof ResultClass) {
                    if (obj.getResultClass().wasAnyType(name)) {
                        throw new IllegalArgumentException(DataResourceHandle.getInstance().getMessage("data.engine.possibleMixedDataTypeInColumn"));
                    }
                }
                throw e;
            }
        }
        obj.setCustomFieldValue(name, value);
    }

    protected IResultObject getAndCheckResultObject() throws DataException {
        IResultObject resultObject = this.dataSet.getCurrentRow();
        if (resultObject == null) {
            throw new DataException("data.engine.NoCurrentRow");
        }
        return resultObject;
    }
}

