/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property;

import java.util.LinkedList;
import org.eclipse.birt.report.designer.internal.ui.views.memento.Memento;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoElement;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class PropertyMementoUtil {
    public static boolean addNode(Memento element, MementoElement[] nodePath) {
        if (nodePath != null && nodePath.length > 0) {
            MementoElement memento = element.getMementoElement();
            if (!memento.equals((Object)nodePath[0])) {
                return false;
            }
            int i = 1;
            while (i < nodePath.length) {
                MementoElement child = PropertyMementoUtil.getChild(memento, nodePath[i]);
                if (child == null) {
                    memento.addChild(nodePath[i]);
                    return true;
                }
                memento = child;
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean removeNode(Memento element, MementoElement[] nodePath) {
        if (nodePath != null && nodePath.length > 0) {
            MementoElement memento = element.getMementoElement();
            if (!memento.equals((Object)nodePath[0])) {
                return false;
            }
            int i = 1;
            while (i < nodePath.length) {
                MementoElement child = PropertyMementoUtil.getChild(memento, nodePath[i]);
                if (child == null) {
                    return false;
                }
                memento = child;
                ++i;
            }
            memento.getParent().removeChild(memento);
            return true;
        }
        return false;
    }

    private static MementoElement getChild(MementoElement parent, MementoElement key) {
        MementoElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].equals((Object)key)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    public static MementoElement[] getNodePath(MementoElement node) {
        LinkedList<MementoElement> pathList = new LinkedList<MementoElement>();
        MementoElement memento = node;
        pathList.add(node);
        while (memento.getChildren().length > 0) {
            pathList.add(memento.getChild(0));
            memento = memento.getChild(0);
        }
        MementoElement[] paths = new MementoElement[pathList.size()];
        pathList.toArray(paths);
        return paths;
    }

    public static String getElementType(DesignElementHandle handle) {
        String displayName = handle.getDefn().getDisplayName();
        if (displayName == null || "".equals(displayName)) {
            displayName = handle.getDefn().getName();
        }
        return displayName;
    }
}

