/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.report.designer.internal.ui.editors.FileReportDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.xml.XMLPartitionScanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class IDEFileReportDocumentProvider
extends FileReportDocumentProvider {
    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        File file;
        if (super.setDocumentContent(document, editorInput, encoding)) {
            return true;
        }
        IPath path = null;
        if (editorInput instanceof IPathEditorInput) {
            path = ((IPathEditorInput)editorInput).getPath();
        } else if (editorInput instanceof IURIEditorInput) {
            path = new Path(((IURIEditorInput)editorInput).getURI().getPath());
        }
        if (path == null || (file = path.toFile()) == null || !file.exists()) return false;
        FileInputStream stream = null;
        stream = new FileInputStream(file);
        this.setDocumentContent(document, stream, encoding);
        if (stream == null) return true;
        try {
            ((InputStream)stream).close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (Exception exception) {
            try {
                if (stream == null) return false;
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
    }
}

