/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;

public abstract class TableHFHandle
extends AbstractHandle {
    public static final int WIDTH = 40;
    public static final int HEIGHT = 19;

    public TableHFHandle(TableEditPart owner, Locator loc) {
        super((GraphicalEditPart)owner, loc);
        this.initialize();
    }

    protected DragTracker createDragTracker() {
        return null;
    }

    public boolean containsPoint(int x, int y) {
        return super.containsPoint(x, y);
    }

    protected void initialize() {
        this.setOpaque(true);
        LineBorder bd = new LineBorder(1);
        bd.setColor(ReportColorConstants.HandleBorderColor);
        this.setBorder((Border)bd);
        this.setCursor(Cursors.ARROW);
        this.initChildrenHandle();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
    }

    protected abstract void initChildrenHandle();

    protected int getRowHeight(Object row) {
        return TableUtil.caleVisualHeight(this.getTableEditPart(), row);
    }

    protected int getColumnWidth(Object column) {
        return TableUtil.caleVisualWidth(this.getTableEditPart(), column);
    }

    protected int getRowNumber(Object row) {
        RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(row);
        return adapt.getRowNumber();
    }

    protected int getColumnNumber(Object column) {
        ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(column);
        return adapt.getColumnNumber();
    }

    protected int getRowHeight(int rowNumber) {
        Object row = this.getTableEditPart().getRow(rowNumber);
        return this.getRowHeight(row);
    }

    protected int getColumnWidth(int columnNumber) {
        Object column = this.getTableEditPart().getColumn(columnNumber);
        if (column == null) {
            return HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableEditPart().getModel()).getDefaultWidth(columnNumber);
        }
        return this.getColumnWidth(column);
    }

    protected TableEditPart getTableEditPart() {
        return (TableEditPart)this.getOwner();
    }
}

